/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.base.util;

import android.annotation.SuppressLint;

public final class ConvertUtils {
    private static final int BUFFER_SIZE = 8192;
    private static final char[] HEX_DIGITS_UPPER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final char[] HEX_DIGITS_LOWER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private ConvertUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    @SuppressLint(value={"DefaultLocale"})
    public static String byte2FitMemorySize(long byteSize) {
        return ConvertUtils.byte2FitMemorySize(byteSize, 3);
    }

    @SuppressLint(value={"DefaultLocale"})
    public static String byte2FitMemorySize(long byteSize, int precision) {
        if (precision < 0) {
            throw new IllegalArgumentException("precision shouldn't be less than zero!");
        }
        if (byteSize < 0L) {
            return "0KB";
        }
        if (byteSize < 1024L) {
            return String.format("%." + precision + "fB", byteSize);
        }
        if (byteSize < 0x100000L) {
            return String.format("%." + precision + "fKB", (double)byteSize / 1024.0);
        }
        if (byteSize < 0x40000000L) {
            return String.format("%." + precision + "fMB", (double)byteSize / 1048576.0);
        }
        return String.format("%." + precision + "fGB", (double)byteSize / 1.073741824E9);
    }
}

