/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.base.util;

import android.util.Log;
import com.xshare.base.util.FileUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class FileIOUtils {
    private static int sBufferSize = 524288;

    private FileIOUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static boolean writeFileFromIS(String filePath, InputStream is) {
        return FileIOUtils.writeFileFromIS(FileUtils.getFileByPath(filePath), is, false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeFileFromIS(File file, InputStream is, boolean append, OnProgressUpdateListener listener) {
        if (is == null || !FileUtils.createOrExistsFile(file)) {
            Log.e((String)"FileIOUtils", (String)("create file <" + file + "> failed."));
            return false;
        }
        BufferedOutputStream os = null;
        try {
            os = new BufferedOutputStream(new FileOutputStream(file, append), sBufferSize);
            if (listener == null) {
                int len;
                byte[] data = new byte[sBufferSize];
                while ((len = is.read(data)) != -1) {
                    ((OutputStream)os).write(data, 0, len);
                }
            } else {
                int len;
                double totalSize = is.available();
                int curSize = 0;
                listener.onProgressUpdate(0.0);
                byte[] data = new byte[sBufferSize];
                while ((len = is.read(data)) != -1) {
                    ((OutputStream)os).write(data, 0, len);
                    listener.onProgressUpdate((double)(curSize += len) / totalSize);
                }
            }
            boolean totalSize = true;
            return totalSize;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ignored) {
                Log.e((String)"FileIOUtils", (String)"is IOException");
            }
            try {
                if (os != null) {
                    ((OutputStream)os).close();
                }
            }
            catch (IOException e) {
                Log.e((String)"FileIOUtils", (String)"os IOException");
            }
        }
    }

    public static interface OnProgressUpdateListener {
        public void onProgressUpdate(double var1);
    }
}

