/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.base.util;

import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.Context;
import android.content.Intent;
import android.content.res.AssetFileDescriptor;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.os.StatFs;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import android.text.TextUtils;
import android.util.Log;
import com.xshare.base.BaseApplication;
import com.xshare.base.util.ConvertUtils;
import com.xshare.base.util.FileIOUtils;
import com.xshare.base.util.StringUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public final class FileUtils {
    private static final String TAG = "FileUtils";
    private static final String LINE_SEP = System.getProperty("line.separator");

    private FileUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static String getPath(Context context, Uri uri) {
        boolean isKitKat;
        boolean bl = isKitKat = Build.VERSION.SDK_INT >= 19;
        if (isKitKat && DocumentsContract.isDocumentUri((Context)context, (Uri)uri)) {
            if (FileUtils.isExternalStorageDocument(uri)) {
                String docId = DocumentsContract.getDocumentId((Uri)uri);
                String[] split = docId.split(":");
                String type = split[0];
                if ("primary".equalsIgnoreCase(type)) {
                    return Environment.getExternalStorageDirectory() + "/" + split[1];
                }
            } else {
                if (FileUtils.isDownloadsDocument(uri)) {
                    String id = DocumentsContract.getDocumentId((Uri)uri);
                    Uri contentUri = ContentUris.withAppendedId((Uri)Uri.parse((String)"content://downloads/public_downloads"), (long)Long.valueOf(id));
                    return FileUtils.getDataColumn(context, contentUri, null, null);
                }
                if (FileUtils.isMediaDocument(uri)) {
                    String docId = DocumentsContract.getDocumentId((Uri)uri);
                    String[] split = docId.split(":");
                    String type = split[0];
                    Uri contentUri = null;
                    if ("image".equals(type)) {
                        contentUri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
                    } else if ("video".equals(type)) {
                        contentUri = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
                    } else if ("audio".equals(type)) {
                        contentUri = MediaStore.Audio.Media.EXTERNAL_CONTENT_URI;
                    }
                    String selection = "_id=?";
                    String[] selectionArgs = new String[]{split[1]};
                    return FileUtils.getDataColumn(context, contentUri, "_id=?", selectionArgs);
                }
            }
        } else {
            if ("content".equalsIgnoreCase(uri.getScheme())) {
                return FileUtils.getDataColumn(context, uri, null, null);
            }
            if ("file".equalsIgnoreCase(uri.getScheme())) {
                return uri.getPath();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDataColumn(Context context, Uri uri, String selection, String[] selectionArgs) {
        Cursor cursor = null;
        String column = "_data";
        String[] projection = new String[]{"_data"};
        try {
            cursor = context.getContentResolver().query(uri, projection, selection, selectionArgs, null);
            if (cursor != null && cursor.moveToFirst()) {
                int column_index = cursor.getColumnIndexOrThrow("_data");
                String string = cursor.getString(column_index);
                return string;
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return null;
    }

    public static boolean isExternalStorageDocument(Uri uri) {
        return "com.android.externalstorage.documents".equals(uri.getAuthority());
    }

    public static boolean isDownloadsDocument(Uri uri) {
        return "com.android.providers.downloads.documents".equals(uri.getAuthority());
    }

    public static boolean isMediaDocument(Uri uri) {
        return "com.android.providers.media.documents".equals(uri.getAuthority());
    }

    public static File getFileByPath(String filePath) {
        return StringUtils.isSpace(filePath) ? null : new File(filePath);
    }

    public static boolean isFileExists(File file) {
        if (file == null) {
            return false;
        }
        if (file.exists()) {
            return true;
        }
        return FileUtils.isFileExists(file.getAbsolutePath());
    }

    public static boolean isFileExists(String filePath) {
        File file = FileUtils.getFileByPath(filePath);
        if (file == null) {
            return false;
        }
        if (file.exists()) {
            return true;
        }
        return FileUtils.isFileExistsApi29(filePath);
    }

    private static boolean isFileExistsApi29(String filePath) {
        if (Build.VERSION.SDK_INT >= 29) {
            try {
                Uri uri = Uri.parse((String)filePath);
                ContentResolver cr = BaseApplication.Companion.getCONTEXT().getContentResolver();
                AssetFileDescriptor afd = cr.openAssetFileDescriptor(uri, "r");
                afd.close();
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean rename(String filePath, String newName) {
        return FileUtils.rename(FileUtils.getFileByPath(filePath), newName);
    }

    public static boolean rename(File file, String newName) {
        if (file == null) {
            return false;
        }
        if (!file.exists()) {
            return false;
        }
        if (StringUtils.isSpace(newName)) {
            return false;
        }
        if (newName.equals(file.getName())) {
            return true;
        }
        File newFile = new File(file.getParent() + File.separator + newName);
        return !newFile.exists() && file.renameTo(newFile);
    }

    public static boolean isDir(String dirPath) {
        return FileUtils.isDir(FileUtils.getFileByPath(dirPath));
    }

    public static boolean isDir(File file) {
        return file != null && file.exists() && file.isDirectory();
    }

    public static boolean isFile(String filePath) {
        return FileUtils.isFile(FileUtils.getFileByPath(filePath));
    }

    public static boolean isFile(File file) {
        return file != null && file.exists() && file.isFile();
    }

    public static boolean createOrExistsDir(String dirPath) {
        return FileUtils.createOrExistsDir(FileUtils.getFileByPath(dirPath));
    }

    public static boolean createOrExistsDir(File file) {
        return file != null && (file.exists() ? file.isDirectory() : file.mkdirs());
    }

    public static boolean createOrExistsFile(String filePath) {
        return FileUtils.createOrExistsFile(FileUtils.getFileByPath(filePath));
    }

    public static boolean createOrExistsFile(File file) {
        if (file == null) {
            return false;
        }
        if (file.exists()) {
            return file.isFile();
        }
        if (!FileUtils.createOrExistsDir(file.getParentFile())) {
            return false;
        }
        try {
            return file.createNewFile();
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean createFileByDeleteOldFile(String filePath) {
        return FileUtils.createFileByDeleteOldFile(FileUtils.getFileByPath(filePath));
    }

    public static boolean createFileByDeleteOldFile(File file) {
        if (file == null) {
            return false;
        }
        if (file.exists() && !file.delete()) {
            return false;
        }
        if (!FileUtils.createOrExistsDir(file.getParentFile())) {
            return false;
        }
        try {
            return file.createNewFile();
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean copy(String srcPath, String destPath) {
        return FileUtils.copy(FileUtils.getFileByPath(srcPath), FileUtils.getFileByPath(destPath), null);
    }

    public static boolean copy(String srcPath, String destPath, OnReplaceListener listener) {
        return FileUtils.copy(FileUtils.getFileByPath(srcPath), FileUtils.getFileByPath(destPath), listener);
    }

    public static boolean copy(File src, File dest) {
        return FileUtils.copy(src, dest, null);
    }

    public static boolean copy(File src, File dest, OnReplaceListener listener) {
        if (src == null) {
            return false;
        }
        if (src.isDirectory()) {
            return FileUtils.copyDir(src, dest, listener);
        }
        return FileUtils.copyFile(src, dest, listener);
    }

    private static boolean copyDir(File srcDir, File destDir, OnReplaceListener listener) {
        return FileUtils.copyOrMoveDir(srcDir, destDir, listener, false);
    }

    private static boolean copyFile(File srcFile, File destFile, OnReplaceListener listener) {
        return FileUtils.copyOrMoveFile(srcFile, destFile, listener, false);
    }

    public static boolean move(String srcPath, String destPath) {
        return FileUtils.move(FileUtils.getFileByPath(srcPath), FileUtils.getFileByPath(destPath), null);
    }

    public static boolean move(String srcPath, String destPath, OnReplaceListener listener) {
        return FileUtils.move(FileUtils.getFileByPath(srcPath), FileUtils.getFileByPath(destPath), listener);
    }

    public static boolean move(File src, File dest) {
        return FileUtils.move(src, dest, null);
    }

    public static boolean move(File src, File dest, OnReplaceListener listener) {
        if (src == null) {
            return false;
        }
        if (src.isDirectory()) {
            return FileUtils.moveDir(src, dest, listener);
        }
        return FileUtils.moveFile(src, dest, listener);
    }

    public static boolean moveDir(File srcDir, File destDir, OnReplaceListener listener) {
        return FileUtils.copyOrMoveDir(srcDir, destDir, listener, true);
    }

    public static boolean moveFile(File srcFile, File destFile, OnReplaceListener listener) {
        return FileUtils.copyOrMoveFile(srcFile, destFile, listener, true);
    }

    private static boolean copyOrMoveDir(File srcDir, File destDir, OnReplaceListener listener, boolean isMove) {
        if (srcDir == null || destDir == null) {
            return false;
        }
        String srcPath = srcDir.getPath() + File.separator;
        String destPath = destDir.getPath() + File.separator;
        if (destPath.contains(srcPath)) {
            return false;
        }
        if (!srcDir.exists() || !srcDir.isDirectory()) {
            return false;
        }
        if (!FileUtils.createOrExistsDir(destDir)) {
            return false;
        }
        File[] files = srcDir.listFiles();
        if (files != null && files.length > 0) {
            for (File file : files) {
                File oneDestFile = new File(destPath + file.getName());
                if (!(file.isFile() ? !FileUtils.copyOrMoveFile(file, oneDestFile, listener, isMove) : file.isDirectory() && !FileUtils.copyOrMoveDir(file, oneDestFile, listener, isMove))) continue;
                return false;
            }
        }
        return !isMove || FileUtils.deleteDir(srcDir);
    }

    private static boolean copyOrMoveFile(File srcFile, File destFile, OnReplaceListener listener, boolean isMove) {
        if (srcFile == null || destFile == null) {
            return false;
        }
        if (srcFile.equals(destFile)) {
            return false;
        }
        if (!srcFile.exists() || !srcFile.isFile()) {
            return false;
        }
        if (destFile.exists()) {
            if (listener == null || listener.onReplace(srcFile, destFile)) {
                if (!destFile.delete()) {
                    return false;
                }
            } else {
                return true;
            }
        }
        if (!FileUtils.createOrExistsDir(destFile.getParentFile())) {
            return false;
        }
        try {
            return FileIOUtils.writeFileFromIS(destFile.getAbsolutePath(), new FileInputStream(srcFile)) && (!isMove || FileUtils.deleteFile(srcFile));
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }

    public static boolean delete(String filePath) {
        return FileUtils.delete(FileUtils.getFileByPath(filePath));
    }

    public static boolean delete(File file) {
        if (file == null) {
            return false;
        }
        if (file.isDirectory()) {
            return FileUtils.deleteDir(file);
        }
        return FileUtils.deleteFile(file);
    }

    private static boolean deleteDir(File dir) {
        if (dir == null) {
            return false;
        }
        if (!dir.exists()) {
            return true;
        }
        if (!dir.isDirectory()) {
            return false;
        }
        File[] files = dir.listFiles();
        if (files != null && files.length > 0) {
            for (File file : files) {
                if (!(file.isFile() ? !file.delete() : file.isDirectory() && !FileUtils.deleteDir(file))) continue;
                return false;
            }
        }
        return dir.delete();
    }

    private static boolean deleteFile(File file) {
        return file != null && (!file.exists() || file.isFile() && file.delete());
    }

    public static boolean deleteAllInDir(String dirPath) {
        return FileUtils.deleteAllInDir(FileUtils.getFileByPath(dirPath));
    }

    public static boolean deleteAllInDir(File dir) {
        return FileUtils.deleteFilesInDirWithFilter(dir, (File pathname) -> true);
    }

    public static boolean deleteFilesInDir(String dirPath) {
        return FileUtils.deleteFilesInDir(FileUtils.getFileByPath(dirPath));
    }

    public static boolean deleteFilesInDir(File dir) {
        return FileUtils.deleteFilesInDirWithFilter(dir, File::isFile);
    }

    public static boolean deleteFilesInDirWithFilter(String dirPath, FileFilter filter) {
        return FileUtils.deleteFilesInDirWithFilter(FileUtils.getFileByPath(dirPath), filter);
    }

    public static boolean deleteFilesInDirWithFilter(File dir, FileFilter filter) {
        if (dir == null || filter == null) {
            return false;
        }
        if (!dir.exists()) {
            return true;
        }
        if (!dir.isDirectory()) {
            return false;
        }
        File[] files = dir.listFiles();
        if (files != null && files.length != 0) {
            for (File file : files) {
                if (!filter.accept(file) || !(file.isFile() ? !file.delete() : file.isDirectory() && !FileUtils.deleteDir(file))) continue;
                return false;
            }
        }
        return true;
    }

    public static List<File> listFilesInDir(String dirPath) {
        return FileUtils.listFilesInDir(dirPath, null);
    }

    public static List<File> listFilesInDir(File dir) {
        return FileUtils.listFilesInDir(dir, null);
    }

    public static List<File> listFilesInDir(String dirPath, Comparator<File> comparator) {
        return FileUtils.listFilesInDir(FileUtils.getFileByPath(dirPath), false, comparator);
    }

    public static List<File> listFilesInDir(File dir, Comparator<File> comparator) {
        return FileUtils.listFilesInDir(dir, false, comparator);
    }

    public static List<File> listFilesInDir(String dirPath, boolean isRecursive) {
        return FileUtils.listFilesInDir(FileUtils.getFileByPath(dirPath), isRecursive);
    }

    public static List<File> listFilesInDir(File dir, boolean isRecursive) {
        return FileUtils.listFilesInDir(dir, isRecursive, null);
    }

    public static List<File> listFilesInDir(String dirPath, boolean isRecursive, Comparator<File> comparator) {
        return FileUtils.listFilesInDir(FileUtils.getFileByPath(dirPath), isRecursive, comparator);
    }

    public static List<File> listFilesInDir(File dir, boolean isRecursive, Comparator<File> comparator) {
        return FileUtils.listFilesInDirWithFilter(dir, (File pathname) -> true, isRecursive, comparator);
    }

    public static List<File> listFilesInDirWithFilter(String dirPath, FileFilter filter) {
        return FileUtils.listFilesInDirWithFilter(FileUtils.getFileByPath(dirPath), filter);
    }

    public static List<File> listFilesInDirWithFilter(File dir, FileFilter filter) {
        return FileUtils.listFilesInDirWithFilter(dir, filter, false, null);
    }

    public static List<File> listFilesInDirWithFilter(String dirPath, FileFilter filter, Comparator<File> comparator) {
        return FileUtils.listFilesInDirWithFilter(FileUtils.getFileByPath(dirPath), filter, comparator);
    }

    public static List<File> listFilesInDirWithFilter(File dir, FileFilter filter, Comparator<File> comparator) {
        return FileUtils.listFilesInDirWithFilter(dir, filter, false, comparator);
    }

    public static List<File> listFilesInDirWithFilter(String dirPath, FileFilter filter, boolean isRecursive) {
        return FileUtils.listFilesInDirWithFilter(FileUtils.getFileByPath(dirPath), filter, isRecursive);
    }

    public static List<File> listFilesInDirWithFilter(File dir, FileFilter filter, boolean isRecursive) {
        return FileUtils.listFilesInDirWithFilter(dir, filter, isRecursive, null);
    }

    public static List<File> listFilesInDirWithFilter(String dirPath, FileFilter filter, boolean isRecursive, Comparator<File> comparator) {
        return FileUtils.listFilesInDirWithFilter(FileUtils.getFileByPath(dirPath), filter, isRecursive, comparator);
    }

    public static List<File> listFilesInDirWithFilter(File dir, FileFilter filter, boolean isRecursive, Comparator<File> comparator) {
        List<File> files = FileUtils.listFilesInDirWithFilterInner(dir, filter, isRecursive);
        if (comparator != null) {
            Collections.sort(files, comparator);
        }
        return files;
    }

    private static List<File> listFilesInDirWithFilterInner(File dir, FileFilter filter, boolean isRecursive) {
        ArrayList<File> list = new ArrayList<File>();
        if (!FileUtils.isDir(dir)) {
            return list;
        }
        File[] files = dir.listFiles();
        if (files != null && files.length > 0) {
            for (File file : files) {
                if (filter.accept(file)) {
                    list.add(file);
                }
                if (!isRecursive || !file.isDirectory()) continue;
                list.addAll(FileUtils.listFilesInDirWithFilterInner(file, filter, true));
            }
        }
        return list;
    }

    public static long getFileLastModified(String filePath) {
        return FileUtils.getFileLastModified(FileUtils.getFileByPath(filePath));
    }

    public static long getFileLastModified(File file) {
        if (file == null) {
            return -1L;
        }
        return file.lastModified();
    }

    public static String getFileCharsetSimple(String filePath) {
        return FileUtils.getFileCharsetSimple(FileUtils.getFileByPath(filePath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileCharsetSimple(File file) {
        if (file == null) {
            return "";
        }
        if (FileUtils.isUtf8(file)) {
            return "UTF-8";
        }
        int p = 0;
        InputStream is = null;
        try {
            is = new BufferedInputStream(new FileInputStream(file));
            p = (is.read() << 8) + is.read();
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"IOException");
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)"IOException");
            }
        }
        switch (p) {
            case 65534: {
                return "Unicode";
            }
            case 65279: {
                return "UTF-16BE";
            }
        }
        return "GBK";
    }

    public static boolean isUtf8(String filePath) {
        return FileUtils.isUtf8(FileUtils.getFileByPath(filePath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isUtf8(File file) {
        if (file == null) {
            return false;
        }
        InputStream is = null;
        try {
            byte[] bytes = new byte[24];
            is = new BufferedInputStream(new FileInputStream(file));
            int read = is.read(bytes);
            if (read != -1) {
                byte[] readArr = new byte[read];
                System.arraycopy(bytes, 0, readArr, 0, read);
                boolean bl = FileUtils.isUtf8(readArr) == 100;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"IOException");
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)"IOException");
            }
        }
        return false;
    }

    private static int isUtf8(byte[] raw) {
        int utf8 = 0;
        int ascii = 0;
        if (raw.length > 3 && raw[0] == -17 && raw[1] == -69 && raw[2] == -65) {
            return 100;
        }
        int len = raw.length;
        int child = 0;
        int i = 0;
        while (i < len) {
            if ((raw[i] & 0xFFFFFFFF) == -1 || (raw[i] & 0xFFFFFFFE) == -2) {
                return 0;
            }
            if (child == 0) {
                if ((raw[i] & 0x7F) == raw[i] && raw[i] != 0) {
                    ++ascii;
                } else if ((raw[i] & 0xFFFFFFC0) == -64) {
                    int bit = 0;
                    while (bit < 8 && ((byte)(128 >> bit) & raw[i]) == (byte)(128 >> bit)) {
                        child = bit++;
                    }
                    ++utf8;
                }
                ++i;
                continue;
            }
            child = raw.length - i > child ? child : raw.length - i;
            boolean currentNotUtf8 = false;
            for (int children = 0; children < child; ++children) {
                if ((raw[i + children] & 0xFFFFFF80) == -128) continue;
                if ((raw[i + children] & 0x7F) == raw[i + children] && raw[i] != 0) {
                    ++ascii;
                }
                currentNotUtf8 = true;
            }
            if (currentNotUtf8) {
                --utf8;
                ++i;
            } else {
                utf8 += child;
                i += child;
            }
            child = 0;
        }
        if (ascii == len) {
            return 100;
        }
        return (int)(100.0f * ((float)(utf8 + ascii) / (float)len));
    }

    public static int getFileLines(String filePath) {
        return FileUtils.getFileLines(FileUtils.getFileByPath(filePath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getFileLines(File file) {
        int count = 1;
        InputStream is = null;
        try {
            is = new BufferedInputStream(new FileInputStream(file));
            byte[] buffer = new byte[1024];
            if (LINE_SEP.endsWith("\n")) {
                int readChars;
                while ((readChars = is.read(buffer, 0, 1024)) != -1) {
                    for (int i = 0; i < readChars; ++i) {
                        if (buffer[i] != 10) continue;
                        ++count;
                    }
                }
            } else {
                int readChars;
                while ((readChars = is.read(buffer, 0, 1024)) != -1) {
                    for (int i = 0; i < readChars; ++i) {
                        if (buffer[i] != 13) continue;
                        ++count;
                    }
                }
            }
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"IOException");
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)"IOException");
            }
        }
        return count;
    }

    public static String getSize(String filePath) {
        return FileUtils.getSize(FileUtils.getFileByPath(filePath));
    }

    public static String getSize(File file) {
        if (file == null) {
            return "";
        }
        if (file.isDirectory()) {
            return FileUtils.getDirSize(file);
        }
        return FileUtils.getFileSize(file);
    }

    private static String getDirSize(File dir) {
        long len = FileUtils.getDirLength(dir);
        return len == -1L ? "" : ConvertUtils.byte2FitMemorySize(len);
    }

    private static String getFileSize(File file) {
        long len = FileUtils.getFileLength(file);
        return len == -1L ? "" : ConvertUtils.byte2FitMemorySize(len);
    }

    public static long getLength(String filePath) {
        return FileUtils.getLength(FileUtils.getFileByPath(filePath));
    }

    public static long getLength(File file) {
        if (file == null) {
            return 0L;
        }
        if (file.isDirectory()) {
            return FileUtils.getDirLength(file);
        }
        return FileUtils.getFileLength(file);
    }

    private static long getDirLength(File dir) {
        if (!FileUtils.isDir(dir)) {
            return 0L;
        }
        long len = 0L;
        File[] files = dir.listFiles();
        if (files != null && files.length > 0) {
            for (File file : files) {
                if (file.isDirectory()) {
                    len += FileUtils.getDirLength(file);
                    continue;
                }
                len += file.length();
            }
        }
        return len;
    }

    private static long getFileLength(File file) {
        if (!FileUtils.isFile(file)) {
            return -1L;
        }
        return file.length();
    }

    public static void notifySystemToScan(File file) {
        if (file == null || !file.exists()) {
            return;
        }
        Intent intent = new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE");
        intent.setData(Uri.parse((String)("file://" + file.getAbsolutePath())));
        BaseApplication.Companion.getCONTEXT().sendBroadcast(intent);
    }

    public static long getFsTotalSize(String anyPathInFs) {
        long totalSize;
        long blockSize;
        if (TextUtils.isEmpty((CharSequence)anyPathInFs)) {
            return 0L;
        }
        StatFs statFs = new StatFs(anyPathInFs);
        if (Build.VERSION.SDK_INT >= 18) {
            blockSize = statFs.getBlockSizeLong();
            totalSize = statFs.getBlockCountLong();
        } else {
            blockSize = statFs.getBlockSize();
            totalSize = statFs.getBlockCount();
        }
        return blockSize * totalSize;
    }

    public static long getFsAvailableSize(String anyPathInFs) {
        long availableSize;
        long blockSize;
        if (TextUtils.isEmpty((CharSequence)anyPathInFs)) {
            return 0L;
        }
        StatFs statFs = new StatFs(anyPathInFs);
        if (Build.VERSION.SDK_INT >= 18) {
            blockSize = statFs.getBlockSizeLong();
            availableSize = statFs.getAvailableBlocksLong();
        } else {
            blockSize = statFs.getBlockSize();
            availableSize = statFs.getAvailableBlocks();
        }
        return blockSize * availableSize;
    }

    public static interface OnReplaceListener {
        public boolean onReplace(File var1, File var2);
    }
}

