/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.base.util;

import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.text.format.Formatter;
import androidx.annotation.RequiresPermission;
import com.xshare.base.BaseApplication;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;

public final class NetworkUtils {
    private static final String TAG = "NetworkUtils";

    private NetworkUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static void openWirelessSettings() {
        BaseApplication.Companion.getCONTEXT().startActivity(new Intent("android.settings.WIRELESS_SETTINGS").setFlags(0x10000000));
    }

    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    public static boolean isConnected() {
        NetworkInfo info = NetworkUtils.getActiveNetworkInfo();
        return info != null && info.isConnected();
    }

    @RequiresPermission(value="android.permission.INTERNET")
    public static boolean isAvailable() {
        return NetworkUtils.isAvailableByDns();
    }

    @RequiresPermission(value="android.permission.INTERNET")
    public static boolean isAvailableByDns() {
        return NetworkUtils.isAvailableByDns("");
    }

    @RequiresPermission(value="android.permission.INTERNET")
    public static boolean isAvailableByDns(String domain) {
        String realDomain = TextUtils.isEmpty((CharSequence)domain) ? "www.baidu.com" : domain;
        try {
            InetAddress inetAddress = InetAddress.getByName(realDomain);
            return inetAddress != null;
        }
        catch (UnknownHostException e) {
            return false;
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    public static boolean isMobileData() {
        NetworkInfo info = NetworkUtils.getActiveNetworkInfo();
        return null != info && info.isAvailable() && info.getType() == 0;
    }

    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    public static boolean is4G() {
        NetworkInfo info = NetworkUtils.getActiveNetworkInfo();
        return info != null && info.isAvailable() && info.getSubtype() == 13;
    }

    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    public static boolean is5G() {
        NetworkInfo info = NetworkUtils.getActiveNetworkInfo();
        return info != null && info.isAvailable() && info.getSubtype() == 20;
    }

    @RequiresPermission(value="android.permission.ACCESS_WIFI_STATE")
    public static boolean getWifiEnabled() {
        WifiManager manager = (WifiManager)BaseApplication.Companion.getCONTEXT().getSystemService("wifi");
        if (manager == null) {
            return false;
        }
        return manager.isWifiEnabled();
    }

    @RequiresPermission(value="android.permission.CHANGE_WIFI_STATE")
    public static void setWifiEnabled(boolean enabled) {
        WifiManager manager = (WifiManager)BaseApplication.Companion.getCONTEXT().getSystemService("wifi");
        if (manager == null) {
            return;
        }
        if (enabled == manager.isWifiEnabled()) {
            return;
        }
        manager.setWifiEnabled(enabled);
    }

    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    public static boolean isWifiConnected() {
        ConnectivityManager cm = (ConnectivityManager)BaseApplication.Companion.getCONTEXT().getSystemService("connectivity");
        if (cm == null) {
            return false;
        }
        NetworkInfo ni = cm.getActiveNetworkInfo();
        return ni != null && ni.getType() == 1;
    }

    @RequiresPermission(allOf={"android.permission.ACCESS_WIFI_STATE", "android.permission.INTERNET"})
    public static boolean isWifiAvailable() {
        return NetworkUtils.getWifiEnabled() && NetworkUtils.isAvailable();
    }

    public static String getNetworkOperatorName() {
        TelephonyManager tm = (TelephonyManager)BaseApplication.Companion.getCONTEXT().getSystemService("phone");
        if (tm == null) {
            return "";
        }
        return tm.getNetworkOperatorName();
    }

    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    public static NetworkType getNetworkType() {
        if (NetworkUtils.isEthernet()) {
            return NetworkType.NETWORK_ETHERNET;
        }
        NetworkInfo info = NetworkUtils.getActiveNetworkInfo();
        if (info != null && info.isAvailable()) {
            if (info.getType() == 1) {
                return NetworkType.NETWORK_WIFI;
            }
            if (info.getType() == 0) {
                switch (info.getSubtype()) {
                    case 1: 
                    case 2: 
                    case 4: 
                    case 7: 
                    case 11: 
                    case 16: {
                        return NetworkType.NETWORK_2G;
                    }
                    case 3: 
                    case 5: 
                    case 6: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 12: 
                    case 14: 
                    case 15: 
                    case 17: {
                        return NetworkType.NETWORK_3G;
                    }
                    case 13: 
                    case 18: {
                        return NetworkType.NETWORK_4G;
                    }
                    case 20: {
                        return NetworkType.NETWORK_5G;
                    }
                }
                String subtypeName = info.getSubtypeName();
                if (subtypeName.equalsIgnoreCase("TD-SCDMA") || subtypeName.equalsIgnoreCase("WCDMA") || subtypeName.equalsIgnoreCase("CDMA2000")) {
                    return NetworkType.NETWORK_3G;
                }
                return NetworkType.NETWORK_UNKNOWN;
            }
            return NetworkType.NETWORK_UNKNOWN;
        }
        return NetworkType.NETWORK_NO;
    }

    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    private static boolean isEthernet() {
        ConnectivityManager cm = (ConnectivityManager)BaseApplication.Companion.getCONTEXT().getSystemService("connectivity");
        if (cm == null) {
            return false;
        }
        NetworkInfo info = cm.getNetworkInfo(9);
        if (info == null) {
            return false;
        }
        NetworkInfo.State state = info.getState();
        if (null == state) {
            return false;
        }
        return state == NetworkInfo.State.CONNECTED || state == NetworkInfo.State.CONNECTING;
    }

    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    private static NetworkInfo getActiveNetworkInfo() {
        ConnectivityManager cm = (ConnectivityManager)BaseApplication.Companion.getCONTEXT().getSystemService("connectivity");
        if (cm == null) {
            return null;
        }
        return cm.getActiveNetworkInfo();
    }

    @RequiresPermission(value="android.permission.INTERNET")
    public static String getIPAddress(boolean useIPv4) {
        try {
            Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
            LinkedList<InetAddress> adds = new LinkedList<InetAddress>();
            while (nis.hasMoreElements()) {
                NetworkInterface ni = nis.nextElement();
                if (!ni.isUp() || ni.isLoopback()) continue;
                Enumeration<InetAddress> addresses = ni.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    adds.addFirst(addresses.nextElement());
                }
            }
            for (InetAddress add : adds) {
                boolean isIPv4;
                if (add.isLoopbackAddress()) continue;
                String hostAddress = add.getHostAddress();
                boolean bl = isIPv4 = hostAddress.indexOf(58) < 0;
                if (useIPv4) {
                    if (!isIPv4) continue;
                    return hostAddress;
                }
                if (isIPv4) continue;
                int index = hostAddress.indexOf(37);
                return index < 0 ? hostAddress.toUpperCase() : hostAddress.substring(0, index).toUpperCase();
            }
        }
        catch (SocketException e) {
            return "";
        }
        return "";
    }

    public static String getBroadcastIpAddress() {
        try {
            Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
            while (nis.hasMoreElements()) {
                NetworkInterface ni = nis.nextElement();
                if (!ni.isUp() || ni.isLoopback()) continue;
                List<InterfaceAddress> ias = ni.getInterfaceAddresses();
                int size = ias.size();
                for (int i = 0; i < size; ++i) {
                    InterfaceAddress ia = ias.get(i);
                    InetAddress broadcast = ia.getBroadcast();
                    if (broadcast == null) continue;
                    return broadcast.getHostAddress();
                }
            }
        }
        catch (SocketException e) {
            return "";
        }
        return "";
    }

    @RequiresPermission(value="android.permission.INTERNET")
    public static String getDomainAddress(String domain) {
        try {
            InetAddress inetAddress = InetAddress.getByName(domain);
            return inetAddress.getHostAddress();
        }
        catch (UnknownHostException e) {
            return "";
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_WIFI_STATE")
    public static String getIpAddressByWifi() {
        WifiManager wm = (WifiManager)BaseApplication.Companion.getCONTEXT().getSystemService("wifi");
        if (wm == null) {
            return "";
        }
        return Formatter.formatIpAddress((int)wm.getDhcpInfo().ipAddress);
    }

    @RequiresPermission(value="android.permission.ACCESS_WIFI_STATE")
    public static String getGatewayByWifi() {
        WifiManager wm = (WifiManager)BaseApplication.Companion.getCONTEXT().getSystemService("wifi");
        if (wm == null) {
            return "";
        }
        return Formatter.formatIpAddress((int)wm.getDhcpInfo().gateway);
    }

    @RequiresPermission(value="android.permission.ACCESS_WIFI_STATE")
    public static String getNetMaskByWifi() {
        WifiManager wm = (WifiManager)BaseApplication.Companion.getCONTEXT().getSystemService("wifi");
        if (wm == null) {
            return "";
        }
        return Formatter.formatIpAddress((int)wm.getDhcpInfo().netmask);
    }

    @RequiresPermission(value="android.permission.ACCESS_WIFI_STATE")
    public static String getServerAddressByWifi() {
        WifiManager wm = (WifiManager)BaseApplication.Companion.getCONTEXT().getSystemService("wifi");
        if (wm == null) {
            return "";
        }
        return Formatter.formatIpAddress((int)wm.getDhcpInfo().serverAddress);
    }

    @RequiresPermission(value="android.permission.ACCESS_WIFI_STATE")
    public static String getSSID() {
        WifiManager wm = (WifiManager)BaseApplication.Companion.getCONTEXT().getApplicationContext().getSystemService("wifi");
        if (wm == null) {
            return "";
        }
        WifiInfo wi = wm.getConnectionInfo();
        if (wi == null) {
            return "";
        }
        String ssid = wi.getSSID();
        if (TextUtils.isEmpty((CharSequence)ssid)) {
            return "";
        }
        if (ssid.length() > 2 && ssid.charAt(0) == '\"' && ssid.charAt(ssid.length() - 1) == '\"') {
            return ssid.substring(1, ssid.length() - 1);
        }
        return ssid;
    }

    public static enum NetworkType {
        NETWORK_ETHERNET,
        NETWORK_WIFI,
        NETWORK_5G,
        NETWORK_4G,
        NETWORK_3G,
        NETWORK_2G,
        NETWORK_UNKNOWN,
        NETWORK_NO;

    }
}

