/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.base.util.spannable;

import android.content.Context;
import android.graphics.Color;
import android.text.SpannableString;
import android.text.method.LinkMovementMethod;
import android.text.style.ClickableSpan;
import android.widget.TextView;
import com.xshare.base.util.spannable.ChangeItem;
import com.xshare.base.util.spannable.SpannableHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0005J\u0014\u0010\u0010\u001a\u00020\u00002\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u0012J\u0006\u0010\u0013\u001a\u00020\u0000J\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u0017\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\rR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/xshare/base/util/spannable/SpannableBuilder;", "", "()V", "changeItemList", "", "Lcom/xshare/base/util/spannable/ChangeItem;", "content", "", "context", "Landroid/content/Context;", "spannableString", "Landroid/text/SpannableString;", "tv", "Landroid/widget/TextView;", "addChangeItem", "item", "addChangeItems", "items", "", "build", "removeSpan", "", "setContent", "setTextView", "app_release"})
public final class SpannableBuilder {
    private Context context;
    @Nullable
    private TextView tv;
    @Nullable
    private String content = "";
    @Nullable
    private SpannableString spannableString;
    @NotNull
    private final List<ChangeItem> changeItemList = new ArrayList();

    @NotNull
    public final SpannableBuilder setTextView(@NotNull TextView tv) {
        Intrinsics.checkNotNullParameter((Object)tv, (String)"tv");
        this.tv = tv;
        Context context = tv.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"tv.context");
        this.context = context;
        return this;
    }

    @NotNull
    public final SpannableBuilder setContent(@NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        this.content = content;
        return this;
    }

    @NotNull
    public final SpannableBuilder addChangeItem(@NotNull ChangeItem item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        this.changeItemList.add(item);
        return this;
    }

    @NotNull
    public final SpannableBuilder addChangeItems(@NotNull List<ChangeItem> items) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        this.changeItemList.addAll((Collection<ChangeItem>)items);
        return this;
    }

    @NotNull
    public final SpannableBuilder build() {
        Context context;
        TextView textView = this.tv;
        if (textView != null) {
            textView.setHighlightColor(Color.parseColor((String)"#00ffffff"));
        }
        TextView textView2 = this.tv;
        if (textView2 != null) {
            textView2.setMovementMethod(LinkMovementMethod.getInstance());
        }
        if ((context = this.context) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"context");
            context = null;
        }
        this.spannableString = SpannableHelper.INSTANCE.changeMultiPart(context, this.content, this.changeItemList);
        TextView textView3 = this.tv;
        if (textView3 != null) {
            textView3.setText((CharSequence)this.spannableString);
        }
        return this;
    }

    public final void removeSpan() {
        SpannableString spannableString = this.spannableString;
        if (spannableString != null) {
            SpannableString it = spannableString;
            boolean bl = false;
            ClickableSpan[] spans = (ClickableSpan[])it.getSpans(0, it.length(), ClickableSpan.class);
            Intrinsics.checkNotNullExpressionValue((Object)spans, (String)"spans");
            ClickableSpan[] $this$forEach$iv = spans;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                ClickableSpan element$iv;
                ClickableSpan span = element$iv = $this$forEach$iv[i];
                boolean bl2 = false;
                it.removeSpan((Object)span);
            }
        }
    }
}

