/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.base.util.spannable;

import android.content.Context;
import android.text.SpannableString;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.ClickableSpan;
import android.text.style.ForegroundColorSpan;
import android.text.style.ImageSpan;
import android.view.View;
import android.widget.TextView;
import com.xshare.base.util.spannable.ChangeItem;
import com.xshare.base.util.spannable.SpannableBuilder;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ*\u0010\f\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u000eJ*\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u000e2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\u000eJ\u001e\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0010J\u001e\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u0010J\u0016\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\u001c"}, d2={"Lcom/xshare/base/util/spannable/SpannableHelper;", "", "()V", "changeMultiPart", "Landroid/text/SpannableString;", "context", "Landroid/content/Context;", "content", "", "changeItems", "", "Lcom/xshare/base/util/spannable/ChangeItem;", "changeMultiPartTextColor", "changeList", "", "colorList", "", "changeMultiPartTextSize", "sizeList", "changePartTextColor", "changeStr", "color", "changePartTextSize", "size", "with", "Lcom/xshare/base/util/spannable/SpannableBuilder;", "tv", "Landroid/widget/TextView;", "app_release"})
public final class SpannableHelper {
    @NotNull
    public static final SpannableHelper INSTANCE = new SpannableHelper();

    private SpannableHelper() {
    }

    @NotNull
    public final SpannableBuilder with(@NotNull TextView tv, @NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)tv, (String)"tv");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        SpannableBuilder builder = new SpannableBuilder();
        builder.setContent(content);
        return builder.setTextView(tv);
    }

    @NotNull
    public final SpannableString changePartTextSize(@NotNull String content, @NotNull String changeStr, int size) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)changeStr, (String)"changeStr");
        int start = StringsKt.indexOf$default((CharSequence)content, (String)changeStr, (int)0, (boolean)false, (int)6, null);
        int end = start + changeStr.length();
        SpannableString span = new SpannableString((CharSequence)content);
        if (start == -1 || end == -1) {
            return span;
        }
        span.setSpan((Object)new AbsoluteSizeSpan(size), start, end, 17);
        return span;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final SpannableString changeMultiPartTextSize(@NotNull String content, @NotNull List<String> changeList, @NotNull List<Integer> sizeList) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter(changeList, (String)"changeList");
        Intrinsics.checkNotNullParameter(sizeList, (String)"sizeList");
        SpannableString span = new SpannableString((CharSequence)content);
        if (changeList.isEmpty() || sizeList.isEmpty() || changeList.size() != sizeList.size()) {
            return span;
        }
        Iterable $this$forEachIndexed$iv = changeList;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void changeStr;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string2 = (String)item$iv;
            int index = n;
            boolean bl = false;
            int start = StringsKt.indexOf$default((CharSequence)content, (String)changeStr, (int)0, (boolean)false, (int)6, null);
            int end = start + changeStr.length();
            if (start == -1 || end == -1) continue;
            span.setSpan((Object)new AbsoluteSizeSpan(((Number)sizeList.get(index)).intValue()), start, end, 17);
        }
        return span;
    }

    @NotNull
    public final SpannableString changePartTextColor(@NotNull String content, @NotNull String changeStr, int color2) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)changeStr, (String)"changeStr");
        int start = StringsKt.indexOf$default((CharSequence)content, (String)changeStr, (int)0, (boolean)false, (int)6, null);
        int end = start + changeStr.length();
        SpannableString span = new SpannableString((CharSequence)content);
        if (start == -1 || end == -1) {
            return span;
        }
        span.setSpan((Object)new ForegroundColorSpan(color2), start, end, 17);
        return span;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final SpannableString changeMultiPartTextColor(@NotNull String content, @NotNull List<String> changeList, @NotNull List<Integer> colorList) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter(changeList, (String)"changeList");
        Intrinsics.checkNotNullParameter(colorList, (String)"colorList");
        SpannableString span = new SpannableString((CharSequence)content);
        if (changeList.isEmpty() || colorList.isEmpty() || changeList.size() != colorList.size()) {
            return span;
        }
        Iterable $this$forEachIndexed$iv = changeList;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void changeStr;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string2 = (String)item$iv;
            int index = n;
            boolean bl = false;
            int start = StringsKt.indexOf$default((CharSequence)content, (String)changeStr, (int)0, (boolean)false, (int)6, null);
            int end = start + changeStr.length();
            if (start == -1 || end == -1) continue;
            span.setSpan((Object)new ForegroundColorSpan(((Number)colorList.get(index)).intValue()), start, end, 17);
        }
        return span;
    }

    @NotNull
    public final SpannableString changeMultiPart(@NotNull Context context, @Nullable String content, @NotNull List<ChangeItem> changeItems) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(changeItems, (String)"changeItems");
        SpannableString spannable = new SpannableString((CharSequence)content);
        if (TextUtils.isEmpty((CharSequence)content) || changeItems.isEmpty()) {
            return spannable;
        }
        Iterable $this$forEach$iv = changeItems;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ChangeItem it = (ChangeItem)element$iv;
            boolean bl = false;
            String changeStr = it.getPartStr();
            String string2 = content;
            Intrinsics.checkNotNull((Object)string2);
            int startIndex = StringsKt.indexOf$default((CharSequence)string2, (String)changeStr, (int)0, (boolean)false, (int)6, null);
            int endIndex = startIndex + changeStr.length();
            if (startIndex == -1 || endIndex == -1) continue;
            if (it.getClickListener() != null) {
                ClickableSpan clickableSpan2 = new ClickableSpan(it, changeStr){
                    final /* synthetic */ ChangeItem $it;
                    final /* synthetic */ String $changeStr;
                    {
                        this.$it = $it;
                        this.$changeStr = $changeStr;
                    }

                    public void onClick(@NotNull View view) {
                        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
                        this.$it.getClickListener().onTextClick(this.$changeStr);
                    }

                    public void updateDrawState(@NotNull TextPaint ds) {
                        Intrinsics.checkNotNullParameter((Object)ds, (String)"ds");
                        super.updateDrawState(ds);
                        ds.setUnderlineText(false);
                    }
                };
                spannable.setSpan((Object)clickableSpan2, startIndex, endIndex, 33);
            }
            switch (WhenMappings.$EnumSwitchMapping$0[it.getType().ordinal()]) {
                case 1: {
                    spannable.setSpan((Object)new ForegroundColorSpan(it.getValue()), startIndex, endIndex, 17);
                    break;
                }
                case 2: {
                    spannable.setSpan((Object)new AbsoluteSizeSpan(it.getValue()), startIndex, endIndex, 17);
                    break;
                }
                case 3: {
                    spannable.setSpan((Object)new ImageSpan(context, it.getValue(), 1), startIndex, endIndex, 33);
                }
            }
        }
        return spannable;
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ChangeItem.Type.values().length];
            nArray[ChangeItem.Type.COLOR.ordinal()] = 1;
            nArray[ChangeItem.Type.SIZE.ordinal()] = 2;
            nArray[ChangeItem.Type.ICON.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

