/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.base.util.toast;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.LifecycleRegistry;
import com.xshare.base.util.toast.CancelRunnable;
import com.xshare.base.util.toast.OnClickListener;
import com.xshare.base.util.toast.OnToastListener;
import com.xshare.base.util.toast.OnTouchListener;
import com.xshare.base.util.toast.ToastLifecycle;
import com.xshare.base.util.toast.ViewClickWrapper;
import com.xshare.base.util.toast.ViewTouchWrapper;
import com.xshare.base.util.toast.draggable.BaseDraggable;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\f\n\u0002\u0010\r\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\rJ\u0006\u0010\u0019\u001a\u00020\u0000J\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\rJ!\u0010\u001b\u001a\u0004\u0018\u0001H\u001c\"\n\b\u0000\u0010\u001c*\u0004\u0018\u00010\u00112\u0006\u0010\u001d\u001a\u00020\r\u00a2\u0006\u0002\u0010\u001eJ\b\u0010\u001f\u001a\u0004\u0018\u00010\u0003J\b\u0010 \u001a\u0004\u0018\u00010\u0006J\b\u0010!\u001a\u0004\u0018\u00010\u0011J\b\u0010\"\u001a\u0004\u0018\u00010\u0014J\b\u0010#\u001a\u0004\u0018\u00010\u0016J\u000e\u0010$\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\rJ\u0006\u0010%\u001a\u00020\bJ\u0010\u0010&\u001a\u00020\b2\b\u0010'\u001a\u0004\u0018\u00010(J\u0018\u0010)\u001a\u00020\b2\b\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010*\u001a\u00020+J\u0018\u0010,\u001a\u00020\b2\b\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010-\u001a\u00020+J\u0006\u0010.\u001a\u00020/J\u0006\u00100\u001a\u00020/J\u000e\u00101\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\rJ\u0018\u00102\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\r2\b\u00103\u001a\u0004\u0018\u000104J\u0016\u00102\u001a\u00020\u00002\u0006\u00105\u001a\u00020\r2\u0006\u00106\u001a\u00020\rJ\u000e\u00107\u001a\u00020\u00002\u0006\u00108\u001a\u000209J\u000e\u0010:\u001a\u00020\u00002\u0006\u0010;\u001a\u00020\bJ\u0010\u0010<\u001a\u00020\u00002\b\u0010=\u001a\u0004\u0018\u00010\u000bJ\u000e\u0010>\u001a\u00020\u00002\u0006\u0010?\u001a\u00020\rJ\u000e\u0010@\u001a\u00020\u00002\u0006\u0010A\u001a\u00020\rJ\u000e\u0010B\u001a\u00020\u00002\u0006\u0010C\u001a\u00020\rJ\u0018\u0010D\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\r2\b\u0010E\u001a\u0004\u0018\u00010FJ\u0016\u0010D\u001a\u00020\u00002\u0006\u00105\u001a\u00020\r2\u0006\u0010G\u001a\u00020\rJ\u0016\u0010H\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\r2\u0006\u0010I\u001a\u00020\rJ\u0018\u0010J\u001a\u00020\u00002\u0006\u00105\u001a\u00020\r2\b\u00103\u001a\u0004\u0018\u000104J\u0016\u0010J\u001a\u00020\u00002\u0006\u00105\u001a\u00020\r2\u0006\u00106\u001a\u00020\rJ \u0010K\u001a\u00020\u00002\b\u0010L\u001a\u0004\u0018\u00010\u00112\f\u0010M\u001a\b\u0012\u0004\u0012\u00020\u00110NH\u0002J\u0014\u0010K\u001a\u00020\u00002\f\u0010M\u001a\b\u0012\u0004\u0012\u00020\u00110NJ\u001c\u0010K\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\r2\f\u0010M\u001a\b\u0012\u0004\u0012\u00020\u00110NJ\u0010\u0010O\u001a\u00020\u00002\b\u0010M\u001a\u0004\u0018\u00010\u000fJ \u0010P\u001a\u00020\u00002\b\u0010L\u001a\u0004\u0018\u00010\u00112\f\u0010M\u001a\b\u0012\u0004\u0012\u00020\u00110QH\u0002J\u0014\u0010P\u001a\u00020\u00002\f\u0010M\u001a\b\u0012\u0004\u0012\u00020\u00110QJ\u001c\u0010P\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\r2\f\u0010M\u001a\b\u0012\u0004\u0012\u00020\u00110QJ\u000e\u0010R\u001a\u00020\u00002\u0006\u0010S\u001a\u00020\rJ\u000e\u0010T\u001a\u00020\u00002\u0006\u0010U\u001a\u00020\bJ\u0010\u0010V\u001a\u00020\u00002\b\u0010E\u001a\u0004\u0018\u00010FJ\u000e\u0010V\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\rJ\u0018\u0010V\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\r2\b\u0010E\u001a\u0004\u0018\u00010FJ\u0016\u0010V\u001a\u00020\u00002\u0006\u00105\u001a\u00020\r2\u0006\u0010G\u001a\u00020\rJ\u0016\u0010W\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\r2\u0006\u0010I\u001a\u00020\rJ\u0012\u0010X\u001a\u00020\u00002\b\u0010L\u001a\u0004\u0018\u00010\u0011H\u0002J\u000e\u0010X\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\rJ\u0016\u0010Y\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\r2\u0006\u0010Z\u001a\u00020\rJ\u000e\u0010[\u001a\u00020\u00002\u0006\u0010\\\u001a\u00020\rJ\u000e\u0010]\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\rJ\u0010\u0010^\u001a\u00020\u00002\b\u0010_\u001a\u0004\u0018\u00010\u0016J\u000e\u0010`\u001a\u00020\u00002\u0006\u0010a\u001a\u00020\rJ\u000e\u0010b\u001a\u00020\u00002\u0006\u0010c\u001a\u00020\rJ\u000e\u0010d\u001a\u00020\u00002\u0006\u0010e\u001a\u00020\rJ\u0012\u0010f\u001a\u00020\u00002\n\b\u0002\u0010g\u001a\u0004\u0018\u00010hJ\u000e\u0010i\u001a\u00020/2\u0006\u0010j\u001a\u00020kJ\u001a\u0010i\u001a\u00020/2\u0012\u0010l\u001a\u000e\u0012\b\b\u0001\u0012\u0004\u0018\u00010n\u0018\u00010mJ\u0006\u0010o\u001a\u00020/R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006p"}, d2={"Lcom/xshare/base/util/toast/XToast;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "HANDLER", "Landroid/os/Handler;", "mCanAutoCancel", "", "mContext", "mDraggable", "Lcom/xshare/base/util/toast/draggable/BaseDraggable;", "mDuration", "", "mListener", "Lcom/xshare/base/util/toast/OnToastListener;", "mRootView", "Landroid/view/View;", "mShow", "mWindowManager", "Landroid/view/WindowManager;", "mWindowParams", "Landroid/view/WindowManager$LayoutParams;", "addWindowFlags", "flags", "cancel", "clearWindowFlags", "findViewById", "V", "id", "(I)Landroid/view/View;", "getContext", "getHandler", "getView", "getWindowManager", "getWindowParams", "hasWindowFlags", "isShow", "post", "r", "Ljava/lang/Runnable;", "postAtTime", "uptimeMillis", "", "postDelayed", "delayMillis", "recycle", "", "removeCallbacks", "setAnimStyle", "setBackground", "drawable", "Landroid/graphics/drawable/Drawable;", "viewId", "drawableId", "setBackgroundDimAmount", "amount", "", "setCanAutoCancel", "canAutoCancel", "setDraggable", "draggable", "setDuration", "duration", "setGravity", "gravity", "setHeight", "height", "setHint", "text", "", "stringId", "setHintColor", "color", "setImageDrawable", "setOnClickListener", "view", "listener", "Lcom/xshare/base/util/toast/OnClickListener;", "setOnToastListener", "setOnTouchListener", "Lcom/xshare/base/util/toast/OnTouchListener;", "setOrientation", "orientation", "setOutsideTouchable", "touchable", "setText", "setTextColor", "setView", "setVisibility", "visibility", "setWidth", "width", "setWindowFlags", "setWindowParams", "params", "setWindowType", "type", "setXOffset", "x", "setYOffset", "y", "show", "lifecycleOwner", "Landroidx/lifecycle/LifecycleOwner;", "startActivity", "intent", "Landroid/content/Intent;", "clazz", "Ljava/lang/Class;", "Landroid/app/Activity;", "update", "app_release"})
public final class XToast {
    @NotNull
    private final Handler HANDLER;
    @Nullable
    private Context mContext;
    @Nullable
    private View mRootView;
    @Nullable
    private WindowManager mWindowManager;
    @Nullable
    private WindowManager.LayoutParams mWindowParams;
    private boolean mShow;
    private int mDuration;
    @Nullable
    private BaseDraggable mDraggable;
    @Nullable
    private OnToastListener mListener;
    private boolean mCanAutoCancel;

    @JvmOverloads
    public XToast(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.HANDLER = new Handler(Looper.getMainLooper());
        this.mCanAutoCancel = true;
        this.mContext = context;
        if (this.mContext instanceof Application) {
            throw new RuntimeException("context is not application");
        }
        if (this.mContext instanceof Activity) {
            Context context2 = this.mContext;
            if (context2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.app.Activity");
            }
            Activity activity = (Activity)context2;
            if ((activity.getWindow().getAttributes().flags & 0x400) != 0) {
                this.addWindowFlags(1024);
            }
        }
        Object object = context.getSystemService("window");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.view.WindowManager");
        }
        this.mWindowManager = (WindowManager)object;
        WindowManager.LayoutParams layoutParams2 = this.mWindowParams = new WindowManager.LayoutParams();
        if (layoutParams2 != null) {
            WindowManager.LayoutParams layoutParams3;
            WindowManager.LayoutParams $this$_init__u24lambda_u2d0 = layoutParams3 = layoutParams2;
            boolean bl = false;
            $this$_init__u24lambda_u2d0.height = -2;
            $this$_init__u24lambda_u2d0.width = -2;
            $this$_init__u24lambda_u2d0.format = -3;
            $this$_init__u24lambda_u2d0.windowAnimations = 16973828;
            $this$_init__u24lambda_u2d0.packageName = context.getPackageName();
            $this$_init__u24lambda_u2d0.flags = 168;
        }
    }

    @NotNull
    public final XToast setOutsideTouchable(boolean touchable) {
        int flags = 40;
        if (touchable) {
            this.addWindowFlags(flags);
        } else {
            this.clearWindowFlags(flags);
        }
        if (this.isShow()) {
            this.update();
        }
        return this;
    }

    @NotNull
    public final XToast setBackgroundDimAmount(float amount) {
        if (!(!(amount < 0.0f) && !(amount > 1.0f))) {
            boolean bl = false;
            String string2 = "are you ok?";
            throw new IllegalArgumentException(string2.toString());
        }
        Intrinsics.checkNotNull((Object)this.mWindowParams);
        this.mWindowParams.dimAmount = amount;
        int flags = 2;
        if (!(amount == 0.0f)) {
            this.addWindowFlags(flags);
        } else {
            this.clearWindowFlags(flags);
        }
        if (this.isShow()) {
            this.update();
        }
        return this;
    }

    public final boolean hasWindowFlags(int flags) {
        WindowManager.LayoutParams layoutParams2 = this.mWindowParams;
        Intrinsics.checkNotNull((Object)layoutParams2);
        return (layoutParams2.flags & flags) != 0;
    }

    @NotNull
    public final XToast addWindowFlags(int flags) {
        Intrinsics.checkNotNull((Object)this.mWindowParams);
        WindowManager.LayoutParams layoutParams2 = this.mWindowParams;
        Intrinsics.checkNotNull((Object)layoutParams2);
        this.mWindowParams.flags = layoutParams2.flags | flags;
        if (this.isShow()) {
            this.update();
        }
        return this;
    }

    @NotNull
    public final XToast clearWindowFlags(int flags) {
        Intrinsics.checkNotNull((Object)this.mWindowParams);
        WindowManager.LayoutParams layoutParams2 = this.mWindowParams;
        Intrinsics.checkNotNull((Object)layoutParams2);
        this.mWindowParams.flags = layoutParams2.flags & ~flags;
        if (this.isShow()) {
            this.update();
        }
        return this;
    }

    @NotNull
    public final XToast setWindowFlags(int flags) {
        Intrinsics.checkNotNull((Object)this.mWindowParams);
        this.mWindowParams.flags = flags;
        if (this.isShow()) {
            this.update();
        }
        return this;
    }

    @NotNull
    public final XToast setWindowType(int type) {
        Intrinsics.checkNotNull((Object)this.mWindowParams);
        this.mWindowParams.type = type;
        if (this.isShow()) {
            this.update();
        }
        return this;
    }

    @NotNull
    public final XToast setAnimStyle(int id2) {
        Intrinsics.checkNotNull((Object)this.mWindowParams);
        this.mWindowParams.windowAnimations = id2;
        if (this.isShow()) {
            this.update();
        }
        return this;
    }

    @NotNull
    public final XToast setDraggable(@Nullable BaseDraggable draggable) {
        if (this.hasWindowFlags(16)) {
            this.clearWindowFlags(16);
        }
        this.mDraggable = draggable;
        if (this.isShow()) {
            this.update();
            BaseDraggable baseDraggable = this.mDraggable;
            if (baseDraggable != null) {
                baseDraggable.start(this);
            }
        }
        return this;
    }

    @NotNull
    public final XToast setWidth(int width) {
        Intrinsics.checkNotNull((Object)this.mWindowParams);
        this.mWindowParams.width = width;
        if (this.isShow()) {
            this.update();
        }
        return this;
    }

    @NotNull
    public final XToast setHeight(int height) {
        Intrinsics.checkNotNull((Object)this.mWindowParams);
        this.mWindowParams.height = height;
        if (this.isShow()) {
            this.update();
        }
        return this;
    }

    @NotNull
    public final XToast setDuration(int duration) {
        this.mDuration = duration;
        if (this.isShow() && this.mDuration != 0) {
            this.removeCallbacks();
            this.postDelayed(new CancelRunnable(this), this.mDuration);
        }
        return this;
    }

    @NotNull
    public final XToast setCanAutoCancel(boolean canAutoCancel) {
        this.mCanAutoCancel = canAutoCancel;
        return this;
    }

    @NotNull
    public final XToast setOnToastListener(@Nullable OnToastListener listener) {
        this.mListener = listener;
        return this;
    }

    @NotNull
    public final XToast setGravity(int gravity) {
        Intrinsics.checkNotNull((Object)this.mWindowParams);
        this.mWindowParams.gravity = gravity;
        if (this.isShow()) {
            this.update();
        }
        return this;
    }

    @NotNull
    public final XToast setOrientation(int orientation) {
        Intrinsics.checkNotNull((Object)this.mWindowParams);
        this.mWindowParams.screenOrientation = orientation;
        if (this.isShow()) {
            this.update();
        }
        return this;
    }

    @NotNull
    public final XToast setXOffset(int x) {
        Intrinsics.checkNotNull((Object)this.mWindowParams);
        this.mWindowParams.x = x;
        if (this.isShow()) {
            this.update();
        }
        return this;
    }

    @NotNull
    public final XToast setYOffset(int y) {
        Intrinsics.checkNotNull((Object)this.mWindowParams);
        this.mWindowParams.y = y;
        if (this.isShow()) {
            this.update();
        }
        return this;
    }

    @NotNull
    public final XToast setWindowParams(@Nullable WindowManager.LayoutParams params) {
        this.mWindowParams = params;
        if (this.isShow()) {
            this.update();
        }
        return this;
    }

    @NotNull
    public final XToast setView(int id2) {
        LayoutInflater layoutInflater = LayoutInflater.from((Context)this.mContext);
        Context context = this.mContext;
        Intrinsics.checkNotNull((Object)context);
        return this.setView(layoutInflater.inflate(id2, (ViewGroup)new FrameLayout(context), false));
    }

    private final XToast setView(View view) {
        View view2 = this.mRootView = view;
        Intrinsics.checkNotNull((Object)view2);
        ViewGroup.LayoutParams params = view2.getLayoutParams();
        if (params != null) {
            WindowManager.LayoutParams layoutParams2 = this.mWindowParams;
            Intrinsics.checkNotNull((Object)layoutParams2);
            if (layoutParams2.width == -2) {
                WindowManager.LayoutParams layoutParams3 = this.mWindowParams;
                Intrinsics.checkNotNull((Object)layoutParams3);
                if (layoutParams3.height == -2) {
                    this.setWidth(params.width);
                    this.setHeight(params.height);
                }
            }
        }
        WindowManager.LayoutParams layoutParams4 = this.mWindowParams;
        Intrinsics.checkNotNull((Object)layoutParams4);
        if (layoutParams4.gravity == 0) {
            ViewGroup.LayoutParams layoutParams5 = params;
            if (layoutParams5 instanceof FrameLayout.LayoutParams) {
                this.setGravity(((FrameLayout.LayoutParams)params).gravity);
            } else if (layoutParams5 instanceof LinearLayout.LayoutParams) {
                this.setGravity(((LinearLayout.LayoutParams)params).gravity);
            } else {
                this.setGravity(17);
            }
        }
        if (this.isShow()) {
            this.update();
        }
        return this;
    }

    @NotNull
    public final XToast show(@Nullable LifecycleOwner lifecycleOwner) {
        block21: {
            block22: {
                if (!(this.mRootView != null && this.mWindowParams != null)) {
                    boolean bl = false;
                    String string2 = "WindowParams and view cannot be empty";
                    throw new IllegalArgumentException(string2.toString());
                }
                if (this.mShow) {
                    this.cancel();
                }
                if (!(this.mContext instanceof Activity)) break block21;
                Context context = this.mContext;
                if (context == null) {
                    throw new NullPointerException("null cannot be cast to non-null type android.app.Activity");
                }
                if (((Activity)context).isFinishing()) break block22;
                Context context2 = this.mContext;
                if (context2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type android.app.Activity");
                }
                if (!((Activity)context2).isDestroyed()) break block21;
            }
            return this;
        }
        if (lifecycleOwner != null) {
            LifecycleRegistry lifecycleRegistry = new LifecycleRegistry(lifecycleOwner);
            lifecycleRegistry.addObserver((LifecycleObserver)new ToastLifecycle(this, lifecycleRegistry));
        }
        try {
            View view = this.mRootView;
            if (view != null) {
                View it = view;
                boolean bl = false;
                WindowManager windowManager = this.mWindowManager;
                if (windowManager != null) {
                    windowManager.addView(it, (ViewGroup.LayoutParams)this.mWindowParams);
                }
            }
            this.mShow = true;
            if (this.mDuration != 0 && this.mCanAutoCancel) {
                this.postDelayed(new CancelRunnable(this), this.mDuration);
            }
            if (this.mDraggable != null) {
                BaseDraggable baseDraggable = this.mDraggable;
                if (baseDraggable != null) {
                    baseDraggable.start(this);
                }
            }
            if (this.mListener != null) {
                OnToastListener onToastListener = this.mListener;
                if (onToastListener != null) {
                    onToastListener.onShow(this);
                }
            }
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
        catch (WindowManager.BadTokenException e) {
            e.printStackTrace();
        }
        return this;
    }

    public static /* synthetic */ XToast show$default(XToast xToast, LifecycleOwner lifecycleOwner, int n, Object object) {
        if ((n & 1) != 0) {
            lifecycleOwner = null;
        }
        return xToast.show(lifecycleOwner);
    }

    @NotNull
    public final XToast cancel() {
        if (this.mShow) {
            try {
                WindowManager windowManager = this.mWindowManager;
                if (windowManager != null) {
                    windowManager.removeViewImmediate(this.mRootView);
                }
                if (this.mListener != null) {
                    OnToastListener onToastListener = this.mListener;
                    if (onToastListener != null) {
                        onToastListener.onDismiss(this);
                    }
                }
            }
            catch (NullPointerException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalStateException e) {
                e.printStackTrace();
            }
            this.mShow = false;
        }
        return this;
    }

    public final void update() {
        WindowManager windowManager = this.mWindowManager;
        if (windowManager != null) {
            windowManager.updateViewLayout(this.mRootView, (ViewGroup.LayoutParams)this.mWindowParams);
        }
    }

    public final void recycle() {
        this.mContext = null;
        this.mWindowManager = null;
        this.mListener = null;
        this.mDraggable = null;
        this.mRootView = null;
    }

    public final boolean isShow() {
        return this.mShow;
    }

    @Nullable
    public final WindowManager getWindowManager() {
        return this.mWindowManager;
    }

    @Nullable
    public final WindowManager.LayoutParams getWindowParams() {
        return this.mWindowParams;
    }

    @Nullable
    public final Context getContext() {
        return this.mContext;
    }

    @Nullable
    public final View getView() {
        return this.mRootView;
    }

    @Nullable
    public final <V extends View> V findViewById(int id2) {
        if (this.mRootView == null) {
            boolean bl = false;
            String string2 = "Please setup view";
            throw new IllegalStateException(string2.toString());
        }
        View view = this.mRootView;
        return (V)(view == null ? null : view.findViewById(id2));
    }

    public final void startActivity(@Nullable Class<? extends Activity> clazz) {
        this.startActivity(new Intent(this.mContext, clazz));
    }

    public final void startActivity(@NotNull Intent intent) {
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        if (!(this.mContext instanceof Activity)) {
            intent.addFlags(0x10000000);
        }
        Context context = this.mContext;
        Intrinsics.checkNotNull((Object)context);
        context.startActivity(intent);
    }

    @NotNull
    public final XToast setVisibility(int id2, int visibility) {
        Object v = this.findViewById(id2);
        if (v != null) {
            v.setVisibility(visibility);
        }
        return this;
    }

    @NotNull
    public final XToast setText(int id2) {
        return this.setText(16908299, id2);
    }

    @NotNull
    public final XToast setText(int viewId, int stringId) {
        Context context = this.mContext;
        Intrinsics.checkNotNull((Object)context);
        return this.setText(viewId, context.getResources().getString(stringId));
    }

    @NotNull
    public final XToast setText(@Nullable CharSequence text) {
        return this.setText(16908299, text);
    }

    @NotNull
    public final XToast setText(int id2, @Nullable CharSequence text) {
        Object v = this.findViewById(id2);
        if (v == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.widget.TextView");
        }
        ((TextView)v).setText(text);
        return this;
    }

    @NotNull
    public final XToast setTextColor(int id2, int color2) {
        Object v = this.findViewById(id2);
        if (v == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.widget.TextView");
        }
        ((TextView)v).setTextColor(color2);
        return this;
    }

    @NotNull
    public final XToast setHint(int viewId, int stringId) {
        Context context = this.mContext;
        Intrinsics.checkNotNull((Object)context);
        return this.setHint(viewId, context.getResources().getString(stringId));
    }

    @NotNull
    public final XToast setHint(int id2, @Nullable CharSequence text) {
        Object v = this.findViewById(id2);
        if (v == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.widget.TextView");
        }
        ((TextView)v).setHint(text);
        return this;
    }

    @NotNull
    public final XToast setHintColor(int id2, int color2) {
        Object v = this.findViewById(id2);
        if (v == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.widget.TextView");
        }
        ((TextView)v).setHintTextColor(color2);
        return this;
    }

    @NotNull
    public final XToast setBackground(int viewId, int drawableId) {
        Context context = this.mContext;
        Intrinsics.checkNotNull((Object)context);
        Drawable drawable2 = ContextCompat.getDrawable((Context)context, (int)drawableId);
        return this.setBackground(viewId, drawable2);
    }

    @NotNull
    public final XToast setBackground(int id2, @Nullable Drawable drawable2) {
        Object v = this.findViewById(id2);
        if (v != null) {
            v.setBackground(drawable2);
        }
        return this;
    }

    @NotNull
    public final XToast setImageDrawable(int viewId, int drawableId) {
        Context context = this.mContext;
        Intrinsics.checkNotNull((Object)context);
        Drawable drawable2 = ContextCompat.getDrawable((Context)context, (int)drawableId);
        return this.setImageDrawable(viewId, drawable2);
    }

    @NotNull
    public final XToast setImageDrawable(int viewId, @Nullable Drawable drawable2) {
        Object v = this.findViewById(viewId);
        if (v == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.widget.ImageView");
        }
        ((ImageView)v).setImageDrawable(drawable2);
        return this;
    }

    @NotNull
    public final XToast setOnClickListener(@NotNull OnClickListener<View> listener) {
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        return this.setOnClickListener(this.mRootView, listener);
    }

    @NotNull
    public final XToast setOnClickListener(int id2, @NotNull OnClickListener<View> listener) {
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        return this.setOnClickListener((View)this.findViewById(id2), listener);
    }

    private final XToast setOnClickListener(View view, OnClickListener<View> listener) {
        ViewClickWrapper viewClickWrapper;
        if (this.hasWindowFlags(16)) {
            this.clearWindowFlags(16);
        }
        View view2 = view;
        if (view2 == null) {
            viewClickWrapper = null;
        } else {
            View it = view2;
            boolean bl = false;
            viewClickWrapper = new ViewClickWrapper(this, it, listener);
        }
        return this;
    }

    @NotNull
    public final XToast setOnTouchListener(@NotNull OnTouchListener<View> listener) {
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        return this.setOnTouchListener(this.mRootView, listener);
    }

    @NotNull
    public final XToast setOnTouchListener(int id2, @NotNull OnTouchListener<View> listener) {
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        return this.setOnTouchListener((View)this.findViewById(id2), listener);
    }

    private final XToast setOnTouchListener(View view, OnTouchListener<View> listener) {
        ViewTouchWrapper viewTouchWrapper;
        if (this.hasWindowFlags(16)) {
            this.clearWindowFlags(16);
        }
        View view2 = view;
        if (view2 == null) {
            viewTouchWrapper = null;
        } else {
            View it = view2;
            boolean bl = false;
            viewTouchWrapper = new ViewTouchWrapper(this, it, listener);
        }
        return this;
    }

    @Nullable
    public final Handler getHandler() {
        return this.HANDLER;
    }

    public final boolean post(@Nullable Runnable r) {
        return this.postDelayed(r, 0L);
    }

    public final boolean postDelayed(@Nullable Runnable r, long delayMillis) {
        long delayMillis2 = delayMillis;
        if (delayMillis2 < 0L) {
            delayMillis2 = 0L;
        }
        return this.postAtTime(r, SystemClock.uptimeMillis() + delayMillis2);
    }

    public final boolean postAtTime(@Nullable Runnable r, long uptimeMillis) {
        Runnable runnable = r;
        Intrinsics.checkNotNull((Object)runnable);
        return this.HANDLER.postAtTime(runnable, (Object)this, uptimeMillis);
    }

    public final void removeCallbacks() {
        this.HANDLER.removeCallbacksAndMessages((Object)this);
    }
}

