/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.base.view;

import android.app.Dialog;
import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.RelativeLayout;
import androidx.core.view.ViewCompat;
import androidx.customview.widget.ViewDragHelper;
import com.xshare.base.view.DraggableViewCallback;

public class DragCloseLayout
extends RelativeLayout {
    private ViewDragHelper viewDragHelper;
    private DraggableViewCallback mDragCallback;
    private Dialog mDialog;
    private int mMeasureHeight;
    private int mTotalDragY;
    private boolean closeAlpha;
    private IDragCloseListener mDragCloseListener;
    private IDragMoveListener moveListener;

    public DragCloseLayout(Context context) {
        this(context, null);
    }

    public DragCloseLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public void seDragCloseListener(IDragCloseListener dragCloseListener) {
        this.mDragCloseListener = dragCloseListener;
    }

    public void setDragMoveListener(IDragMoveListener moveListener) {
        this.moveListener = moveListener;
    }

    public void setDialog(Dialog dialog) {
        this.mDialog = dialog;
    }

    public boolean isCloseAlpha() {
        return this.closeAlpha;
    }

    public void setCloseAlpha(boolean closeAlpha) {
        this.closeAlpha = closeAlpha;
    }

    private void initView() {
        this.mDragCallback = new DraggableViewCallback(this);
        this.viewDragHelper = ViewDragHelper.create((ViewGroup)this, (float)1.0f, (ViewDragHelper.Callback)this.mDragCallback);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.mMeasureHeight = this.getMeasuredHeight();
        if (this.mMeasureHeight != 0 && this.mDragCallback != null) {
            this.mDragCallback.setCloseHeight(this.mMeasureHeight);
            this.mDragCallback.setCloseRatio(0.4f);
        }
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        return this.viewDragHelper.shouldInterceptTouchEvent(ev);
    }

    public boolean onTouchEvent(MotionEvent event) {
        this.viewDragHelper.processTouchEvent(event);
        return true;
    }

    public void computeScroll() {
        if (this.viewDragHelper.continueSettling(true)) {
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    public void onViewPositionChanged(View changedView, int left, int top, int dx, int dy) {
        this.mTotalDragY += dy;
        if (this.moveListener != null) {
            this.moveListener.onMoveListener();
        }
        if (this.mTotalDragY > 0) {
            float dimAmount = 0.5f - (float)this.mTotalDragY / (float)this.mMeasureHeight;
            this.setupWindowDimAmount(dimAmount);
        }
    }

    private void setupWindowDimAmount(float dimAmount) {
        if (this.mDialog == null || this.closeAlpha) {
            return;
        }
        Window window = this.mDialog.getWindow();
        if (window != null) {
            WindowManager.LayoutParams lp = window.getAttributes();
            lp.dimAmount = dimAmount;
            window.setAttributes(lp);
        }
    }

    public void onReset() {
        this.viewDragHelper.settleCapturedViewAt(0, 0);
        ViewCompat.postInvalidateOnAnimation((View)this);
        this.setupWindowDimAmount(0.5f);
        this.mTotalDragY = 0;
    }

    public void closedTopToBottom() {
        if (this.viewDragHelper.smoothSlideViewTo((View)this, 0, this.getHeight())) {
            ViewCompat.postInvalidateOnAnimation((View)this);
            this.mTotalDragY = 0;
            if (this.mDragCloseListener != null) {
                this.mDragCloseListener.onDragClose();
            }
        }
    }

    public void openBottomToTop() {
        if (this.viewDragHelper.smoothSlideViewTo((View)this, 0, this.getContext().getResources().getDisplayMetrics().heightPixels)) {
            ViewCompat.postInvalidateOnAnimation((View)this);
            this.mTotalDragY = 0;
        }
    }

    public static interface IDragMoveListener {
        public void onMoveListener();
    }

    public static interface IDragCloseListener {
        public void onDragClose();
    }
}

