/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.base.view;

import android.view.View;
import androidx.customview.widget.ViewDragHelper;
import com.xshare.base.view.DragCloseLayout;

class DraggableViewCallback
extends ViewDragHelper.Callback {
    private float DEFAULT_CLOSE_HEIGHT = 800.0f;
    private float DEFAULT_CLOSE_RATIO = 0.4f;
    private float mCloseHeight = this.DEFAULT_CLOSE_HEIGHT;
    private float mCloseRatio = this.DEFAULT_CLOSE_RATIO;
    private DragCloseLayout mDraggableView;

    public DraggableViewCallback(DragCloseLayout draggableView) {
        this.mDraggableView = draggableView;
        this.mDraggableView.measure(0, 0);
    }

    public void setCloseHeight(float closeHeight) {
        this.mCloseHeight = closeHeight * this.mCloseRatio;
    }

    public void setCloseRatio(float closeRatio) {
        this.mCloseRatio = closeRatio;
    }

    public void onViewPositionChanged(View changedView, int left, int top, int dx, int dy) {
        this.mDraggableView.onViewPositionChanged(changedView, left, top, dx, dy);
    }

    public int clampViewPositionVertical(View child, int top, int dy) {
        return Math.max(top, 0);
    }

    public int clampViewPositionHorizontal(View child, int left, int dx) {
        return 0;
    }

    public void onViewReleased(View releasedChild, float xVel, float yVel) {
        super.onViewReleased(releasedChild, xVel, yVel);
        int top = releasedChild.getTop();
        int left = releasedChild.getLeft();
        if (Math.abs(left) <= Math.abs(top)) {
            this.triggerOnReleaseActionsWhileVerticalDrag(top);
        }
    }

    public boolean tryCaptureView(View view, int pointerId) {
        return true;
    }

    private void triggerOnReleaseActionsWhileVerticalDrag(float yVel) {
    }
}

