/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.base.view.progressbar;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Shader;
import android.os.CountDownTimer;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.OvershootInterpolator;
import androidx.annotation.ColorRes;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;

public class CircularProgressView
extends View {
    private Paint mBackPaint;
    private Paint mProgPaint;
    private RectF mRectF;
    private int[] mColorArray;
    private int mProgress;
    private CountDownTimer countDownTimer;

    public CircularProgressView(Context context) {
        this(context, null);
    }

    public CircularProgressView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CircularProgressView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int viewWide = this.getMeasuredWidth() - this.getPaddingLeft() - this.getPaddingRight();
        int viewHigh = this.getMeasuredHeight() - this.getPaddingTop() - this.getPaddingBottom();
        float mRectLength = (float)(viewWide > viewHigh ? viewHigh : viewWide) - (this.mBackPaint.getStrokeWidth() > this.mProgPaint.getStrokeWidth() ? this.mBackPaint.getStrokeWidth() : this.mProgPaint.getStrokeWidth());
        float mRectL = (float)this.getPaddingLeft() + ((float)viewWide - mRectLength) / 2.0f;
        float mRectT = (float)this.getPaddingTop() + ((float)viewHigh - mRectLength) / 2.0f;
        this.mRectF = new RectF(mRectL, mRectT, mRectL + mRectLength, mRectT + mRectLength);
        if (this.mColorArray != null && this.mColorArray.length > 1) {
            this.mProgPaint.setShader((Shader)new LinearGradient(0.0f, 0.0f, 0.0f, (float)this.getMeasuredWidth(), this.mColorArray, null, Shader.TileMode.MIRROR));
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        canvas.drawArc(this.mRectF, 0.0f, 360.0f, false, this.mBackPaint);
        canvas.drawArc(this.mRectF, 275.0f, (float)(360 * this.mProgress) / 100.0f, false, this.mProgPaint);
    }

    public int getProgress() {
        return this.mProgress;
    }

    public void setProgress(int progress) {
        this.mProgress = progress;
        this.invalidate();
    }

    public void setProgress(int progress, long animTime) {
        if (animTime <= 0L) {
            this.setProgress(progress);
        } else {
            ValueAnimator animator = ValueAnimator.ofInt((int[])new int[]{this.mProgress, progress});
            animator.addUpdateListener(animation -> {
                this.mProgress = (Integer)animation.getAnimatedValue();
                this.invalidate();
            });
            animator.setInterpolator((TimeInterpolator)new OvershootInterpolator());
            animator.setDuration(animTime);
            animator.start();
        }
    }

    public void setBackWidth(int width) {
        this.mBackPaint.setStrokeWidth((float)width);
        this.invalidate();
    }

    public void setBackColor(@ColorRes int color) {
        this.mBackPaint.setColor(ContextCompat.getColor((Context)this.getContext(), (int)color));
        this.invalidate();
    }

    public void setProgWidth(int width) {
        this.mProgPaint.setStrokeWidth((float)width);
        this.invalidate();
    }

    public void setProgColor(@ColorRes int color) {
        this.mProgPaint.setColor(ContextCompat.getColor((Context)this.getContext(), (int)color));
        this.mProgPaint.setShader(null);
        this.invalidate();
    }

    public void setProgColor(@ColorRes int startColor, @ColorRes int firstColor) {
        this.mColorArray = new int[]{ContextCompat.getColor((Context)this.getContext(), (int)startColor), ContextCompat.getColor((Context)this.getContext(), (int)firstColor)};
        this.mProgPaint.setShader((Shader)new LinearGradient(0.0f, 0.0f, 0.0f, (float)this.getMeasuredWidth(), this.mColorArray, null, Shader.TileMode.MIRROR));
        this.invalidate();
    }

    public void setProgColor(@ColorRes int[] colorArray) {
        if (colorArray == null || colorArray.length < 2) {
            return;
        }
        this.mColorArray = new int[colorArray.length];
        for (int index = 0; index < colorArray.length; ++index) {
            this.mColorArray[index] = ContextCompat.getColor((Context)this.getContext(), (int)colorArray[index]);
        }
        this.mProgPaint.setShader((Shader)new LinearGradient(0.0f, 0.0f, 0.0f, (float)this.getMeasuredWidth(), this.mColorArray, null, Shader.TileMode.MIRROR));
        this.invalidate();
    }

    public void startAutoProgress() {
        this.setVisibility(0);
        this.mProgress = 0;
        if (this.countDownTimer != null) {
            this.countDownTimer.cancel();
        } else {
            this.countDownTimer = new CountDownTimer(5000L, 16L){

                public void onTick(long millisUntilFinished) {
                    CircularProgressView.this.mProgress += 16;
                    if (CircularProgressView.this.mProgress >= 100) {
                        CircularProgressView.this.mProgress = 0;
                    }
                    CircularProgressView.this.setProgress(CircularProgressView.this.mProgress);
                }

                public void onFinish() {
                    CircularProgressView.this.setProgress(99);
                }
            };
        }
        this.countDownTimer.start();
    }

    public void stopAutoProgress() {
        this.setVisibility(8);
        this.mProgress = 0;
        if (this.countDownTimer != null) {
            this.countDownTimer.cancel();
        }
    }
}

