/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.base.viewutils;

import android.content.Context;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.MotionEvent;

public class GestureHelper {
    public static final int GESTURE_NONE = 0;
    public static final int GESTURE_PRESSED = 1;
    public static final int GESTURE_CLICK = 2;
    public static final int GESTURE_LONG_CLICK = 3;
    public static final int GESTURE_LEFT = 4;
    public static final int GESTURE_UP = 5;
    public static final int GESTURE_RIGHT = 6;
    public static final int GESTURE_DOWN = 7;
    public static final float DEFAULT_FONT_SIZE_DP = 5.0f;
    public static final int DEFAULT_LONG_CLICK_TIME = 800;
    private float pointSize;
    private int longClickTime;
    private float xyScale;
    private int gesture = 0;
    private long downTime;
    private float downX = 0.0f;
    private float downY = 0.0f;
    private float preX = 0.0f;
    private float preY = 0.0f;

    public GestureHelper(float pointSize, int longClickTime, float xyScale) {
        if (pointSize <= 0.0f) {
            throw new IllegalArgumentException("Illegal:pointSize <= 0");
        }
        if (longClickTime <= 0) {
            throw new IllegalArgumentException("Illegal:longClickTime <= 0");
        }
        if (xyScale == 0.0f) {
            throw new IllegalArgumentException("Illegal:xyScale equals 0");
        }
        this.pointSize = pointSize;
        this.longClickTime = longClickTime;
        this.xyScale = xyScale;
    }

    public static GestureHelper createDefault(Context context) {
        float pointSize = TypedValue.applyDimension((int)1, (float)5.0f, (DisplayMetrics)context.getResources().getDisplayMetrics());
        return new GestureHelper(pointSize, 800, 1.0f);
    }

    public void onTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                this.touchDown(event);
                break;
            }
            case 2: {
                this.touchMove(event);
                break;
            }
            case 1: 
            case 3: {
                this.touchFinish();
                break;
            }
        }
    }

    public int getGesture() {
        return this.gesture;
    }

    public boolean isHorizontalGesture() {
        return this.gesture == 4 || this.gesture == 6;
    }

    public boolean isVerticalGesture() {
        return this.gesture == 5 || this.gesture == 7;
    }

    private void touchDown(MotionEvent event) {
        this.downTime = System.currentTimeMillis();
        this.downX = this.preX = event.getRawX();
        this.downY = this.preY = event.getRawY();
        this.gesture = 1;
    }

    private void touchMove(MotionEvent event) {
        float rangeX = event.getRawX() - this.downX;
        float rangeY = event.getRawY() - this.downY;
        if (this.gesture == 0 || this.gesture == 1) {
            if (Math.abs(rangeX) > this.pointSize || Math.abs(rangeY) > this.pointSize) {
                float ox = event.getRawX() - this.preX;
                float oy = event.getRawY() - this.preY;
                this.gesture = Math.abs(ox) > this.xyScale * Math.abs(oy) ? (ox < 0.0f ? 4 : 6) : (oy < 0.0f ? 5 : 7);
            } else {
                this.gesture = 1;
            }
        }
        if (this.gesture == 1 && System.currentTimeMillis() - this.downTime >= (long)this.longClickTime) {
            this.gesture = 3;
        }
        this.preX = event.getRawX();
        this.preY = event.getRawY();
    }

    private void touchFinish() {
        if (this.gesture == 1) {
            this.gesture = System.currentTimeMillis() - this.downTime >= (long)this.longClickTime ? 3 : 2;
        }
    }
}

