/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.base.viewutils;

import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import com.xshare.base.viewutils.GestureHelper;

public class InterceptTouchHelper {
    private ViewGroup parent;
    private GestureHelper gestureHelper;

    public InterceptTouchHelper(ViewGroup parent, GestureHelper gestureHelper) {
        this.parent = parent;
        this.gestureHelper = gestureHelper;
    }

    public InterceptTouchHelper(ViewGroup parent) {
        this(parent, GestureHelper.createDefault(parent.getContext()));
    }

    public boolean onInterceptTouchEvent(MotionEvent event) {
        this.gestureHelper.onTouchEvent(event);
        switch (this.gestureHelper.getGesture()) {
            case 4: {
                return !this.canChildrenScrollHorizontally(event, 1) && this.canParentScrollHorizontally(this.parent, 1);
            }
            case 6: {
                return !this.canChildrenScrollHorizontally(event, -1) && this.canParentScrollHorizontally(this.parent, -1);
            }
            case 5: {
                return !this.canChildrenScrollVertically(event, 1) && this.canParentScrollVertically(this.parent, 1);
            }
            case 7: {
                return !this.canChildrenScrollVertically(event, -1) && this.canParentScrollVertically(this.parent, -1);
            }
        }
        return false;
    }

    protected boolean canChildrenScrollVertically(MotionEvent event, int direction) {
        for (int i = 0; i < this.parent.getChildCount(); ++i) {
            int index = this.parent.getChildCount() - 1 - i;
            View child = this.parent.getChildAt(index);
            if (child.getVisibility() != 0 || !child.isEnabled()) continue;
            float x = event.getX();
            float y = event.getY();
            if (!(x >= (float)child.getLeft()) || !(x <= (float)child.getRight()) || !(y >= (float)child.getTop()) || !(y <= (float)child.getBottom()) || !this.canChildScrollVertically(child, direction)) continue;
            return true;
        }
        return false;
    }

    protected boolean canChildScrollVertically(View child, int direction) {
        return child.canScrollVertically(direction);
    }

    protected boolean canChildrenScrollHorizontally(MotionEvent event, int direction) {
        for (int i = 0; i < this.parent.getChildCount(); ++i) {
            int index = this.parent.getChildCount() - 1 - i;
            View child = this.parent.getChildAt(index);
            if (child.getVisibility() != 0 || !child.isEnabled()) continue;
            float x = event.getX();
            float y = event.getY();
            if (!(x >= (float)child.getLeft()) || !(x <= (float)child.getRight()) || !(y >= (float)child.getTop()) || !(y <= (float)child.getBottom()) || !this.canChildScrollHorizontally(child, direction)) continue;
            return true;
        }
        return false;
    }

    protected boolean canChildScrollHorizontally(View child, int direction) {
        return child.canScrollHorizontally(direction);
    }

    protected boolean canParentScrollHorizontally(ViewGroup parent, int direction) {
        return parent.canScrollHorizontally(direction);
    }

    protected boolean canParentScrollVertically(ViewGroup parent, int direction) {
        return parent.canScrollVertically(direction);
    }
}

