/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.base.viewutils;

import android.graphics.Rect;
import android.view.View;
import android.view.ViewGroup;

public final class MeasureUtils {
    private MeasureUtils() {
    }

    public static int makeSelfMeasureSpec(int parentMeasureSpec, int padding) {
        int mode = View.MeasureSpec.getMode((int)parentMeasureSpec);
        int size = View.MeasureSpec.getSize((int)parentMeasureSpec);
        size = Math.max(0, size - padding);
        return View.MeasureSpec.makeMeasureSpec((int)size, (int)mode);
    }

    public static int makeChildMeasureSpec(int parentMeasureSpec, int layoutParamSize, int margin) {
        int size = View.MeasureSpec.getSize((int)parentMeasureSpec);
        size = Math.max(size - margin, 0);
        if (layoutParamSize == -1) {
            return View.MeasureSpec.makeMeasureSpec((int)size, (int)0x40000000);
        }
        if (layoutParamSize == -2) {
            int mode = View.MeasureSpec.getMode((int)parentMeasureSpec);
            if (mode == 0x40000000 || mode == Integer.MIN_VALUE) {
                return View.MeasureSpec.makeMeasureSpec((int)size, (int)Integer.MIN_VALUE);
            }
            return View.MeasureSpec.makeMeasureSpec((int)size, (int)0);
        }
        return View.MeasureSpec.makeMeasureSpec((int)layoutParamSize, (int)0x40000000);
    }

    public static void measureChild(View child, int parentWidthMeasureSpec, int parentHeightMeasureSpec) {
        int horizontalMargin = 0;
        int verticalMargin = 0;
        ViewGroup.LayoutParams lp = child.getLayoutParams();
        if (lp instanceof ViewGroup.MarginLayoutParams) {
            horizontalMargin = ((ViewGroup.MarginLayoutParams)lp).leftMargin + ((ViewGroup.MarginLayoutParams)lp).rightMargin;
            verticalMargin = ((ViewGroup.MarginLayoutParams)lp).topMargin + ((ViewGroup.MarginLayoutParams)lp).bottomMargin;
        }
        int childWidthMeasureSpec = MeasureUtils.makeChildMeasureSpec(parentWidthMeasureSpec, lp.width, horizontalMargin);
        int childHeightMeasureSpec = MeasureUtils.makeChildMeasureSpec(parentHeightMeasureSpec, lp.height, verticalMargin);
        child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
    }

    public static int getMeasuredDimension(int contentSize, int parentMeasureSpec) {
        int mode = View.MeasureSpec.getMode((int)parentMeasureSpec);
        int size = View.MeasureSpec.getSize((int)parentMeasureSpec);
        if (mode == Integer.MIN_VALUE) {
            return Math.min(size, contentSize);
        }
        if (mode == 0x40000000) {
            return size;
        }
        return contentSize;
    }

    public static int getViewWidthSpace(View view) {
        int width = view.getMeasuredWidth();
        ViewGroup.LayoutParams lp = view.getLayoutParams();
        if (lp instanceof ViewGroup.MarginLayoutParams) {
            width += ((ViewGroup.MarginLayoutParams)lp).leftMargin + ((ViewGroup.MarginLayoutParams)lp).rightMargin;
        }
        return width;
    }

    public static int getViewHeightSpace(View view) {
        int height = view.getMeasuredHeight();
        ViewGroup.LayoutParams lp = view.getLayoutParams();
        if (lp instanceof ViewGroup.MarginLayoutParams) {
            height += ((ViewGroup.MarginLayoutParams)lp).topMargin + ((ViewGroup.MarginLayoutParams)lp).bottomMargin;
        }
        return height;
    }

    public static void computeLayout(View view, int layoutX, int layoutY, Rect layoutOut, Rect spaceOut) {
        ViewGroup.LayoutParams lp = view.getLayoutParams();
        spaceOut.left = layoutX;
        spaceOut.top = layoutY;
        if (lp instanceof ViewGroup.MarginLayoutParams) {
            layoutOut.left = layoutX + ((ViewGroup.MarginLayoutParams)lp).leftMargin;
            layoutOut.top = layoutY + ((ViewGroup.MarginLayoutParams)lp).topMargin;
            layoutOut.right = layoutOut.left + view.getMeasuredWidth();
            layoutOut.bottom = layoutOut.top + view.getMeasuredHeight();
            spaceOut.right = layoutOut.right + ((ViewGroup.MarginLayoutParams)lp).rightMargin;
            spaceOut.bottom = layoutOut.bottom + ((ViewGroup.MarginLayoutParams)lp).bottomMargin;
        } else {
            layoutOut.left = layoutX;
            layoutOut.top = layoutY;
            layoutOut.right = layoutOut.left + view.getMeasuredWidth();
            layoutOut.bottom = layoutOut.top + view.getMeasuredHeight();
            spaceOut.right = layoutOut.right;
            spaceOut.bottom = layoutOut.bottom;
        }
    }
}

