/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.base.viewutils;

import android.content.Context;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import com.xshare.base.viewutils.GestureHelper;

public abstract class ScrollHelper {
    private GestureHelper gestureHelper;
    private VelocityTracker velocityTracker;
    private float startTouchX;
    private float startTouchY;
    private int startScrollX;
    private int startScrollY;

    protected ScrollHelper(GestureHelper gestureHelper) {
        this.gestureHelper = gestureHelper;
        this.velocityTracker = VelocityTracker.obtain();
    }

    protected ScrollHelper(Context context) {
        this(GestureHelper.createDefault(context));
    }

    public void onTouchEvent(MotionEvent event) {
        this.gestureHelper.onTouchEvent(event);
        this.velocityTracker.addMovement(event);
        switch (event.getAction()) {
            case 0: {
                this.setStartPosition(event.getX(), event.getY());
                break;
            }
            case 2: {
                if (!this.canScroll()) break;
                float rangeX = event.getX() - this.startTouchX;
                float rangeY = event.getY() - this.startTouchY;
                int dstX = (int)((float)this.startScrollX - rangeX);
                int dstY = (int)((float)this.startScrollY - rangeY);
                if (dstX < this.getMinHorizontallyScroll()) {
                    dstX = 0;
                    this.startTouchX = event.getX();
                    this.startScrollX = dstX;
                } else if (dstX > this.getMaxHorizontallyScroll()) {
                    dstX = this.getViewHorizontallyScrollSize();
                    this.startTouchX = event.getX();
                    this.startScrollX = dstX;
                }
                if (dstY < this.getMinVerticallyScroll()) {
                    dstY = 0;
                    this.startTouchY = event.getY();
                    this.startScrollY = dstY;
                } else if (dstY > this.getMaxVerticallyScroll()) {
                    dstY = this.getViewVerticallyScrollSize();
                    this.startTouchY = event.getY();
                    this.startScrollY = dstY;
                }
                this.viewScrollTo(dstX, dstY);
                break;
            }
            case 1: 
            case 3: {
                this.velocityTracker.computeCurrentVelocity(1000);
                if (!this.canScroll()) break;
                float xv = this.velocityTracker.getXVelocity();
                float yv = this.velocityTracker.getYVelocity();
                this.viewFling(xv, yv);
                break;
            }
        }
    }

    public GestureHelper getGestureHelper() {
        return this.gestureHelper;
    }

    public void setStartPosition(float x, float y) {
        this.startTouchX = x;
        this.startTouchY = y;
        this.startScrollX = this.getViewScrollX();
        this.startScrollY = this.getViewScrollY();
    }

    protected boolean canScroll() {
        return this.gestureHelper.isVerticalGesture() || this.gestureHelper.isHorizontalGesture();
    }

    public int getMinHorizontallyScroll() {
        return 0;
    }

    public int getMaxHorizontallyScroll() {
        return this.getViewHorizontallyScrollSize();
    }

    public int getMinVerticallyScroll() {
        return 0;
    }

    public int getMaxVerticallyScroll() {
        return this.getViewVerticallyScrollSize();
    }

    public void recycle() {
        if (null != this.velocityTracker) {
            this.velocityTracker.recycle();
            this.velocityTracker = null;
        }
        if (null != this.gestureHelper) {
            this.gestureHelper = null;
        }
    }

    protected abstract int getViewScrollX();

    protected abstract int getViewScrollY();

    protected abstract int getViewHorizontallyScrollSize();

    protected abstract int getViewVerticallyScrollSize();

    protected abstract void viewScrollTo(int var1, int var2);

    protected abstract void viewFling(float var1, float var2);
}

