/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.business.net;

import androidx.annotation.Nullable;
import com.xshare.base.util.DLog;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import okhttp3.Call;
import okhttp3.Connection;
import okhttp3.EventListener;
import okhttp3.Handshake;
import okhttp3.HttpUrl;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;

public class HttpEventListener
extends EventListener {
    public static final String TAG = "listen_http_log";
    public static final EventListener.Factory FACTORY = new EventListener.Factory(){
        final AtomicLong nextCallId = new AtomicLong(1L);

        public EventListener create(Call call) {
            long callId = this.nextCallId.getAndIncrement();
            return new HttpEventListener(callId, call.request().url(), System.nanoTime());
        }
    };
    private final long callId;
    private final long callStartNanos;
    private StringBuilder sbLog;

    public HttpEventListener(long callId, HttpUrl url, long callStartNanos) {
        this.callId = callId;
        this.callStartNanos = callStartNanos;
        this.sbLog = new StringBuilder(url.toString()).append(" ").append(callId).append(":");
    }

    private void recordEventLog(String name) {
        long elapseNanos = System.nanoTime() - this.callStartNanos;
        this.sbLog.append("\n").append(System.currentTimeMillis()).append(" ---- \u56de\u8c03\u65b9\u6cd5\uff1a").append(name);
        if (name.equalsIgnoreCase("callEnd") || name.equalsIgnoreCase("callFailed")) {
            DLog.INSTANCE.d(TAG, this.sbLog.toString() + "\n\n\n");
        }
    }

    public void callStart(Call call) {
        super.callStart(call);
        this.recordEventLog("callStart");
    }

    public void dnsStart(Call call, String domainName) {
        super.dnsStart(call, domainName);
        this.recordEventLog("dnsStart");
    }

    public void dnsEnd(Call call, String domainName, List<InetAddress> inetAddressList) {
        super.dnsEnd(call, domainName, inetAddressList);
        this.recordEventLog("dnsEnd");
    }

    public void connectStart(Call call, InetSocketAddress inetSocketAddress, Proxy proxy) {
        super.connectStart(call, inetSocketAddress, proxy);
        this.recordEventLog("connectStart");
    }

    public void secureConnectStart(Call call) {
        super.secureConnectStart(call);
        this.recordEventLog("secureConnectStart");
    }

    public void secureConnectEnd(Call call, @Nullable Handshake handshake) {
        super.secureConnectEnd(call, handshake);
        this.recordEventLog("secureConnectEnd");
    }

    public void connectEnd(Call call, InetSocketAddress inetSocketAddress, Proxy proxy, @Nullable Protocol protocol) {
        super.connectEnd(call, inetSocketAddress, proxy, protocol);
        this.recordEventLog("connectEnd");
    }

    public void connectFailed(Call call, InetSocketAddress inetSocketAddress, Proxy proxy, @Nullable Protocol protocol, IOException ioe) {
        super.connectFailed(call, inetSocketAddress, proxy, protocol, ioe);
        this.recordEventLog("connectFailed");
    }

    public void connectionAcquired(Call call, Connection connection) {
        super.connectionAcquired(call, connection);
        this.recordEventLog("connectionAcquired");
    }

    public void connectionReleased(Call call, Connection connection) {
        super.connectionReleased(call, connection);
        this.recordEventLog("connectionReleased");
    }

    public void requestHeadersStart(Call call) {
        super.requestHeadersStart(call);
        this.recordEventLog("requestHeadersStart");
    }

    public void requestHeadersEnd(Call call, Request request) {
        super.requestHeadersEnd(call, request);
        this.recordEventLog("requestHeadersEnd");
    }

    public void requestBodyStart(Call call) {
        super.requestBodyStart(call);
        this.recordEventLog("requestBodyStart");
    }

    public void requestBodyEnd(Call call, long byteCount) {
        super.requestBodyEnd(call, byteCount);
        this.recordEventLog("requestBodyEnd");
    }

    public void responseHeadersStart(Call call) {
        super.responseHeadersStart(call);
        this.recordEventLog("responseHeadersStart");
    }

    public void responseHeadersEnd(Call call, Response response) {
        super.responseHeadersEnd(call, response);
        this.recordEventLog("responseHeadersEnd");
    }

    public void responseBodyStart(Call call) {
        super.responseBodyStart(call);
        this.recordEventLog("responseBodyStart");
    }

    public void responseBodyEnd(Call call, long byteCount) {
        super.responseBodyEnd(call, byteCount);
        this.recordEventLog("responseBodyEnd");
    }

    public void callEnd(Call call) {
        super.callEnd(call);
        this.recordEventLog("callEnd");
    }

    public void callFailed(Call call, IOException ioe) {
        super.callFailed(call, ioe);
        this.recordEventLog("callFailed");
    }
}

