/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.business.utils;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import androidx.annotation.RequiresPermission;
import com.xshare.base.util.DLog;
import com.xshare.business.utils.FileUtils;
import com.xshare.business.utils.ShellUtils;
import java.io.File;
import java.io.IOException;

public final class ApkInstallUtils {
    private static final int APP_INSTALL_AUTO = 0;
    private static final int APP_INSTALL_INTERNAL = 1;
    private static final int APP_INSTALL_EXTERNAL = 2;
    public static final int REQUEST_CODE_INSTALL_APP = 999;
    private static boolean sSupportSilentInstall = true;

    public static boolean isSupportSilentInstall() {
        return sSupportSilentInstall;
    }

    public static void setSupportSilentInstall(boolean supportSilentInstall) {
        sSupportSilentInstall = supportSilentInstall;
    }

    private ApkInstallUtils() {
        throw new UnsupportedOperationException("Do not need instantiate!");
    }

    public static boolean install(Context context, File apkFile) throws IOException {
        return ApkInstallUtils.isSupportSilentInstall() ? ApkInstallUtils.install(context, apkFile.getCanonicalPath()) : ApkInstallUtils.installNormal(context, apkFile.getCanonicalPath());
    }

    public static boolean install(Context context, String filePath) {
        try {
            if (ApkInstallUtils.isSystemApplication(context) || ShellUtils.checkRootPermission()) {
                return ApkInstallUtils.installAppSilent(context, filePath);
            }
            return ApkInstallUtils.installNormal(context, filePath);
        }
        catch (Exception e) {
            return false;
        }
    }

    @RequiresPermission(value="android.permission.INSTALL_PACKAGES")
    public static boolean installAppSilent(Context context, String filePath) {
        if (Build.VERSION.SDK_INT < 24) {
            return ApkInstallUtils.installAppSilentBelow24(context, filePath);
        }
        return ApkInstallUtils.installAppSilentAbove24(context.getPackageName(), filePath);
    }

    @RequiresPermission(value="android.permission.INSTALL_PACKAGES")
    private static boolean installAppSilentBelow24(Context context, String filePath) {
        File file = FileUtils.getFileByPath(filePath);
        if (!FileUtils.isFileExists(file)) {
            return false;
        }
        String pmParams = " -r " + ApkInstallUtils.getInstallLocationParams();
        StringBuilder command = new StringBuilder().append("LD_LIBRARY_PATH=/vendor/lib:/system/lib pm install ").append(pmParams).append(" ").append(filePath.replace(" ", "\\ "));
        ShellUtils.CommandResult commandResult = ShellUtils.execCommand(command.toString(), !ApkInstallUtils.isSystemApplication(context), true);
        return commandResult.successMsg != null && (commandResult.successMsg.contains("Success") || commandResult.successMsg.contains("success"));
    }

    private static String getInstallLocationParams() {
        int location = ApkInstallUtils.getInstallLocation();
        switch (location) {
            case 1: {
                return "-f";
            }
            case 2: {
                return "-s";
            }
        }
        return "";
    }

    public static int getInstallLocation() {
        ShellUtils.CommandResult commandResult = ShellUtils.execCommand("LD_LIBRARY_PATH=/vendor/lib:/system/lib pm get-install-location", false, true);
        if (commandResult.result == 0 && commandResult.successMsg != null && commandResult.successMsg.length() > 0) {
            try {
                int location = Integer.parseInt(commandResult.successMsg.substring(0, 1));
                switch (location) {
                    case 1: {
                        return 1;
                    }
                    case 2: {
                        return 2;
                    }
                }
            }
            catch (NumberFormatException e) {
                return 0;
            }
        }
        return 0;
    }

    @RequiresPermission(value="android.permission.INSTALL_PACKAGES")
    private static boolean installAppSilentAbove24(String packageName, String filePath) {
        File file = FileUtils.getFileByPath(filePath);
        if (!FileUtils.isFileExists(file)) {
            return false;
        }
        boolean isRoot = ApkInstallUtils.isDeviceRooted();
        String command = "pm install -i " + packageName + " --user 0 " + filePath;
        ShellUtils.CommandResult commandResult = ShellUtils.execCommand(command, isRoot);
        return commandResult.successMsg != null && commandResult.successMsg.toLowerCase().contains("success");
    }

    private static boolean installNormal(Context context, String filePath) {
        File file = FileUtils.getFileByPath(filePath);
        return FileUtils.isFileExists(file) && ApkInstallUtils.installNormal(context, file);
    }

    private static boolean installNormal(Context context, File appFile) {
        try {
            Intent intent = ApkInstallUtils.getInstallAppIntent(appFile);
            if (!context.getPackageManager().queryIntentActivities(intent, 0).isEmpty()) {
                if (context instanceof Activity) {
                    ((Activity)context).startActivityForResult(intent, 999);
                } else {
                    context.startActivity(intent);
                }
                return true;
            }
        }
        catch (Exception e) {
            DLog.INSTANCE.i("install", "\u4f7f\u7528\u7cfb\u7edf\u7684\u610f\u56fe\u8fdb\u884capk\u5b89\u88c5\u5931\u8d25\uff01");
        }
        return false;
    }

    public static Intent getInstallAppIntent(File appFile) {
        try {
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setFlags(0x10000000);
            if (Build.VERSION.SDK_INT >= 24) {
                intent.addFlags(65);
            }
            Uri fileUri = FileUtils.getUriByFile(appFile);
            intent.setDataAndType(fileUri, "application/vnd.android.package-archive");
            return intent;
        }
        catch (Exception e) {
            DLog.INSTANCE.i("install", "\u83b7\u53d6\u5b89\u88c5\u7684\u610f\u56fe\u5931\u8d25\uff01");
            return null;
        }
    }

    private static boolean isDeviceRooted() {
        String[] locations;
        String su = "su";
        for (String location : locations = new String[]{"/system/bin/", "/system/xbin/", "/sbin/", "/system/sd/xbin/", "/system/bin/failsafe/", "/data/local/xbin/", "/data/local/bin/", "/data/local/"}) {
            if (!new File(location + su).exists()) continue;
            return true;
        }
        return false;
    }

    private static boolean isSystemApplication(Context context) {
        return context != null && ApkInstallUtils.isSystemApplication(context, context.getPackageName());
    }

    private static boolean isSystemApplication(Context context, String packageName) {
        return context != null && ApkInstallUtils.isSystemApplication(context.getPackageManager(), packageName);
    }

    private static boolean isSystemApplication(PackageManager packageManager, String packageName) {
        if (packageManager == null || packageName == null || packageName.length() == 0) {
            return false;
        }
        try {
            ApplicationInfo app = packageManager.getApplicationInfo(packageName, 0);
            return app != null && (app.flags & 1) > 0;
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
    }
}

