/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.business.utils;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import com.xshare.base.BaseApplication;
import com.xshare.business.utils.LogUtils;
import java.io.File;
import java.util.List;

public class ApkUtils {
    public static final String TAG = ApkUtils.class.getSimpleName();

    public static boolean isAndroidQ() {
        boolean isQ = Build.VERSION.SDK_INT == 29;
        return isQ;
    }

    public static boolean isApk(String name) {
        return name != null && (name.endsWith(".apk") || name.endsWith(".apks") || name.endsWith(".xab"));
    }

    public static boolean isApk(String mFileRealName, String mMimeType) {
        return ApkUtils.isApk(mFileRealName) || TextUtils.equals((CharSequence)mMimeType, (CharSequence)"apks") || TextUtils.equals((CharSequence)mMimeType, (CharSequence)"application/vnd.android.package-archive");
    }

    public static boolean isAppBundle(String fileRealName, String mimeType) {
        return fileRealName != null && (fileRealName.endsWith(".apks") || fileRealName.endsWith(".xab")) || TextUtils.equals((CharSequence)mimeType, (CharSequence)"apks");
    }

    public static int getVersionCode(Context context) {
        int versionCode = -1;
        try {
            PackageManager pm = context.getPackageManager();
            PackageInfo pi = pm.getPackageInfo(context.getPackageName(), 0);
            versionCode = pi.versionCode;
            if (versionCode < 0) {
                return -1;
            }
        }
        catch (Exception e) {
            Log.e((String)"VersionInfo", (String)"Exception", (Throwable)e);
        }
        return versionCode;
    }

    public static String getVersionName(Context ct) {
        try {
            PackageManager packageManager = ct.getPackageManager();
            PackageInfo info = packageManager.getPackageInfo(ct.getPackageName(), 0);
            return info.versionName;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static boolean isApplicationAvilible(Context context, String appPackageName) {
        try {
            PackageManager packageManager = context.getPackageManager();
            List pinfo = packageManager.getInstalledPackages(0);
            if (pinfo != null) {
                for (int i = 0; i < pinfo.size(); ++i) {
                    String pn = ((PackageInfo)pinfo.get((int)i)).packageName;
                    if (!appPackageName.equals(pn)) continue;
                    return true;
                }
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public static Drawable getApkIcon(String filePath, PackageManager pm) {
        if (TextUtils.isEmpty((CharSequence)filePath)) {
            return null;
        }
        PackageInfo packageInfo = pm.getPackageArchiveInfo(filePath, 1);
        if (packageInfo == null || packageInfo.applicationInfo == null) {
            return null;
        }
        ApplicationInfo appInfo = packageInfo.applicationInfo;
        appInfo.sourceDir = filePath;
        appInfo.publicSourceDir = filePath;
        return appInfo.loadIcon(pm);
    }

    public static String getPackageName(String filePath, PackageManager pm) {
        if (TextUtils.isEmpty((CharSequence)filePath)) {
            return null;
        }
        PackageInfo packageInfo = pm.getPackageArchiveInfo(filePath, 1);
        if (packageInfo == null || packageInfo.applicationInfo == null) {
            return null;
        }
        ApplicationInfo appInfo = packageInfo.applicationInfo;
        if (appInfo != null) {
            return appInfo.packageName;
        }
        return null;
    }

    public static Drawable getApkIconByPkg(String packageName, PackageManager pm) {
        if (TextUtils.isEmpty((CharSequence)packageName)) {
            return null;
        }
        try {
            ApplicationInfo applicationInfo = pm.getApplicationInfo(packageName, 128);
            return applicationInfo.loadIcon(pm);
        }
        catch (PackageManager.NameNotFoundException e) {
            return null;
        }
    }

    public static PackageInfo getPackageInfo(PackageManager pm, String packageName) {
        try {
            if (pm == null || TextUtils.isEmpty((CharSequence)packageName)) {
                return null;
            }
            return pm.getPackageInfo(packageName, 1);
        }
        catch (PackageManager.NameNotFoundException e) {
            return null;
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    public Drawable loadApkIcon(PackageManager pm, PackageInfo parserApkFileInternal, String filePath) {
        Drawable apkIconMethod1;
        Drawable drawable = apkIconMethod1 = Build.VERSION.SDK_INT < 29 ? this.getApkIconMethod1(pm, parserApkFileInternal, filePath) : null;
        if (apkIconMethod1 == null) {
            apkIconMethod1 = this.getApkIconMethod2(pm, parserApkFileInternal);
        }
        if (apkIconMethod1 == null) {
            apkIconMethod1 = this.getApkIconMethod3(pm, parserApkFileInternal);
        }
        return apkIconMethod1;
    }

    private Resources getApkResources(String str) {
        try {
            new DisplayMetrics().setToDefaults();
            Class<?> cls = Class.forName("android.content.res.AssetManager");
            Object newInstance = cls.newInstance();
            cls.getDeclaredMethod("addAssetPath", String.class).invoke(newInstance, str);
            Resources resources = BaseApplication.baseApplication.getResources();
            return (Resources)Resources.class.getConstructor(newInstance.getClass(), resources.getDisplayMetrics().getClass(), resources.getConfiguration().getClass()).newInstance(newInstance, resources.getDisplayMetrics(), resources.getConfiguration());
        }
        catch (Throwable unused) {
            return null;
        }
    }

    private Drawable getApkIconMethod1(PackageManager pm, PackageInfo packageInfo, String str) {
        if (packageInfo == null) {
            return null;
        }
        try {
            Resources apkResources;
            ApplicationInfo applicationInfo = packageInfo.applicationInfo;
            if (applicationInfo == null || applicationInfo.icon <= 0 || (apkResources = this.getApkResources(str)) == null) {
                return null;
            }
            return apkResources.getDrawable(packageInfo.applicationInfo.icon);
        }
        catch (Throwable unused) {
            return null;
        }
    }

    private Drawable getApkIconMethod2(PackageManager pm, PackageInfo packageInfo) {
        if (packageInfo == null) {
            return null;
        }
        try {
            return packageInfo.applicationInfo.loadIcon(pm);
        }
        catch (Throwable unused) {
            return null;
        }
    }

    private Drawable getApkIconMethod3(PackageManager pm, PackageInfo packageInfo) {
        if (packageInfo == null) {
            return null;
        }
        try {
            if (Build.VERSION.SDK_INT >= 22) {
                return packageInfo.applicationInfo.loadUnbadgedIcon(pm);
            }
            return null;
        }
        catch (Throwable unused) {
            return null;
        }
    }

    public static int getAppCode(PackageManager pm, String packageName) {
        try {
            PackageInfo packageInfo = pm.getPackageInfo(packageName, 0);
            if (packageInfo == null) {
                return -1;
            }
            return packageInfo.versionCode;
        }
        catch (Exception e) {
            return -1;
        }
    }

    public static String getAPPName(PackageManager pm, String packageName) {
        try {
            PackageInfo packageInfo = pm.getPackageInfo(packageName, 0);
            if (packageInfo == null) {
                return null;
            }
            return packageInfo.applicationInfo.loadLabel(pm).toString();
        }
        catch (PackageManager.NameNotFoundException e) {
            return null;
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    public static boolean isAppBundle(PackageManager pm, String packageName) {
        try {
            PackageInfo packageInfo = pm.getPackageInfo(packageName, 0);
            if (packageInfo == null || packageInfo.applicationInfo == null) {
                return false;
            }
            return packageInfo.applicationInfo.splitPublicSourceDirs != null && packageInfo.applicationInfo.splitPublicSourceDirs.length > 0;
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    public static boolean checkApkExist(Context context, String packageName) {
        if (TextUtils.isEmpty((CharSequence)packageName)) {
            return false;
        }
        try {
            ApplicationInfo info = context.getPackageManager().getApplicationInfo(packageName, 8192);
            return true;
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
    }

    public static String getApkPackageName(String fileuri, PackageManager pm) {
        if (TextUtils.isEmpty((CharSequence)fileuri) || !new File(fileuri).exists()) {
            return null;
        }
        try {
            PackageInfo pi = pm.getPackageArchiveInfo(fileuri, 65);
            if (pi != null) {
                return pi.packageName;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static int getApplicationEnabledProxy(Context context, String packageName) {
        LogUtils.d(TAG, "getApplicationEnabledProxy packageName = " + packageName);
        try {
            PackageManager packageManager = context.getPackageManager();
            int state = packageManager.getApplicationEnabledSetting(packageName);
            LogUtils.d(TAG, "getApplicationEnabledProxy state = " + state);
            return state;
        }
        catch (Exception e) {
            e.printStackTrace();
            LogUtils.e(TAG, "getApplicationEnabledProxy e" + e);
            return 0;
        }
    }
}

