/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.business.utils;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.provider.MediaStore;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.core.content.FileProvider;
import com.xshare.base.BaseApplication;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public final class FileUtils {
    public static final String MODE_READ_ONLY = "r";
    private static final String EXT_STORAGE_PATH = FileUtils.getExtStoragePath();
    private static final String EXT_STORAGE_DIR = EXT_STORAGE_PATH + File.separator;
    private static final String APP_EXT_STORAGE_PATH = EXT_STORAGE_DIR + "Android";
    private static final String EXT_DOWNLOADS_PATH = FileUtils.getExtDownloadsPath();
    private static final String EXT_PICTURES_PATH = FileUtils.getExtPicturesPath();
    private static final String EXT_DCIM_PATH = FileUtils.getExtDCIMPath();

    private FileUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    @Nullable
    public static File getFileByPath(String filePath) {
        return FileUtils.isSpace(filePath) ? null : new File(filePath);
    }

    public static boolean isFileExists(File file) {
        if (file == null) {
            return false;
        }
        if (file.exists()) {
            return true;
        }
        return FileUtils.isFileExists(file.getAbsolutePath());
    }

    public static boolean isFileExists(String filePath) {
        File file = FileUtils.getFileByPath(filePath);
        if (file == null) {
            return false;
        }
        if (file.exists()) {
            return true;
        }
        return FileUtils.isFileExistsApi29(filePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isFileExistsApi29(String filePath) {
        block6: {
            AssetFileDescriptor afd;
            block5: {
                if (Build.VERSION.SDK_INT < 29) break block6;
                afd = null;
                Uri uri = Uri.parse((String)filePath);
                afd = FileUtils.openAssetFileDescriptor(uri);
                if (afd != null) break block5;
                boolean bl = false;
                FileUtils.closeIOQuietly(new Closeable[]{afd});
                return bl;
            }
            try {
                FileUtils.closeIOQuietly(new Closeable[]{afd});
            }
            catch (FileNotFoundException e) {
                boolean bl;
                try {
                    bl = false;
                }
                catch (Throwable throwable) {
                    FileUtils.closeIOQuietly(new Closeable[]{afd});
                    throw throwable;
                }
                FileUtils.closeIOQuietly(new Closeable[]{afd});
                return bl;
            }
            FileUtils.closeIOQuietly(new Closeable[]{afd});
            return true;
        }
        return false;
    }

    public static InputStream getFileInputStream(File file) throws FileNotFoundException {
        if (FileUtils.isScopedStorageMode()) {
            return FileUtils.getContentResolver().openInputStream(FileUtils.getUriByFile(file));
        }
        return new FileInputStream(file);
    }

    public static Uri getUriByFile(File file) {
        if (file == null) {
            return null;
        }
        if (FileUtils.isScopedStorageMode() && FileUtils.isPublicPath(file)) {
            String filePath = file.getAbsolutePath();
            if (filePath.startsWith(EXT_DOWNLOADS_PATH)) {
                return FileUtils.getDownloadContentUri(BaseApplication.getContext(), file);
            }
            if (filePath.startsWith(EXT_PICTURES_PATH) || filePath.startsWith(EXT_DCIM_PATH)) {
                return FileUtils.getMediaContentUri(BaseApplication.getContext(), file);
            }
            return FileUtils.getUriForFile(file);
        }
        return FileUtils.getUriForFile(file);
    }

    @Nullable
    public static Uri getUriForFile(File file) {
        if (file == null) {
            return null;
        }
        if (Build.VERSION.SDK_INT >= 24) {
            return FileProvider.getUriForFile((Context)BaseApplication.getContext(), (String)"com.rm.listen.fileprovider", (File)file);
        }
        return Uri.fromFile((File)file);
    }

    public static boolean isScopedStorageMode() {
        return Build.VERSION.SDK_INT >= 29 && !Environment.isExternalStorageLegacy();
    }

    public static Uri getMediaContentUri(Context context, File mediaFile) {
        String filePath = mediaFile.getAbsolutePath();
        Uri baseUri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
        Cursor cursor = context.getContentResolver().query(baseUri, new String[]{"_id"}, "_data=? ", new String[]{filePath}, null);
        if (cursor != null && cursor.moveToFirst()) {
            int id = cursor.getInt(cursor.getColumnIndex("_id"));
            cursor.close();
            return Uri.withAppendedPath((Uri)baseUri, (String)("" + id));
        }
        if (mediaFile.exists()) {
            ContentValues values = new ContentValues();
            values.put("_data", filePath);
            return context.getContentResolver().insert(baseUri, values);
        }
        return null;
    }

    @RequiresApi(api=29)
    public static Uri getDownloadContentUri(Context context, File file) {
        String filePath = file.getAbsolutePath();
        Uri baseUri = MediaStore.Downloads.EXTERNAL_CONTENT_URI;
        Cursor cursor = context.getContentResolver().query(baseUri, new String[]{"_id"}, "_data=? ", new String[]{filePath}, null);
        if (cursor != null && cursor.moveToFirst()) {
            int id = cursor.getInt(cursor.getColumnIndex("_id"));
            cursor.close();
            return Uri.withAppendedPath((Uri)baseUri, (String)("" + id));
        }
        if (file.exists()) {
            ContentValues values = new ContentValues();
            values.put("_data", filePath);
            return context.getContentResolver().insert(baseUri, values);
        }
        return null;
    }

    public static boolean isPrivatePath(@NonNull Context context, @NonNull String path) {
        if (FileUtils.isSpace(path)) {
            return false;
        }
        String appIntPath = FileUtils.getAppIntPath(context);
        String appExtPath = FileUtils.getAppExtPath(context);
        return !TextUtils.isEmpty((CharSequence)appIntPath) && path.startsWith(appIntPath) || !TextUtils.isEmpty((CharSequence)appExtPath) && path.startsWith(appExtPath);
    }

    public static boolean isPublicPath(File file) {
        if (file == null) {
            return false;
        }
        try {
            return FileUtils.isPublicPath(file.getCanonicalPath());
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean isPublicPath(String filePath) {
        if (FileUtils.isSpace(filePath)) {
            return false;
        }
        return filePath.startsWith(EXT_STORAGE_PATH) && !filePath.startsWith(APP_EXT_STORAGE_PATH);
    }

    private static boolean isSpace(String s) {
        if (s == null) {
            return true;
        }
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            if (Character.isWhitespace(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static void closeIOQuietly(Closeable ... closeables) {
        if (closeables == null) {
            return;
        }
        for (Closeable closeable : closeables) {
            if (closeable == null) continue;
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static AssetFileDescriptor openAssetFileDescriptor(Uri uri) throws FileNotFoundException {
        return FileUtils.getContentResolver().openAssetFileDescriptor(uri, MODE_READ_ONLY);
    }

    private static ContentResolver getContentResolver() {
        return BaseApplication.getContext().getContentResolver();
    }

    public static String getExtStoragePath() {
        return Environment.getExternalStorageDirectory().getAbsolutePath();
    }

    public static String getExtDownloadsPath() {
        return Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DOWNLOADS).getAbsolutePath();
    }

    public static String getExtPicturesPath() {
        return Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_PICTURES).getAbsolutePath();
    }

    public static String getExtDCIMPath() {
        return Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DCIM).getAbsolutePath();
    }

    public static String getAppIntPath(@NonNull Context context) {
        File appIntCacheFile = context.getCacheDir();
        if (appIntCacheFile != null) {
            String appIntCachePath = appIntCacheFile.getAbsolutePath();
            return FileUtils.getDirName(appIntCachePath);
        }
        return null;
    }

    public static String getAppExtPath(@NonNull Context context) {
        File appExtCacheFile = context.getExternalCacheDir();
        if (appExtCacheFile != null) {
            String appExtCachePath = appExtCacheFile.getAbsolutePath();
            return FileUtils.getDirName(appExtCachePath);
        }
        return null;
    }

    public static String getDirName(String filePath) {
        if (FileUtils.isSpace(filePath)) {
            return filePath;
        }
        int lastSep = filePath.lastIndexOf(File.separator);
        return lastSep == -1 ? "" : filePath.substring(0, lastSep + 1);
    }
}

