/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.business.utils;

import android.text.TextUtils;
import com.xshare.business.utils.LogUtils;
import java.io.File;
import java.io.FileInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class MD5Utils {
    private static final String TAG = MD5Utils.class.getSimpleName();

    public static String getMD5String(String s) {
        if (TextUtils.isEmpty((CharSequence)s)) {
            return "";
        }
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        try {
            byte[] btInput = s.getBytes();
            MessageDigest mdInst = MessageDigest.getInstance("MD5");
            mdInst.update(btInput);
            byte[] md = mdInst.digest();
            int j = md.length;
            char[] str = new char[j * 2];
            int k = 0;
            for (byte byte0 : md) {
                str[k++] = hexDigits[byte0 >>> 4 & 0xF];
                str[k++] = hexDigits[byte0 & 0xF];
            }
            return new String(str);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static boolean checkFileMD5(String filePath, String md5) {
        if (TextUtils.isEmpty((CharSequence)filePath) || TextUtils.isEmpty((CharSequence)md5)) {
            return false;
        }
        if (new File(filePath).exists()) {
            String fmd5 = MD5Utils.getFileMD5(filePath);
            return !TextUtils.isEmpty((CharSequence)md5) && md5.equalsIgnoreCase(fmd5);
        }
        return false;
    }

    public static String getFileMD5(String file) {
        if (TextUtils.isEmpty((CharSequence)file)) {
            return null;
        }
        return MD5Utils.getFileMD5(new File(file));
    }

    public static String getFileMD5(File file) {
        MessageDigest digest;
        LogUtils.d(TAG, "getFileMD5 start:" + file);
        if (file == null || !file.isFile()) {
            return null;
        }
        byte[] buffer = new byte[1024];
        try {
            int len;
            digest = MessageDigest.getInstance("MD5");
            FileInputStream in = new FileInputStream(file);
            while ((len = in.read(buffer, 0, 1024)) != -1) {
                digest.update(buffer, 0, len);
            }
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        LogUtils.d(TAG, "getFileMD5 end");
        return MD5Utils.bytesToHexString(digest.digest());
    }

    public static String bytesToHexString(byte[] src) {
        LogUtils.d(TAG, "bytesToHexString start");
        StringBuilder stringBuilder = new StringBuilder();
        if (src == null || src.length <= 0) {
            return null;
        }
        for (byte b : src) {
            int v = b & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(hv);
        }
        LogUtils.d(TAG, "bytesToHexString end size:" + stringBuilder.length());
        return stringBuilder.toString();
    }

    public static String md5(String s) {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            digest.update(s.getBytes());
            byte[] messageDigest = digest.digest();
            StringBuilder hexString = new StringBuilder();
            for (byte b : messageDigest) {
                hexString.append(Integer.toHexString(0xFF & b));
            }
            return hexString.toString();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return "";
        }
    }
}

