/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.business.utils;

import android.util.Log;
import com.xshare.business.utils.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.regex.Pattern;
import org.json.JSONException;
import org.json.JSONObject;

public class NetUtils {
    private static final String TAG = "NetUtils";
    private static final Pattern IPV4_PATTERN = Pattern.compile("^(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$");
    public static final String sGetAddrUrl = "http://ip-api.com/json/";

    public static boolean isIPv4Address(String input) {
        return IPV4_PATTERN.matcher(input).matches();
    }

    public static InetAddress getLocalIPAddress() {
        Enumeration<NetworkInterface> enumeration = null;
        try {
            enumeration = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                NetworkInterface nif = enumeration.nextElement();
                Enumeration<InetAddress> inetAddresses = nif.getInetAddresses();
                if (inetAddresses == null) continue;
                while (inetAddresses.hasMoreElements()) {
                    InetAddress inetAddress = inetAddresses.nextElement();
                    if (inetAddress.isLoopbackAddress() || !NetUtils.isIPv4Address(inetAddress.getHostAddress())) continue;
                    return inetAddress;
                }
            }
        }
        return null;
    }

    public static boolean isUsbNet() {
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface intf = en.nextElement();
                Enumeration<InetAddress> enumIpAddr = intf.getInetAddresses();
                while (enumIpAddr.hasMoreElements()) {
                    InetAddress inetAddress = enumIpAddr.nextElement();
                    if (intf.isLoopback() || !intf.getName().contains("rndis")) continue;
                    return true;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCountryCodeByIP(String foreignIPString) {
        String countryCode = "";
        InputStream inStream = null;
        try {
            URL url = new URL("http://ip-api.com/json/#" + foreignIPString);
            URLConnection conn = url.openConnection();
            inStream = conn.getInputStream();
            byte[] buffer = new byte[1204];
            StringBuilder json = new StringBuilder();
            while (inStream.read(buffer) != -1) {
                String str = new String(buffer);
                json.append(str);
            }
            try {
                JSONObject result = new JSONObject(String.valueOf(json));
                countryCode = result.getString("countryCode");
                LogUtils.d("IPUtil", "countryCode :" + countryCode);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (inStream != null) {
                    inStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return countryCode;
    }

    public static String intIP2StringIP(int ip) {
        return (ip & 0xFF) + "." + (ip >> 8 & 0xFF) + "." + (ip >> 16 & 0xFF) + "." + (ip >> 24 & 0xFF);
    }

    public static String longToIp(long ip) {
        StringBuffer sb = new StringBuffer();
        sb.append((int)(ip & 0xFFL));
        sb.append('.');
        sb.append((int)(ip >> 8 & 0xFFL));
        sb.append('.');
        sb.append((int)(ip >> 16 & 0xFFL));
        sb.append('.');
        sb.append((int)(ip >> 24 & 0xFFL));
        return sb.toString();
    }

    public static long ipToLong(String ip) {
        String[] ipArray = ip.split("\\.");
        ArrayList<Long> ipNums = new ArrayList<Long>();
        for (int i = 0; i < 4; ++i) {
            ipNums.add(Long.parseLong(ipArray[i].trim()));
        }
        long myIp = (Long)ipNums.get(3) * 256L * 256L * 256L + (Long)ipNums.get(2) * 256L * 256L + (Long)ipNums.get(1) * 256L + (Long)ipNums.get(0);
        return myIp;
    }

    public static boolean isVpnUsed() {
        try {
            Enumeration<NetworkInterface> nList = NetworkInterface.getNetworkInterfaces();
            if (nList != null) {
                for (NetworkInterface intf : Collections.list(nList)) {
                    if (!intf.isUp() || intf.getInterfaceAddresses().size() == 0) continue;
                    Log.d((String)TAG, (String)("isVpnUsed: " + intf.getName()));
                    if (!"tun0".equals(intf.getName()) && !"tun1".equals(intf.getName()) && !"ppp0".equals(intf.getName())) continue;
                    return true;
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return false;
    }

    public static boolean isValidWifiPWD(String pwd) {
        try {
            for (int i = 0; i < pwd.length(); ++i) {
                char temp = pwd.charAt(i);
                if (temp >= ' ' && temp <= 'z') continue;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

