/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.business.utils;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.BitmapFactory;
import android.os.Build;
import android.provider.MediaStore;
import com.xshare.trans.R;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/xshare/business/utils/NotifyManager;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "getContext", "()Landroid/content/Context;", "notification", "Landroid/app/Notification$Builder;", "notificationManager", "Landroid/app/NotificationManager;", "notifyId", "", "startNotificationManager", "", "updateProgress", "progress", "app_release"})
public final class NotifyManager {
    @NotNull
    private final Context context;
    @Nullable
    private NotificationManager notificationManager;
    @Nullable
    private Notification.Builder notification;
    private final int notifyId;

    public NotifyManager(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.notifyId = 256;
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    public final void startNotificationManager() {
        long[] lArray = new long[]{0L, 500L, 1000L, 1500L};
        long[] vibrate = lArray;
        if (Build.VERSION.SDK_INT >= 26) {
            Object object = this.context.getSystemService("notification");
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.app.NotificationManager");
            }
            this.notificationManager = (NotificationManager)object;
            this.notification = new Notification.Builder(this.context.getApplicationContext(), String.valueOf(System.currentTimeMillis())).setContentTitle((CharSequence)"\u4e0b\u8f7d\u8fdb\u5ea6").setContentText((CharSequence)"app\u4e0b\u8f7d").setWhen(System.currentTimeMillis()).setSmallIcon(R.mipmap.ic_launcher).setLargeIcon(BitmapFactory.decodeResource((Resources)this.context.getResources(), (int)R.mipmap.ic_launcher)).setVibrate(vibrate).setDefaults(-1).setChannelId(this.context.getPackageName()).setSound(MediaStore.Audio.Media.INTERNAL_CONTENT_URI);
            NotificationChannel channel = new NotificationChannel(this.context.getPackageName(), (CharSequence)"app\u4e0b\u8f7d", 3);
            NotificationManager notificationManager = this.notificationManager;
            if (notificationManager != null) {
                notificationManager.createNotificationChannel(channel);
            }
            NotificationManager notificationManager2 = this.notificationManager;
            if (notificationManager2 != null) {
                Notification.Builder builder = this.notification;
                notificationManager2.notify(this.notifyId, (Notification)(builder == null ? null : builder.build()));
            }
        } else {
            this.notification = new Notification.Builder(this.context).setContentTitle((CharSequence)"\u4e0b\u8f7d\u8fdb\u5ea6").setContentText((CharSequence)"app\u4e0b\u8f7d").setWhen(System.currentTimeMillis()).setSmallIcon(R.mipmap.ic_launcher).setVibrate(vibrate).setWhen(System.currentTimeMillis()).setDefaults(-1).setSound(MediaStore.Audio.Media.INTERNAL_CONTENT_URI);
            NotificationManager notificationManager = this.notificationManager;
            if (notificationManager != null) {
                Notification.Builder builder = this.notification;
                notificationManager.notify(this.notifyId, (Notification)(builder == null ? null : builder.build()));
            }
        }
    }

    public final void updateProgress(int progress) {
        if (progress == 100) {
            NotificationManager notificationManager = this.notificationManager;
            if (notificationManager != null) {
                notificationManager.cancel(this.notifyId);
            }
        } else {
            Notification.Builder builder = this.notification;
            if (builder != null) {
                builder.setProgress(100, progress, false);
            }
            NotificationManager notificationManager = this.notificationManager;
            if (notificationManager != null) {
                Notification.Builder builder2 = this.notification;
                notificationManager.notify(this.notifyId, (Notification)(builder2 == null ? null : builder2.build()));
            }
        }
    }
}

