/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.business.utils;

import android.bluetooth.BluetoothAdapter;
import android.content.ContentResolver;
import android.content.Context;
import android.location.LocationManager;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.Environment;
import android.provider.Settings;
import androidx.core.content.ContextCompat;
import com.xshare.base.BaseApplication;
import com.xshare.business.utils.LogUtils;
import com.xshare.business.utils.NetUtils;
import com.xshare.business.utils.WifiManagerHelper;
import com.xshare.business.utils.XShareUtils;
import com.xshare.business.wifi.XSWiFiManager;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class PermissionCheckUtils {
    public static final String TAG = "PermissionCheckUtils";
    public static final String SEND_PAGE = "send_page";
    public static final String RECEIVE_PAGE = "receive_page";
    public static final String QRCODE_PAGE = "qr_code_page";
    public static final String XS_BLUETOOTH_PAGE = "xs_bluetooth_page";
    public static final String XS_HOTSPOT_PAGE = "xs_hotspot_page";
    public static final String HOTSPOT_SHARE_AP_TO_DIRECT = "hotspot_share_ap_to_direct";
    public static final String ASSISTANT_BACKUP = "assistant_backup";
    public static final String PHONE_CLONE_NEW = "phone_clone_new";
    public static final String PHONE_CLONE_OLD = "phone_clone_old";
    public static final String XS_STORAGE = "xs_storage";
    public static List<String> mDeniedPermissionList = new ArrayList<String>();

    public static boolean hasPermission(Context context, String source) {
        boolean isShowInstallApp = false;
        boolean hotSpotOrWifiDisabled = false;
        LogUtils.d(TAG, "source: " + source);
        switch (source) {
            case "xs_storage": {
                if (Build.VERSION.SDK_INT >= 30) {
                    return PermissionCheckUtils.hasExternalStoragePermission();
                }
                boolean isStorageEnable = PermissionCheckUtils.checkStorage(context);
                return isStorageEnable;
            }
            case "send_page": {
                boolean isWhatsAppModeOn;
                boolean isLocationDisable;
                boolean installDisabled;
                boolean isSettingWriteEnable = PermissionCheckUtils.checkCanWriteSetting(context);
                if (!isSettingWriteEnable) {
                    return false;
                }
                boolean usbNet = NetUtils.isUsbNet();
                if (usbNet) {
                    return false;
                }
                if (Build.VERSION.SDK_INT > 29) {
                    isShowInstallApp = PermissionCheckUtils.checkShowInstallApp(context);
                }
                boolean bl = installDisabled = !XShareUtils.hasSilenceInstallPerm(context) && isShowInstallApp;
                if (installDisabled) {
                    return false;
                }
                if (Build.VERSION.SDK_INT < 26) {
                    boolean isHotSpotDisable;
                    WifiManager mWifiManager = (WifiManager)BaseApplication.baseApplication.getApplicationContext().getSystemService("wifi");
                    boolean bl2 = isHotSpotDisable = !WifiManagerHelper.isWifiApEnabled(mWifiManager);
                    if (isHotSpotDisable && Build.VERSION.SDK_INT != 25) {
                        hotSpotOrWifiDisabled = true;
                    }
                } else {
                    boolean bl3 = hotSpotOrWifiDisabled = !XSWiFiManager.getInstance().checkWifiEnable();
                }
                if (hotSpotOrWifiDisabled) {
                    return false;
                }
                boolean bl4 = isLocationDisable = !PermissionCheckUtils.isLocationServiceEnable(context);
                if (isLocationDisable) {
                    return false;
                }
                boolean isEnableLocation = PermissionCheckUtils.checkAccessCoarseLocation(context);
                if (!isEnableLocation) {
                    return false;
                }
                boolean isStorageEnable = PermissionCheckUtils.checkStorage(context);
                if (!isStorageEnable) {
                    return false;
                }
                boolean bl5 = isWhatsAppModeOn = Settings.Global.getInt((ContentResolver)BaseApplication.baseApplication.getContentResolver(), (String)"doze_whatsapp_mode", (int)-1) == 1;
                if (isWhatsAppModeOn) {
                    return false;
                }
                boolean isVpnUse = NetUtils.isVpnUsed();
                return !isVpnUse;
            }
            case "receive_page": {
                boolean isWhatsAppModeOn;
                boolean isLocationDisable;
                boolean installDisabled;
                boolean isSettingWriteEnable = PermissionCheckUtils.checkCanWriteSetting(context);
                if (!isSettingWriteEnable) {
                    return false;
                }
                boolean usbNet = NetUtils.isUsbNet();
                if (usbNet) {
                    return false;
                }
                if (Build.VERSION.SDK_INT > 29) {
                    isShowInstallApp = PermissionCheckUtils.checkShowInstallApp(context);
                }
                boolean bl = installDisabled = !XShareUtils.hasSilenceInstallPerm(context) && isShowInstallApp;
                if (installDisabled) {
                    return false;
                }
                boolean bl6 = hotSpotOrWifiDisabled = !XSWiFiManager.getInstance().checkWifiEnable();
                if (hotSpotOrWifiDisabled) {
                    return false;
                }
                boolean bl7 = isLocationDisable = !PermissionCheckUtils.isLocationServiceEnable(context);
                if (isLocationDisable) {
                    return false;
                }
                boolean isEnableLocation = PermissionCheckUtils.checkAccessCoarseLocation(context);
                if (!isEnableLocation) {
                    return false;
                }
                boolean isEnableFineLocation = PermissionCheckUtils.checkAccessFineLocation(context);
                if (!isEnableFineLocation) {
                    return false;
                }
                boolean isStorageEnable = PermissionCheckUtils.checkStorage(context);
                if (!isStorageEnable) {
                    return false;
                }
                boolean bl8 = isWhatsAppModeOn = Settings.Global.getInt((ContentResolver)BaseApplication.baseApplication.getContentResolver(), (String)"doze_whatsapp_mode", (int)-1) == 1;
                if (isWhatsAppModeOn) {
                    return false;
                }
                boolean isVpnUse = NetUtils.isVpnUsed();
                return !isVpnUse;
            }
            case "qr_code_page": {
                boolean isWhatsAppModeOn;
                boolean isLocationDisable;
                boolean isSettingWriteEnable = PermissionCheckUtils.checkCanWriteSetting(context);
                if (!isSettingWriteEnable) {
                    return false;
                }
                boolean usbNet = NetUtils.isUsbNet();
                if (usbNet) {
                    return false;
                }
                boolean bl = hotSpotOrWifiDisabled = !XSWiFiManager.getInstance().checkWifiEnable();
                if (hotSpotOrWifiDisabled) {
                    return false;
                }
                boolean bl9 = isLocationDisable = !PermissionCheckUtils.isLocationServiceEnable(context);
                if (isLocationDisable) {
                    return false;
                }
                boolean isEnableLocation = PermissionCheckUtils.checkAccessCoarseLocation(context);
                if (!isEnableLocation) {
                    return false;
                }
                boolean isEnableFineLocation = PermissionCheckUtils.checkAccessFineLocation(context);
                if (!isEnableFineLocation) {
                    return false;
                }
                boolean isStorageEnable = PermissionCheckUtils.checkStorage(context);
                if (!isStorageEnable) {
                    return false;
                }
                boolean bl10 = isWhatsAppModeOn = Settings.Global.getInt((ContentResolver)BaseApplication.baseApplication.getContentResolver(), (String)"doze_whatsapp_mode", (int)-1) == 1;
                if (isWhatsAppModeOn) {
                    return false;
                }
                boolean isVpnUse = NetUtils.isVpnUsed();
                if (isVpnUse) {
                    return false;
                }
                boolean isEnableCamera = PermissionCheckUtils.checkCamera(context);
                return isEnableCamera;
            }
            case "xs_bluetooth_page": {
                if (PermissionCheckUtils.checkBluetooth(context)) {
                    return false;
                }
                boolean isStorageEnable = PermissionCheckUtils.checkStorage(context);
                return isStorageEnable;
            }
            case "xs_hotspot_page": {
                boolean wifiDisable;
                boolean isWhatsAppModeOn;
                boolean isEnableLocation = PermissionCheckUtils.checkAccessCoarseLocation(context);
                if (!isEnableLocation) {
                    return false;
                }
                boolean isStorageEnable = PermissionCheckUtils.checkStorage(context);
                if (!isStorageEnable) {
                    return false;
                }
                boolean bl = isWhatsAppModeOn = Settings.Global.getInt((ContentResolver)BaseApplication.baseApplication.getContentResolver(), (String)"doze_whatsapp_mode", (int)-1) == 1;
                if (isWhatsAppModeOn) {
                    return false;
                }
                boolean isVpnUse = NetUtils.isVpnUsed();
                if (isVpnUse) {
                    return false;
                }
                boolean bl11 = wifiDisable = !XSWiFiManager.getInstance().checkWifiEnable();
                if (wifiDisable) {
                    return false;
                }
                boolean isLocationDisable = !PermissionCheckUtils.isLocationServiceEnable(context);
                return !isLocationDisable;
            }
            case "hotspot_share_ap_to_direct": {
                boolean isWhatsAppModeOn;
                boolean isSettingWriteEnable = PermissionCheckUtils.checkCanWriteSetting(context);
                if (!isSettingWriteEnable) {
                    return false;
                }
                boolean isEnableLocation = PermissionCheckUtils.checkAccessCoarseLocation(context);
                if (!isEnableLocation) {
                    return false;
                }
                boolean isStorageEnable = PermissionCheckUtils.checkStorage(context);
                if (!isStorageEnable) {
                    return false;
                }
                boolean bl = isWhatsAppModeOn = Settings.Global.getInt((ContentResolver)BaseApplication.baseApplication.getContentResolver(), (String)"doze_whatsapp_mode", (int)-1) == 1;
                if (isWhatsAppModeOn) {
                    return false;
                }
                boolean usbNet = NetUtils.isUsbNet();
                if (usbNet) {
                    return false;
                }
                if (PermissionCheckUtils.checkBluetooth(context)) {
                    return false;
                }
                boolean isVpnUse = NetUtils.isVpnUsed();
                if (isVpnUse) {
                    return false;
                }
                if (Build.VERSION.SDK_INT < 26) {
                    boolean isHotSpotDisable;
                    WifiManager mWifiManager = (WifiManager)BaseApplication.baseApplication.getApplicationContext().getSystemService("wifi");
                    boolean bl12 = isHotSpotDisable = !WifiManagerHelper.isWifiApEnabled(mWifiManager);
                    if (isHotSpotDisable && Build.VERSION.SDK_INT != 25) {
                        hotSpotOrWifiDisabled = true;
                    }
                } else {
                    boolean bl13 = hotSpotOrWifiDisabled = !XSWiFiManager.getInstance().checkWifiEnable();
                }
                if (hotSpotOrWifiDisabled) {
                    return false;
                }
                boolean isLocationDisable = !PermissionCheckUtils.isLocationServiceEnable(context);
                return !isLocationDisable;
            }
            case "assistant_backup": {
                boolean installDisabled;
                boolean isSettingWriteEnable = PermissionCheckUtils.checkCanWriteSetting(context);
                if (!isSettingWriteEnable) {
                    return false;
                }
                boolean usbNet = NetUtils.isUsbNet();
                if (usbNet) {
                    return false;
                }
                boolean isReadSms = PermissionCheckUtils.checkReadSMS(context);
                if (!isReadSms) {
                    return false;
                }
                boolean isReadContacts = PermissionCheckUtils.checkReadContacts(context);
                if (!isReadContacts) {
                    return false;
                }
                boolean isReadCallLog = PermissionCheckUtils.checkReadCallLog(context);
                if (!isReadCallLog) {
                    return false;
                }
                if (Build.VERSION.SDK_INT > 29) {
                    isShowInstallApp = PermissionCheckUtils.checkShowInstallApp(context);
                }
                boolean bl = installDisabled = !XShareUtils.hasSilenceInstallPerm(context) && isShowInstallApp;
                if (installDisabled) {
                    return false;
                }
                boolean isStorageEnable = PermissionCheckUtils.checkStorage(context);
                if (!isStorageEnable) {
                    return false;
                }
                boolean isWhatsAppModeOn = Settings.Global.getInt((ContentResolver)BaseApplication.baseApplication.getContentResolver(), (String)"doze_whatsapp_mode", (int)-1) == 1;
                return !isWhatsAppModeOn;
            }
            case "phone_clone_new": {
                boolean isWhatsAppModeOn;
                boolean installDisabled;
                boolean isSettingWriteEnable = PermissionCheckUtils.checkCanWriteSetting(context);
                if (!isSettingWriteEnable) {
                    return false;
                }
                boolean isEnableLocation = PermissionCheckUtils.checkAccessCoarseLocation(context);
                if (!isEnableLocation) {
                    return false;
                }
                boolean isEnableCamera = PermissionCheckUtils.checkCamera(context);
                if (!isEnableCamera) {
                    return false;
                }
                if (Build.VERSION.SDK_INT > 29) {
                    isShowInstallApp = PermissionCheckUtils.checkShowInstallApp(context);
                }
                boolean bl = installDisabled = !XShareUtils.hasSilenceInstallPerm(context) && isShowInstallApp;
                if (installDisabled) {
                    return false;
                }
                boolean isStorageEnable = PermissionCheckUtils.checkStorage(context);
                if (!isStorageEnable) {
                    return !isStorageEnable;
                }
                boolean bl14 = isWhatsAppModeOn = Settings.Global.getInt((ContentResolver)BaseApplication.baseApplication.getContentResolver(), (String)"doze_whatsapp_mode", (int)-1) == 1;
                if (isWhatsAppModeOn) {
                    return false;
                }
                boolean isVpnUse = NetUtils.isVpnUsed();
                if (isVpnUse) {
                    return false;
                }
                if (Build.VERSION.SDK_INT < 26) {
                    boolean isHotSpotDisable;
                    WifiManager mWifiManager = (WifiManager)BaseApplication.baseApplication.getApplicationContext().getSystemService("wifi");
                    boolean bl15 = isHotSpotDisable = !WifiManagerHelper.isWifiApEnabled(mWifiManager);
                    if (isHotSpotDisable) {
                        hotSpotOrWifiDisabled = true;
                    }
                } else {
                    boolean bl16 = hotSpotOrWifiDisabled = !XSWiFiManager.getInstance().checkWifiEnable();
                }
                if (hotSpotOrWifiDisabled) {
                    return false;
                }
                boolean isLocationDisable = !PermissionCheckUtils.isLocationServiceEnable(context);
                return !isLocationDisable;
            }
            case "phone_clone_old": {
                boolean isWhatsAppModeOn;
                boolean isSettingWriteEnable = PermissionCheckUtils.checkCanWriteSetting(context);
                if (!isSettingWriteEnable) {
                    return false;
                }
                boolean isEnableLocation = PermissionCheckUtils.checkAccessCoarseLocation(context);
                if (!isEnableLocation) {
                    return false;
                }
                boolean isEnableCamera = PermissionCheckUtils.checkCamera(context);
                if (!isEnableCamera) {
                    return false;
                }
                boolean isStorageEnable = PermissionCheckUtils.checkStorage(context);
                if (!isStorageEnable) {
                    return !isStorageEnable;
                }
                boolean bl = isWhatsAppModeOn = Settings.Global.getInt((ContentResolver)BaseApplication.baseApplication.getContentResolver(), (String)"doze_whatsapp_mode", (int)-1) == 1;
                if (isWhatsAppModeOn) {
                    return false;
                }
                boolean isVpnUse = NetUtils.isVpnUsed();
                if (isVpnUse) {
                    return false;
                }
                if (Build.VERSION.SDK_INT < 26) {
                    boolean isHotSpotDisable;
                    WifiManager mWifiManager = (WifiManager)BaseApplication.baseApplication.getApplicationContext().getSystemService("wifi");
                    boolean bl17 = isHotSpotDisable = !WifiManagerHelper.isWifiApEnabled(mWifiManager);
                    if (isHotSpotDisable) {
                        hotSpotOrWifiDisabled = true;
                    }
                } else {
                    boolean bl18 = hotSpotOrWifiDisabled = !XSWiFiManager.getInstance().checkWifiEnable();
                }
                if (hotSpotOrWifiDisabled) {
                    return false;
                }
                boolean isLocationDisable = !PermissionCheckUtils.isLocationServiceEnable(context);
                return !isLocationDisable;
            }
        }
        return true;
    }

    public static boolean missPermission(String permission2) {
        boolean miss = false;
        if (mDeniedPermissionList.contains(permission2)) {
            miss = true;
            mDeniedPermissionList.remove(permission2);
        }
        return miss;
    }

    public static boolean checkReadSMS(Context context) {
        if (context == null) {
            return false;
        }
        return ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.READ_SMS") == 0;
    }

    public static boolean checkReadCallLog(Context context) {
        if (context == null) {
            return false;
        }
        return ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.READ_CALL_LOG") == 0;
    }

    public static boolean checkReadContacts(Context context) {
        if (context == null) {
            return false;
        }
        return ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.READ_CONTACTS") == 0;
    }

    public static boolean checkCanWriteSetting(Context context) {
        if (context == null) {
            return false;
        }
        return Build.VERSION.SDK_INT < 23 || Settings.System.canWrite((Context)context);
    }

    public static boolean checkShowInstallApp(Context context) {
        if (context == null) {
            return false;
        }
        if (Build.VERSION.SDK_INT >= 26) {
            return !context.getPackageManager().canRequestPackageInstalls();
        }
        return false;
    }

    public static boolean checkAccessCoarseLocation(Context context) {
        if (context == null) {
            return false;
        }
        return ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.ACCESS_COARSE_LOCATION") == 0;
    }

    public static boolean checkWriteExternalStorage(Context context) {
        if (context == null) {
            return false;
        }
        return ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.WRITE_EXTERNAL_STORAGE") == 0;
    }

    public static boolean checkCamera(Context context) {
        if (context == null) {
            return false;
        }
        return ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.CAMERA") == 0;
    }

    public static boolean checkReadExternalStorage(Context context) {
        if (context == null) {
            return false;
        }
        return ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.READ_EXTERNAL_STORAGE") == 0;
    }

    public static boolean checkAccessFineLocation(Context context) {
        if (context == null) {
            return false;
        }
        return ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.ACCESS_FINE_LOCATION") == 0;
    }

    public static boolean checkWriteContacts(Context context) {
        if (context == null) {
            return false;
        }
        return ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.WRITE_CALL_LOG") == 0;
    }

    public static boolean checkWriteCallLog(Context context) {
        if (context == null) {
            return false;
        }
        return ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.WRITE_CALL_LOG") == 0;
    }

    public static boolean checkStorage(Context context) {
        if (context == null) {
            return false;
        }
        if (Build.VERSION.SDK_INT >= 30) {
            return PermissionCheckUtils.hasExternalStoragePermission();
        }
        return PermissionCheckUtils.checkWriteExternalStorage(context) && PermissionCheckUtils.checkReadExternalStorage(context);
    }

    public static boolean checkBluetooth(Context context) {
        if (Build.VERSION.SDK_INT >= 31) {
            return ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.BLUETOOTH_SCAN") == 0 && ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.BLUETOOTH_CONNECT") == 0;
        }
        BluetoothAdapter directBlueadapter = BluetoothAdapter.getDefaultAdapter();
        return directBlueadapter == null || !directBlueadapter.isEnabled();
    }

    public static boolean isLocationServiceEnable(Context context) {
        LocationManager locationManager = (LocationManager)context.getSystemService("location");
        boolean gps = locationManager.isProviderEnabled("gps");
        boolean network = locationManager.isProviderEnabled("network");
        return gps || network;
    }

    public static boolean hasExternalStoragePermission() {
        if (Build.VERSION.SDK_INT < 30) {
            return true;
        }
        try {
            Method isExternalStorageManager = Environment.class.getMethod("isExternalStorageManager", new Class[0]);
            return (Boolean)isExternalStorageManager.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isPermissionNice(Context context) {
        if (Build.VERSION.SDK_INT >= 30) {
            boolean externalStorageManager = Environment.isExternalStorageManager();
            return externalStorageManager;
        }
        return PermissionCheckUtils.checkStorage(context) || Build.VERSION.SDK_INT < 23;
    }
}

