/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.business.utils;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Environment;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.text.TextUtils;
import android.util.Log;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.Date;

public final class WiFiLog {
    private static final boolean DEBUG = true;
    private static final String TAG_ROOT = "XSLOG";
    private static final String TAG_WIFI = "WFLOG";
    private static final String TAG_SOCKET = "SOCKET";
    private static final String TAG_TRANSFER = "TRANSFER";
    private static final String TAG_CLONE = "CLONE";
    private static final String TAG_ASSISTANT = "ASSISTANT";
    private long startCreateHotSpotTime;
    private static final String basePath = Environment.getExternalStorageDirectory().getAbsolutePath() + File.separator + "log" + File.separator;
    private static String fileName = null;
    private static boolean isAppend = false;
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
    private HandlerThread mHandlerThread = new HandlerThread("WiFiLog", -1);
    private Handler mHandler;
    private final int WRITE = 1001;
    private long startHotSpotConnectTime;
    private long startSocketConnectTime;

    public long getStartCreateHotSpotTime() {
        return this.startCreateHotSpotTime;
    }

    public void setStartCreateHotSpotTime(long startCreateHotSpotTime) {
        this.startCreateHotSpotTime = startCreateHotSpotTime;
        this.w(TAG_WIFI, "setStartCreateHotSpotTime:" + this.startCreateHotSpotTime);
    }

    public long getStartHotSpotConnectTime() {
        return this.startHotSpotConnectTime;
    }

    public void setStartHotSpotConnectTime(long startHotSpotConnectTime) {
        this.startHotSpotConnectTime = startHotSpotConnectTime;
        this.w(TAG_WIFI, "setStartHotSpotConnectTime:" + this.startHotSpotConnectTime);
    }

    public long getStartSocketConnectTime() {
        return this.startSocketConnectTime;
    }

    public void setStartSocketConnectTime(long startSocketConnectTime) {
        this.startSocketConnectTime = startSocketConnectTime;
        this.w(TAG_WIFI, "setStartSocketConnectTime:" + this.startSocketConnectTime);
    }

    public static WiFiLog getInstance() {
        return SingleTonHolder.INSTANCE;
    }

    private WiFiLog() {
        this.mHandlerThread.start();
        this.mHandler = new Handler(this.mHandlerThread.getLooper()){

            public void dispatchMessage(Message msg) {
                switch (msg.what) {
                    case 1001: {
                        String logStr = (String)msg.obj;
                        WiFiLog.this.writeLog2SDCard(logStr);
                    }
                }
            }
        };
    }

    public void e(String tag, String msg) {
        this.wifiLog(tag, msg, 6);
    }

    public void e(String tag, String msg, Throwable t) {
        this.wifiLog(tag, msg, 6, t);
    }

    public void i(String tag, String msg) {
        this.wifiLog(tag, msg, 4);
    }

    public void i(String tag, String msg, Throwable t) {
        this.wifiLog(tag, msg, 4, t);
    }

    public void w(String tag, String msg) {
        this.wifiLog(tag, msg, 5);
    }

    public void d(String tag, String msg) {
        this.wifiLog(tag, msg, 3);
    }

    public void d(String tag, String msg, Throwable t) {
        this.wifiLog(tag, msg, 3, t);
    }

    public void log(String parentTag, String tag, String msg, int level) {
        this.log(parentTag, tag, msg, level, null);
    }

    public void log(String parentTag, String tag, String msg, int level, Throwable t) {
        String logMsg = TextUtils.isEmpty((CharSequence)tag) ? msg : tag + ":" + msg;
        String vtag = "XSLOG->" + parentTag;
        switch (level) {
            case 2: {
                Log.v((String)vtag, (String)logMsg, (Throwable)t);
                break;
            }
            case 3: {
                Log.d((String)vtag, (String)logMsg, (Throwable)t);
                break;
            }
            case 4: {
                Log.i((String)vtag, (String)logMsg, (Throwable)t);
                break;
            }
            case 5: {
                Log.w((String)vtag, (String)logMsg, (Throwable)t);
                break;
            }
            case 6: {
                Log.e((String)vtag, (String)logMsg, (Throwable)t);
            }
        }
        if (this.canSaveMsgToSD(parentTag)) {
            this.submitMsg(vtag + "->" + logMsg);
        }
    }

    private boolean canSaveMsgToSD(String parentTag) {
        return this.mHandler != null && (TAG_ASSISTANT.equals(parentTag) || TAG_CLONE.equals(parentTag));
    }

    private void submitMsg(String saveMsg) {
        if (this.mHandler != null) {
            Message hMsg = this.mHandler.obtainMessage(1001);
            if (hMsg == null) {
                hMsg = new Message();
                hMsg.what = 1001;
            }
            hMsg.obj = saveMsg;
            this.mHandler.sendMessage(hMsg);
        }
    }

    public void wifiLog(String tag, String msg, int level) {
        this.wifiLog(tag, msg, level, null);
    }

    public void wifiLog(String tag, String msg, int level, Throwable t) {
        this.log(TAG_WIFI, tag, msg, level, t);
    }

    public void socketLog(String tag, String msg, int level) {
        this.log(TAG_SOCKET, tag, msg, level);
    }

    public void transferLog(String tag, String msg, int level) {
        this.log(TAG_TRANSFER, tag, msg, level);
    }

    public void cloneLog(String tag, String msg, int level) {
        this.log(TAG_CLONE, tag, msg, level);
    }

    public void assistantLog(String tag, String msg, int level) {
        this.log(TAG_ASSISTANT, tag, msg, level);
    }

    public void vs(String msg) {
        this.socketLog(null, msg, 2);
    }

    public void vs(String tag, String msg) {
        this.socketLog(tag, msg, 2);
    }

    public void ds(String msg) {
        this.ds(null, msg);
    }

    public void ds(String tag, String msg) {
        this.socketLog(tag, msg, 3);
    }

    public void is(String msg) {
        this.socketLog(null, msg, 4);
    }

    public void is(String tag, String msg) {
        this.socketLog(tag, msg, 4);
    }

    public void ws(String msg) {
        this.socketLog(null, msg, 5);
    }

    public void ws(String tag, String msg) {
        this.socketLog(tag, msg, 5);
    }

    public void es(String msg) {
        this.socketLog(null, msg, 6);
    }

    public void es(String tag, String msg) {
        this.socketLog(tag, msg, 6);
    }

    public void vt(String msg) {
        this.transferLog(null, msg, 2);
    }

    public void vt(String tag, String msg) {
        this.transferLog(tag, msg, 2);
    }

    public void dt(String msg) {
        this.dt(null, msg);
    }

    public void dt(String tag, String msg) {
        this.transferLog(tag, msg, 3);
    }

    public void it(String msg) {
        this.transferLog(null, msg, 4);
    }

    public void it(String tag, String msg) {
        this.transferLog(tag, msg, 4);
    }

    public void wt(String msg) {
        this.transferLog(null, msg, 5);
    }

    public void wt(String tag, String msg) {
        this.transferLog(tag, msg, 5);
    }

    public void et(String msg) {
        this.transferLog(null, msg, 6);
    }

    public void et(String tag, String msg) {
        this.transferLog(tag, msg, 6);
    }

    public void vc(String msg) {
        this.cloneLog(null, msg, 2);
    }

    public void vc(String tag, String msg) {
        this.cloneLog(tag, msg, 2);
    }

    public void dc(String msg) {
        this.dc(null, msg);
    }

    public void dc(String tag, String msg) {
        this.cloneLog(tag, msg, 3);
    }

    public void ic(String msg) {
        this.cloneLog(null, msg, 4);
    }

    public void ic(String tag, String msg) {
        this.cloneLog(tag, msg, 4);
    }

    public void wc(String msg) {
        this.cloneLog(null, msg, 5);
    }

    public void wc(String tag, String msg) {
        this.cloneLog(tag, msg, 5);
    }

    public void ec(String msg) {
        this.cloneLog(null, msg, 6);
    }

    public void ec(String tag, String msg) {
        this.cloneLog(tag, msg, 6);
    }

    public void va(String msg) {
        this.assistantLog(null, msg, 2);
    }

    public void va(String tag, String msg) {
        this.assistantLog(tag, msg, 2);
    }

    public void da(String msg) {
        this.da(null, msg);
    }

    public void da(String tag, String msg) {
        this.assistantLog(tag, msg, 3);
    }

    public void ia(String msg) {
        this.assistantLog(null, msg, 4);
    }

    public void ia(String tag, String msg) {
        this.assistantLog(tag, msg, 4);
    }

    public void wa(String msg) {
        this.assistantLog(null, msg, 5);
    }

    public void wa(String tag, String msg) {
        this.assistantLog(tag, msg, 5);
    }

    public void ea(String msg) {
        this.assistantLog(null, msg, 6);
    }

    public void ea(String tag, String msg) {
        this.assistantLog(tag, msg, 6);
    }

    public static void printNetworkLog(Context context, String TAG) {
        try {
            WifiManager wifiManager2 = (WifiManager)context.getApplicationContext().getSystemService("wifi");
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getApplicationContext().getSystemService("connectivity");
            if (connectivityManager != null) {
                NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
                NetworkInfo.DetailedState detailedState = null;
                if (networkInfo != null) {
                    detailedState = networkInfo.getDetailedState();
                }
                int wifiState = 4;
                WifiInfo wifiInfo = null;
                if (wifiManager2 != null) {
                    wifiState = wifiManager2.getWifiState();
                    wifiInfo = wifiManager2.getConnectionInfo();
                }
                WiFiLog.getInstance().ds(TAG, "Start connect wifiStatus(WIFI_STATE_DISABLING:0, WIFI_STATE_DISABLED:1, WIFI_STATE_ENABLING:2, WIFI_STATE_ENABLED:3, WIFI_STATE_UNKNOWN:4):" + wifiState + ", NetworkInfo.DetailedState:" + detailedState + ", wifiInfo:" + wifiInfo + ", networkInfo:" + networkInfo);
            } else {
                WiFiLog.getInstance().ds(TAG, "Start connect connectivityManager is null.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void writeLog2SDCard(String msg) {
        if (fileName == null) {
            fileName = sdf.format(new Date(System.currentTimeMillis())) + ".txt";
        }
        File file = new File(basePath + fileName);
        String dateStr = sdf.format(new Date(System.currentTimeMillis()));
        msg = dateStr + "==" + msg;
        try {
            if (!file.exists()) {
                Log.e((String)TAG_ROOT, (String)("File Path:" + file.getAbsolutePath()));
                file.getParentFile().mkdirs();
                file.createNewFile();
            }
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file, isAppend)));
            bufferedWriter.write(msg);
            bufferedWriter.newLine();
            bufferedWriter.flush();
            bufferedWriter.close();
            if (!isAppend) {
                isAppend = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static class SingleTonHolder {
        private static WiFiLog INSTANCE = new WiFiLog();

        private SingleTonHolder() {
        }
    }
}

