/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.business.utils;

import android.net.wifi.ScanResult;
import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiManager;
import android.util.Log;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class WifiManagerHelper {
    private static final String TAG = "WifiManagerHelper";
    public static final String WIFI_AP_STATE_CHANGED_ACTION = "android.net.wifi.WIFI_AP_STATE_CHANGED";
    public static final String EXTRA_WIFI_AP_STATE = "wifi_state";
    public static final int WIFI_AP_STATE_DISABLED = 11;
    public static final int WIFI_AP_STATE_ENABLED = 13;
    public static final int WPA2_PSK = 4;

    public static Class getWifiManager() throws ClassNotFoundException {
        return Class.forName("android.net.wifi.WifiManager");
    }

    public static void connect(WifiManager wifiManager2, int netId) {
        try {
            Class wifiManagerClass = WifiManagerHelper.getWifiManager();
            Class<?> actionListener2 = Class.forName("android.net.wifi.WifiManager$ActionListener");
            Method connect = wifiManagerClass.getDeclaredMethod("connect", Integer.TYPE, actionListener2);
            connect.invoke((Object)wifiManager2, netId, null);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Exception when connect:" + e.getMessage()));
            e.printStackTrace();
        }
    }

    public static WifiConfiguration getWifiApConfiguration(WifiManager wifiManager2) {
        try {
            Method getWifiApConfiguration = WifiManagerHelper.getWifiManager().getDeclaredMethod("getWifiApConfiguration", new Class[0]);
            return (WifiConfiguration)getWifiApConfiguration.invoke((Object)wifiManager2, new Object[0]);
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)("Exception when getWifiApConfiguration:" + e.getMessage()));
            e.printStackTrace();
            return null;
        }
    }

    public static boolean setWifiApConfiguration(WifiManager wifiManager2, WifiConfiguration wifiConfig) {
        try {
            Method setWifiApConfiguration = WifiManagerHelper.getWifiManager().getDeclaredMethod("setWifiApConfiguration", WifiConfiguration.class);
            return (Boolean)setWifiApConfiguration.invoke((Object)wifiManager2, wifiConfig);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Exception when setWifiApConfiguration:" + e.getMessage()));
            return false;
        }
    }

    public static boolean setWifiApEnabled(WifiManager wifiManager2, boolean enabled) {
        return WifiManagerHelper.setWifiApEnabled(wifiManager2, WifiManagerHelper.getWifiApConfiguration(wifiManager2), enabled);
    }

    public static boolean setWifiApEnabled(WifiManager wifiManager2, WifiConfiguration wifiConfig, boolean enabled) {
        try {
            Method setWifiApEnabled = WifiManagerHelper.getWifiManager().getDeclaredMethod("setWifiApEnabled", WifiConfiguration.class, Boolean.TYPE);
            return (Boolean)setWifiApEnabled.invoke((Object)wifiManager2, wifiConfig, enabled);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Exception when setWifiApEnabled:" + e.getMessage()));
            return false;
        }
    }

    public static boolean isWifiApEnabled(WifiManager wifiManager2) {
        try {
            Method isWifiApEnabled = WifiManagerHelper.getWifiManager().getDeclaredMethod("isWifiApEnabled", new Class[0]);
            return (Boolean)isWifiApEnabled.invoke((Object)wifiManager2, new Object[0]);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Exception when isWifiApEnabled:" + e.getMessage()));
            return false;
        }
    }

    public static void openWifiHotspot(WifiManager wifiManager2) {
        try {
            Method method = wifiManager2.getClass().getMethod("getWifiApConfiguration", new Class[0]);
            method.setAccessible(true);
            WifiConfiguration config = (WifiConfiguration)method.invoke((Object)wifiManager2, new Object[0]);
            Method method2 = wifiManager2.getClass().getMethod("setWifiApEnabled", WifiConfiguration.class, Boolean.TYPE);
            method2.invoke((Object)wifiManager2, config, true);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static int getNumAssociation(WifiConfiguration wifiConfig) {
        try {
            return Class.forName("android.net.wifi.WifiConfiguration").getDeclaredField("numAssociation").getInt(wifiConfig);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Exception when getNumAssociation:" + e.getMessage()));
            return -1;
        }
    }

    public static void setNumAssociation(WifiConfiguration wifiConfig, int value) {
        try {
            Class.forName("android.net.wifi.WifiConfiguration").getDeclaredField("numAssociation").setInt(wifiConfig, value);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Exception when setNumAssociation:" + e.getMessage()));
        }
    }

    public static WifiConfiguration getMatchingWifiConfig(ScanResult scanResult) {
        try {
            Method getMatchingWifiConfig = WifiManagerHelper.getWifiManager().getDeclaredMethod("getMatchingWifiConfig", new Class[0]);
            return (WifiConfiguration)getMatchingWifiConfig.invoke((Object)scanResult, new Object[0]);
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)("Exception when getWifiApConfiguration:" + e.getMessage()));
            e.printStackTrace();
            return null;
        }
    }

    public static void forgetNetwork(WifiManager wifiManager2, int networkId) {
        try {
            Method forget = wifiManager2.getClass().getDeclaredMethod("forget", Integer.TYPE, Class.forName("android.net.wifi.WifiManager$ActionListener"));
            forget.setAccessible(true);
            forget.invoke((Object)wifiManager2, networkId, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean is5GHzBandSupported(WifiManager wm) {
        boolean is5GHzBandSupported = false;
        try {
            is5GHzBandSupported = wm.is5GHzBandSupported();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return is5GHzBandSupported;
    }
}

