/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.business.utils;

import android.app.ActivityManager;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.graphics.drawable.Drawable;
import android.hardware.Sensor;
import android.hardware.SensorManager;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import android.util.Patterns;
import androidx.annotation.RequiresApi;
import com.xshare.base.BaseApplication;
import com.xshare.business.utils.LogUtils;
import com.xshare.business.utils.MD5Utils;
import com.xshare.business.utils.SPUtils;
import com.xshare.business.wifi.WifiDeviceBean;
import com.xshare.trans.R;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class XShareUtils {
    public static final String DIRECTORY_SEPARATOR = "/";
    public static final char MIN = '!';
    public static final char MAX = 'z';
    public static final int NET_SUCCESS = 1000;
    public static final int NET_FAIL = 2000;
    public static final String CHANNEL_2 = "2.4G";
    public static final String CHANNEL_5 = "5G";
    public static final String MESSAGE_SPLIT_PART1 = "?t=";
    public static final String MESSAGE_SPLIT_PART2 = "?b=";
    public static final String MESSAGE_SPLIT_PART3 = "?i=";
    public static final String MESSAGE_SPLIT_PART4 = "?x=";
    public static final String MESSAGE_SPLIT_PART5 = "?c=";
    public static final String SOURCE_KEY = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public static final String SECRET_KEY = "rlksw1ZYB023456789abcdefghijmnopqtuvxyzACDEFGHIJKLMNOPQRSTUVWX";
    public static final int RANDOM_STRING_LENGTH = 8;
    public static final int NAME_LENGTH_MAX = 15;
    public static final String KEY_FCM_TOKEN_STATE = "fcm_token_state";
    public static final int RETRY_COUNTS = 7;
    public static final long RETRY_TIME = 300L;
    public static final String ACTION_NOTIFYCATION = "action_notigycation";
    public static final String SHOW_RED_POINT_HISTROY = "show_red_point_histroy";
    public static final String SELECT_COUNT = "select_count";
    private static final String TAG = "XShareUtil";
    private static final Object LOCK = new Object();
    private static final String TRANSFER_WIFI_CHANNEL = "transfer_wifi_channel";
    public static final String SCAN_RESULT = "scan_result";
    public static final String SCAN_CHANNEL = "scan_channel";
    public static final String IS_FORM_RECEIVE_ACTIVITY = "is_form_receive_activity";
    public static final String IS_FROM_MAIN = "is_from_main";
    public static final String IS_FROM_CLONE = "clone";
    public static final String IS_TRANSFER_START = "is_transfer_start";
    private boolean isSupportSensorAccelerometer = false;
    private static final Pattern PLAIN_TEXT_TO_ESCAPE = Pattern.compile("[<>&]| {2,}|\r?\n");
    private static final String WIFI_PWD_PATTERN = "[^a-zA-Z0-9\\u4E00-\\u9FA5\\w]";
    public static final String XTHEME_ROOT_PATH = "/root_path";
    public static final String FROM_SPREAD = "from_spread";
    public static String defaultSmsApp = "";
    public static String HOME_CURRENT_PAGE = "CURRENT_PAGE";
    public static String KEY_FILE_PATH = "file_path";
    public static String KEY_NEED_RESULT = "need_result";
    public static final int HOME_FRAGMENT_NONE = -1;
    public static final int HOME_FRAGMENT_HISTORY = 0;
    public static final int HOME_FRAGMENT_FILE = 1;
    public static final int HOME_FRAGMENT_VIDEO = 2;
    public static final int HOME_FRAGMENT_APP = 3;
    public static final int HOME_FRAGMENT_PHOTO = 4;
    public static final int HOME_FRAGMENT_MUSIC = 5;
    public static final int WEB_DOWNLOAD_DIR_TYPE_PRIVATE = 0;
    public static final int WEB_DOWNLOAD_DIR_TYPE_COMMON = 1;
    private Context mContext = BaseApplication.baseApplication.getApplicationContext();
    private static long mLastMonkeyTime = -1L;
    private static final long mMinCheckMonkeyTime = 30000L;
    private static boolean isUseMonkey = false;
    public static int SILENCE_AD_DAY = 1;
    private static String mPackagePath;
    private static String mPhoneSdcard;
    private static String mSdcardPath;
    private static String transferSavePath;
    public static final boolean DEFAULT_GREET_PUSH_ENABLE = true;
    private static String appStartSource;
    public static final int NOTIFICATION_QUICK_ENTRANCE_ID = 65280;
    public static final int NOTIFICATION_UPDATER_START_ID = 1048560;
    public static final int NOTIFICATION_GREET_MORNING_ID = 1048563;
    public static final int NOTIFICATION_GREET_EVENING_ID = 1048564;
    public static final int NOTIFICATION_STATUS_SAVER_ID = 1048565;
    public static final String ACTION_GREET_MORNING_CLICK = "action_greet_morning_click";
    public static final String ACTION_GREET_MORNING_DELETE = "action_greet_morning_delete";
    public static final String ACTION_GREET_MORNING_GO = "action_greet_morning_go";
    public static final String ACTION_GREET_EVENING_CLICK = "action_greet_evening_click";
    public static final String ACTION_GREET_EVENING_DELETE = "action_greet_evening_delete";
    public static final String ACTION_GREET_EVENING_GO = "action_greet_evening_go";
    public static final String ACTION_GREET_WHEN = "greet_when";
    public static final String ACTION_STATUS_SAVER_DELETE = "action_status_saver_delete";
    public static final String MAIN_ACTIVITY = "MainActivity";
    public static final String NEW_HOME_ACTIVITY = "NewHomeActivity";
    public static final String SEND_ACTIVITY = "SendActivity";
    public static final String NEW_SEND_ACTIVITY = "NewSendActivity";
    public static final String HOME_ACTIVITY = "HomeActivity";
    public static final String QR_CODE_SCAN_ACTIVITY = "QRCodeScanActivity";
    public static final String RECEIVE_AND_SEND_ACTIVITY = "ReceiveAndSendActivity";
    public static final String NOTIFICATION_ACTION_HOME_SEND = "com.infinix.xshare.quick.entrance.home.send";
    public static final String NOTIFICATION_ACTION_RECEIVE = "com.infinix.xshare.quick.entrance.receive";
    public static final String NOTIFICATION_ACTION_FILES = "com.infinix.xshare.quick.entrance.files";
    public static final String NOTIFICATION_ACTION_DOWNLOAD = "com.infinix.xshare.quick.entrance.download";
    public static final String SEND_ACTION = "android.intent.action.SEND";
    public static final String SEND_MULTIPLE_ACTIVITY = "android.intent.action.SEND_MULTIPLE";
    public static final String FIRST_APP_LAUNCHER = "first_app_launcher";

    private XShareUtils() {
        this.initIsSupportSensorAccelerometer(this.mContext);
        mLastMonkeyTime = System.currentTimeMillis();
        this.initPath(this.mContext);
    }

    public static XShareUtils getInstance() {
        return SingleTonHolder.INSTANCE;
    }

    private void initPath(Context context) {
        mPackagePath = context.getFilesDir().getAbsolutePath();
        mPhoneSdcard = Environment.getExternalStorageDirectory().getAbsolutePath();
        mSdcardPath = "";
        try {
            File sdcardFile = context.getExternalFilesDir("");
            if (sdcardFile != null) {
                mSdcardPath = sdcardFile.getAbsolutePath();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean isYouMateExist(Context context, PackageManager pm) {
        File apkfile = new File(context.getFilesDir().getAbsolutePath(), "YouMate.apk");
        if (!apkfile.exists()) {
            return false;
        }
        PackageInfo pi = pm.getPackageArchiveInfo(apkfile.getAbsolutePath(), 1);
        return pi != null;
    }

    public static Drawable getApkIcon(PackageManager pm, String apkPath) {
        PackageInfo info = pm.getPackageArchiveInfo(apkPath, 1);
        if (info != null) {
            ApplicationInfo appInfo = info.applicationInfo;
            appInfo.sourceDir = apkPath;
            appInfo.publicSourceDir = apkPath;
            try {
                return appInfo.loadIcon(pm);
            }
            catch (OutOfMemoryError e) {
                Log.e((String)"ApkIconLoader", (String)e.toString());
            }
        }
        return null;
    }

    private void initIsSupportSensorAccelerometer(Context context) {
        SensorManager sensorManager = (SensorManager)context.getSystemService("sensor");
        List sensors = sensorManager.getSensorList(-1);
        for (Sensor item : sensors) {
            if (item == null || 1 != item.getType()) continue;
            this.isSupportSensorAccelerometer = true;
            return;
        }
        this.isSupportSensorAccelerometer = false;
    }

    public boolean isSupportSensorAccelerometer() {
        return this.isSupportSensorAccelerometer;
    }

    public static void setTransferWifiChannel(Context context, String channel) {
        SPUtils.setTransferWifiChannel(context, channel);
    }

    public static String getTransferWifiChannel(Context context) {
        return SPUtils.getTransferWifiChannel(context);
    }

    public static boolean isTransferBy5G(Context context) {
        String channel = XShareUtils.getTransferWifiChannel(context);
        return XShareUtils.isChannel5G(channel);
    }

    public static boolean isChannel5G(String channel) {
        return TextUtils.equals((CharSequence)channel, (CharSequence)CHANNEL_5);
    }

    public static boolean isXshareSsid(Context context, String ssid) {
        if (TextUtils.isEmpty((CharSequence)ssid)) {
            return false;
        }
        String targetSSID = ssid.replaceAll("\"", "");
        return context != null && (targetSSID.startsWith(context.getString(R.string.wifi_ap_prefix)) || targetSSID.startsWith(context.getString(R.string.wifi_direct_prefix)) || targetSSID.startsWith(context.getString(R.string.wifi_ap_prefix_old)) || targetSSID.startsWith(context.getString(R.string.wifi_local_ap_prefix)));
    }

    public static boolean isXshareCode(String text, Intent intent) {
        LogUtils.e(TAG, "Scan Result:" + text);
        int index1 = text.indexOf(MESSAGE_SPLIT_PART1);
        int index2 = text.indexOf(MESSAGE_SPLIT_PART2);
        int index3 = text.indexOf(MESSAGE_SPLIT_PART3);
        int index4 = text.indexOf(MESSAGE_SPLIT_PART4);
        int index5 = text.indexOf(MESSAGE_SPLIT_PART5);
        if (index1 > -1 && index2 > -1 && index3 > -1 && index3 - index2 == MESSAGE_SPLIT_PART2.length() + 8) {
            WifiDeviceBean wifiDeviceBean = new WifiDeviceBean();
            String ssid = index4 > -1 ? text.substring(index3 + MESSAGE_SPLIT_PART3.length(), index4) : text.substring(index3 + MESSAGE_SPLIT_PART3.length());
            String randomString = text.substring(index2 + MESSAGE_SPLIT_PART2.length(), index3);
            LogUtils.d(TAG, "scan ssid:" + ssid);
            LogUtils.d(TAG, "scan randomString:" + randomString);
            wifiDeviceBean.setWifiSSID(ssid);
            wifiDeviceBean.setClientId(randomString);
            if (index4 > -1) {
                String shareKey = text.substring(index4 + MESSAGE_SPLIT_PART4.length());
                wifiDeviceBean.setPassword(shareKey);
            } else {
                wifiDeviceBean.setPassword("");
            }
            if (index5 > -1) {
                String channel = text.substring(index5 + MESSAGE_SPLIT_PART5.length(), index1);
                intent.putExtra(SCAN_CHANNEL, channel);
                wifiDeviceBean.setChannel(channel);
            }
            intent.putExtra(SCAN_RESULT, (Parcelable)wifiDeviceBean);
            intent.putExtra(IS_TRANSFER_START, false);
            intent.putExtra(IS_FORM_RECEIVE_ACTIVITY, true);
            return true;
        }
        return false;
    }

    public static String encodeSsid(String ssid) {
        if (ssid.length() <= 8) {
            return "00000000";
        }
        StringBuffer source = new StringBuffer(SOURCE_KEY);
        StringBuffer secret = new StringBuffer(SECRET_KEY);
        StringBuffer result = new StringBuffer();
        String key = ssid.substring(ssid.length() - 8);
        for (int i = 0; i < key.length(); ++i) {
            int index = source.indexOf(key.substring(i, i + 1));
            if (index == -1) {
                result.append("0");
                continue;
            }
            result.append(secret.charAt(index));
        }
        return result.toString();
    }

    public static void sendEmailByFeedback(Context context, String gaid, String uriString) {
        try {
            Uri uri = Uri.parse((String)uriString);
            Intent intent = new Intent("android.intent.action.SENDTO", uri);
            intent.putExtra("android.intent.extra.TEXT", "--------------------------------------------\nPlease keep the following information\n--------------------------------------------\nApp: XShare\nApp Version: 0\nModel: " + Build.MODEL + "\nRegion: cn\nLanguage: " + context.getResources().getConfiguration().locale.getLanguage() + "\nOS Type: Android\nOS Version:" + Build.VERSION.SDK_INT + "\n\n");
            intent.addFlags(0x10008000);
            context.startActivity(intent);
        }
        catch (ActivityNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static void sendEmailByFeedback(Context context, String gaid) {
        XShareUtils.sendEmailByFeedback(context, gaid, "mailto:xshare.feeback@gmail.com");
    }

    public static boolean isSDCardEnable() {
        return Environment.getExternalStorageState().equals("mounted");
    }

    @RequiresApi(api=8)
    public static boolean isIllegal() {
        if (isUseMonkey) {
            return true;
        }
        if (System.currentTimeMillis() - mLastMonkeyTime > 30000L) {
            isUseMonkey = ActivityManager.isUserAMonkey();
            mLastMonkeyTime = System.currentTimeMillis();
        }
        return isUseMonkey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Uri createFileForSharedContent(CharSequence shareContent) {
        if (shareContent == null) {
            return null;
        }
        Uri fileUri = null;
        FileOutputStream outStream = null;
        try {
            String fileName = "xshare.html";
            BaseApplication.baseApplication.getApplicationContext().deleteFile(fileName);
            StringBuffer sb = new StringBuffer("<html><head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\"/></head><body>");
            String text = XShareUtils.escapeCharacterToDisplay(shareContent.toString());
            Pattern webUrlProtocol = Pattern.compile("(?i)(http|https)://");
            Pattern pattern = Pattern.compile("(" + Patterns.WEB_URL.pattern() + ")|(" + Patterns.EMAIL_ADDRESS.pattern() + ")|(" + Patterns.PHONE.pattern() + ")");
            Matcher m = pattern.matcher(text);
            while (m.find()) {
                String matchStr = m.group();
                String link = null;
                if (Patterns.WEB_URL.matcher(matchStr).matches()) {
                    Matcher proto = webUrlProtocol.matcher(matchStr);
                    link = proto.find() ? proto.group().toLowerCase(Locale.US) + matchStr.substring(proto.end()) : "http://" + matchStr;
                } else if (Patterns.EMAIL_ADDRESS.matcher(matchStr).matches()) {
                    link = "mailto:" + matchStr;
                } else if (Patterns.PHONE.matcher(matchStr).matches()) {
                    link = "tel:" + matchStr;
                }
                if (link == null) continue;
                String href = String.format("<a href=\"%s\">%s</a>", link, matchStr);
                m.appendReplacement(sb, href);
            }
            m.appendTail(sb);
            sb.append("</body></html>");
            byte[] byteBuff = sb.toString().getBytes();
            outStream = BaseApplication.baseApplication.getApplicationContext().getApplicationContext().openFileOutput(fileName, 0);
            if (outStream != null) {
                outStream.write(byteBuff, 0, byteBuff.length);
                fileUri = Uri.fromFile((File)new File(BaseApplication.baseApplication.getApplicationContext().getApplicationContext().getFilesDir(), fileName));
                if (fileUri != null) {
                    Log.d((String)TAG, (String)("Created one file for shared content: " + fileUri));
                }
            }
        }
        catch (FileNotFoundException e) {
            Log.e((String)TAG, (String)("FileNotFoundException: " + e));
            e.printStackTrace();
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)("IOException: " + e));
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Exception: " + e));
        }
        finally {
            try {
                if (outStream != null) {
                    outStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return fileUri;
    }

    private static String escapeCharacterToDisplay(String text) {
        Pattern pattern = PLAIN_TEXT_TO_ESCAPE;
        Matcher match = pattern.matcher(text);
        if (match.find()) {
            StringBuilder out = new StringBuilder();
            int end = 0;
            do {
                int start = match.start();
                out.append(text.substring(end, start));
                end = match.end();
                int c = text.codePointAt(start);
                if (c == 32) {
                    int n = end - start;
                    for (int i = 1; i < n; ++i) {
                        out.append("&nbsp;");
                    }
                    out.append(' ');
                    continue;
                }
                if (c == 13 || c == 10) {
                    out.append("<br>");
                    continue;
                }
                if (c == 60) {
                    out.append("&lt;");
                    continue;
                }
                if (c == 62) {
                    out.append("&gt;");
                    continue;
                }
                if (c != 38) continue;
                out.append("&amp;");
            } while (match.find());
            out.append(text.substring(end));
            text = out.toString();
        }
        return text;
    }

    public static String getResumePath(String gaid) {
        if (!TextUtils.isEmpty((CharSequence)gaid)) {
            return XShareUtils.getResumeDir() + MD5Utils.getMD5String(gaid) + ".pb";
        }
        return null;
    }

    public static String getResumeDir() {
        String resumeDir = Environment.getExternalStorageState() + "resume" + File.separator;
        File file = new File(resumeDir);
        if (!file.exists() && !file.isDirectory()) {
            file.mkdirs();
        }
        return resumeDir;
    }

    public static String getRootPath(String originPath) {
        if (TextUtils.isEmpty((CharSequence)originPath)) {
            return null;
        }
        if (!TextUtils.isEmpty((CharSequence)mPackagePath) && originPath.startsWith(mPackagePath)) {
            return mPackagePath;
        }
        if (!TextUtils.isEmpty((CharSequence)mPhoneSdcard) && originPath.startsWith(mPhoneSdcard)) {
            return mPhoneSdcard;
        }
        if (!TextUtils.isEmpty((CharSequence)mSdcardPath) && originPath.startsWith(mSdcardPath)) {
            return mSdcardPath;
        }
        return null;
    }

    public void setAppStartSource(String source) {
        appStartSource = source;
    }

    public String getAppStartSource() {
        return appStartSource;
    }

    public static boolean isSilencePeriod() {
        long initMillis = SPUtils.getLong((Context)BaseApplication.baseApplication, FIRST_APP_LAUNCHER, 0L);
        long days = Math.abs(System.currentTimeMillis() - initMillis) / 86400000L;
        if (initMillis == 0L) {
            SPUtils.putLong((Context)BaseApplication.baseApplication, FIRST_APP_LAUNCHER, System.currentTimeMillis());
            return true;
        }
        return days < (long)SILENCE_AD_DAY;
    }

    public static boolean hasSilenceInstallPerm(Context context) {
        return false;
    }

    static {
        mSdcardPath = "";
        appStartSource = "other";
    }

    private static class SingleTonHolder {
        private static final XShareUtils INSTANCE = new XShareUtils();

        private SingleTonHolder() {
        }
    }
}

