/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.business.utils;

import android.app.ActivityManager;
import android.content.Context;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Log;
import androidx.core.os.LocaleListCompat;
import com.xshare.base.BaseApplication;
import com.xshare.business.utils.LogUtils;
import com.xshare.business.utils.RandomUtils;
import com.xshare.business.utils.SPUtils;
import com.xshare.business.utils.SystemProperties_R;
import com.xshare.business.utils.UserUtils;
import com.xshare.trans.R;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class XsDeviceUtils {
    private static final String TAG = "DeviceUtils";
    private static String mGAId;
    private static String mDeviceName;
    public static final int NAME_LENGTH_MAX = 15;
    public static final int DEVICE_LENGTH_MAX = 25;
    public static final String APNAME_PART_SPLIT = "_";
    public static final String DIRECTNAME_PART_SPLIT = "-";

    public static String getGAId(Context context) {
        if (TextUtils.isEmpty((CharSequence)mGAId) && TextUtils.isEmpty((CharSequence)(mGAId = SPUtils.getString(context, "guid", "")))) {
            try {
                LogUtils.d("gaid", "advertisingId is mGAId = " + mGAId);
            }
            catch (Exception var2) {
                var2.printStackTrace();
            }
            if (TextUtils.isEmpty((CharSequence)mGAId)) {
                mGAId = UUID.randomUUID().toString();
            }
            SPUtils.putString(context, "guid", mGAId);
        }
        if (TextUtils.isEmpty((CharSequence)mGAId)) {
            mGAId = Build.BRAND + Build.MODEL + Build.VERSION.RELEASE;
            LogUtils.d("gaid", "Local GAID is mGAId = " + mGAId);
        }
        return mGAId;
    }

    public static String getLocalIpAddress(Context context) {
        try {
            if (((WifiManager)context.getApplicationContext().getSystemService("wifi")).getConnectionInfo().getIpAddress() != 0) {
                return XsDeviceUtils.intToIp(((WifiManager)context.getApplicationContext().getSystemService("wifi")).getConnectionInfo().getIpAddress());
            }
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface intf = en.nextElement();
                try {
                    if (intf == null || intf.getInetAddresses() == null) continue;
                    Enumeration<InetAddress> enumIpAddr = intf.getInetAddresses();
                    while (enumIpAddr.hasMoreElements()) {
                        InetAddress inetAddress = enumIpAddr.nextElement();
                        LogUtils.e("getLocalIpAddress", "IP:" + inetAddress.getHostAddress());
                        if (inetAddress.isLoopbackAddress() || !inetAddress.getHostAddress().startsWith("192.168")) continue;
                        return inetAddress.getHostAddress();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception ex) {
            Log.e((String)"SocketException", (String)ex.toString());
        }
        return null;
    }

    private static String intToIp(int i) {
        return (i & 0xFF) + "." + (i >> 8 & 0xFF) + "." + (i >> 16 & 0xFF) + "." + (i >> 24 & 0xFF);
    }

    public static boolean isTranssionPhone() {
        String mode = Build.MODEL.toLowerCase();
        return mode.startsWith("itel") || mode.startsWith("tecno") || mode.startsWith("infinix") || mode.startsWith("spice");
    }

    public static boolean isAtLeastQ() {
        boolean isAtLeastQ = Build.VERSION.SDK_INT > 28;
        return isAtLeastQ;
    }

    public static boolean isNeedRestoreWiFi() {
        return !XsDeviceUtils.isAtLeastQ();
    }

    public static boolean isUseXuiStyle() {
        try {
            Class<?> systemProperties = Class.forName("android.os.SystemProperties");
            Method get = systemProperties.getDeclaredMethod("get", String.class);
            return get.invoke(null, "ro.rlk.systemui2_0").equals("1") || get.invoke(null, "ro.xos.systemui3_0").equals("1");
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String getReportDeviceModel() {
        String model = Build.MODEL;
        String defaultName = model.length() > 25 ? model.substring(0, 25) : model;
        return defaultName;
    }

    public static String getDeviceName(Context context) {
        if (!TextUtils.isEmpty((CharSequence)mDeviceName)) {
            return mDeviceName;
        }
        String model = Build.MODEL;
        String defaultName = model.length() > 15 ? model.substring(0, 15) : model;
        mDeviceName = SPUtils.getEditNameKey(context);
        boolean isNeedCommit = false;
        if (Build.BRAND.equals("Infinix")) {
            boolean isDefault;
            if (mDeviceName.equals("")) {
                mDeviceName = Build.DEVICE;
                isNeedCommit = true;
            } else if (mDeviceName.equals(defaultName) && (isDefault = SPUtils.getIsDefaultName(context))) {
                mDeviceName = Build.DEVICE;
                isNeedCommit = true;
            }
        } else if (mDeviceName.equals("")) {
            mDeviceName = defaultName;
            isNeedCommit = true;
        }
        if (isNeedCommit) {
            SPUtils.setEditNameKey(context, mDeviceName);
            SPUtils.setIsDefaultName(context, false);
        }
        return mDeviceName;
    }

    public static String getDeviceNameFromSsid(String ssid, Context context) {
        String XShare = context.getResources().getString(R.string.wifi_ap_prefix_old);
        String WiFi = context.getResources().getString(R.string.wifi_ap_prefix);
        String Direct = context.getResources().getString(R.string.wifi_direct_prefix);
        if (ssid.startsWith(XShare)) {
            int first = ssid.indexOf(APNAME_PART_SPLIT);
            int last = ssid.lastIndexOf(APNAME_PART_SPLIT);
            return ssid.substring(first + 1, last);
        }
        if (ssid.startsWith(WiFi)) {
            String[] str = ssid.split(APNAME_PART_SPLIT);
            if (str != null && str.length > 3) {
                return str[1];
            }
            int first = ssid.indexOf(APNAME_PART_SPLIT);
            int last = ssid.lastIndexOf(APNAME_PART_SPLIT);
            return ssid.substring(first + 1, last);
        }
        if (ssid.startsWith(Direct)) {
            int first = ssid.indexOf(DIRECTNAME_PART_SPLIT, 7);
            return ssid.substring(first + 1);
        }
        return ssid;
    }

    public static String getDeviceAvatarAFromSsid(String ssid, Context context) {
        LogUtils.d(TAG, "getDeviceAvatarAFromSsid ssid:" + ssid);
        String result = null;
        try {
            String result_str;
            int index;
            String str1;
            String[] str;
            String Direct = context.getResources().getString(R.string.wifi_direct_prefix);
            String wifi = context.getResources().getString(R.string.wifi_ap_prefix);
            if (ssid.startsWith(Direct)) {
                String result_str2;
                int index2;
                String str12;
                String[] str2 = ssid.split(DIRECTNAME_PART_SPLIT);
                if (str2 != null && str2.length > 2 && !TextUtils.isEmpty((CharSequence)(str12 = str2[1])) && str12.startsWith("X") && (index2 = str12.lastIndexOf("X")) != -1 && !TextUtils.isEmpty((CharSequence)(result_str2 = str12.substring(index2 + 1, index2 + 2)))) {
                    result = result_str2;
                }
            } else if (ssid.startsWith(wifi) && (str = ssid.split(APNAME_PART_SPLIT)) != null && str.length > 3 && !TextUtils.isEmpty((CharSequence)(str1 = str[2])) && str1.startsWith("X") && (index = str1.lastIndexOf("X")) != -1 && !TextUtils.isEmpty((CharSequence)(result_str = str1.substring(index + 1, index + 2)))) {
                result = result_str;
            }
        }
        catch (Exception e) {
            LogUtils.e(TAG, "getDeviceAvatarAFromSsid exception:" + e.getMessage());
        }
        return result;
    }

    public static boolean isNumeric(String str) {
        Pattern pattern = Pattern.compile("[0-9]*");
        Matcher isNum = pattern.matcher(str);
        return isNum.matches();
    }

    public static String generateSsidName(Context context) {
        StringBuffer sb = new StringBuffer();
        sb.append(context.getString(R.string.wifi_ap_prefix));
        sb.append(APNAME_PART_SPLIT);
        String name = UserUtils.getUserName();
        int utf8Length = StandardCharsets.UTF_8.encode(name).limit();
        if (utf8Length > 15) {
            int offset = name.length() * 15 / utf8Length;
            name = name.substring(0, offset);
        }
        sb.append(name);
        sb.append(APNAME_PART_SPLIT);
        sb.append("X" + UserUtils.getUserIconIndex());
        sb.append(APNAME_PART_SPLIT);
        sb.append(RandomUtils.getRandomString(5));
        Log.d((String)TAG, (String)("ssid length:" + sb.length()));
        return sb.toString();
    }

    public static long getTotalMemory(Context context) {
        try {
            ActivityManager am = (ActivityManager)context.getSystemService("activity");
            ActivityManager.MemoryInfo mi = new ActivityManager.MemoryInfo();
            am.getMemoryInfo(mi);
            long totalMem = mi.totalMem;
            Log.i((String)TAG, (String)("Phone Total Memory Size:" + totalMem));
            if (totalMem > 0L) {
                totalMem = mi.totalMem / 1024L;
            }
            return totalMem;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public static long getAvailMem(Context context) {
        try {
            ActivityManager am = (ActivityManager)context.getSystemService("activity");
            ActivityManager.MemoryInfo mi = new ActivityManager.MemoryInfo();
            am.getMemoryInfo(mi);
            long availMem = mi.availMem;
            Log.i((String)TAG, (String)("Phone availMem Size:" + availMem));
            return availMem;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    private static String getOobeCountry() {
        return SystemProperties_R.get("persist.sys.oobe_country");
    }

    public static String getCountry() {
        return XsDeviceUtils.getCountry((Context)BaseApplication.baseApplication);
    }

    public static String getCountry(Context context) {
        String country = XsDeviceUtils.getOobeCountry();
        if (!TextUtils.isEmpty((CharSequence)country)) {
            country = country.toLowerCase(LocaleListCompat.getDefault().get(0));
        }
        if (TextUtils.equals((CharSequence)"others", (CharSequence)country) || TextUtils.equals((CharSequence)"unknown", (CharSequence)country)) {
            country = "";
        }
        if (TextUtils.isEmpty((CharSequence)country)) {
            try {
                TelephonyManager tm = (TelephonyManager)BaseApplication.baseApplication.getSystemService("phone");
                country = tm.getNetworkCountryIso();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (TextUtils.isEmpty((CharSequence)country)) {
            country = context.getResources().getConfiguration().locale.getCountry();
        }
        return country;
    }

    public static boolean isRussia() {
        try {
            return BaseApplication.baseApplication.getPackageManager().hasSystemFeature("com.google.android.feature.RU");
        }
        catch (Exception e) {
            e.printStackTrace();
            return true;
        }
    }
}

