/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.business.utils.aes;

import android.util.Base64;
import android.util.Log;
import java.io.UnsupportedEncodingException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class AESUtil {
    public static final String TAG = "AESUtil";
    private static final String CIPHER_MODE = "AES/CBC/PKCS7Padding";
    private static final String CHARSET_UTF = "UTF-8";
    private static final String KEY_SPEC_AES = "AES";

    private static SecretKeySpec createKey(String password) {
        byte[] data = null;
        if (password == null) {
            password = "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(password);
        while (sb.length() < 32) {
            sb.append(" ");
        }
        String s = sb.substring(0, 32);
        try {
            data = s.getBytes(CHARSET_UTF);
        }
        catch (UnsupportedEncodingException e) {
            Log.e((String)TAG, (String)"UnsupportedEncodingException");
        }
        return new SecretKeySpec(data, KEY_SPEC_AES);
    }

    private static IvParameterSpec createIV(String iv) {
        byte[] data = null;
        if (iv == null) {
            iv = "";
        }
        StringBuilder sb = new StringBuilder(16);
        sb.append(iv);
        String s = null;
        while (sb.length() < 16) {
            sb.append(" ");
        }
        s = sb.substring(0, 16);
        try {
            data = s.getBytes(CHARSET_UTF);
        }
        catch (UnsupportedEncodingException e) {
            Log.e((String)TAG, (String)"UnsupportedEncodingException");
        }
        return new IvParameterSpec(data);
    }

    public static byte[] encryptByte2Byte(byte[] content, String password, String iv) {
        try {
            SecretKeySpec key = AESUtil.createKey(password);
            Cipher cipher = Cipher.getInstance(CIPHER_MODE);
            cipher.init(1, (Key)key, AESUtil.createIV(iv));
            byte[] result = cipher.doFinal(content);
            return result;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Exception");
            return null;
        }
    }

    public static String encryptString2Base64(String content, String password, String iv) {
        byte[] data = null;
        try {
            data = content.getBytes(CHARSET_UTF);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"UnsupportedEncodingException");
        }
        data = AESUtil.encryptByte2Byte(data, password, iv);
        String result = new String(Base64.encode((byte[])data, (int)0));
        return result;
    }

    public static byte[] decryptByte2Byte(byte[] content, String password, String iv) {
        try {
            SecretKeySpec key = AESUtil.createKey(password);
            Cipher cipher = Cipher.getInstance(CIPHER_MODE);
            cipher.init(2, (Key)key, AESUtil.createIV(iv));
            byte[] result = cipher.doFinal(content);
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String decryptByte2String(byte[] content, String password, String iv) {
        byte[] data = AESUtil.decryptByte2Byte(content, password, iv);
        String result = new String(data);
        return result;
    }
}

