/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.business.wedgit.trans;

import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.AnimationUtils;
import android.view.animation.LinearInterpolator;
import com.xshare.trans.R;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ReceiveSearchingView
extends View {
    private static final String TAG = ReceiveSearchingView.class.getSimpleName();
    private Paint mPaint = new Paint();
    private List<Circle> mCircles = new ArrayList<Circle>();
    private int mX;
    private int mY;
    private double mMaxRadius;
    private static final TimeInterpolator sDefaultInterpolator = new AccelerateDecelerateInterpolator();
    private TimeInterpolator mInterpolator = sDefaultInterpolator;
    private long mDelay;
    private boolean mStarted;
    private Runnable mProduceCircleRunnable;
    private long mDuration;
    private int mColor;
    private Paint.Style mStyle = Paint.Style.FILL;

    public ReceiveSearchingView(Context context) {
        this(context, null);
    }

    public ReceiveSearchingView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ReceiveSearchingView(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public ReceiveSearchingView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        int resID;
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.ReceiveSearchingView);
        this.mDelay = (long)typedArray.getFloat(R.styleable.ReceiveSearchingView_wave_delay, 900.0f);
        this.mColor = typedArray.getColor(R.styleable.ReceiveSearchingView_wave_color, this.getResources().getColor(R.color.business_color_1a206cff));
        this.mDuration = (long)typedArray.getFloat(R.styleable.ReceiveSearchingView_wave_duration, 4000.0f);
        if (typedArray.hasValue(R.styleable.ReceiveSearchingView_wave_style)) {
            this.mStyle = Paint.Style.valueOf((String)typedArray.getString(R.styleable.ReceiveSearchingView_wave_style));
        }
        if ((resID = typedArray.getResourceId(R.styleable.ReceiveSearchingView_wave_interpolator, 17432580)) > 0) {
            this.setInterpolator((TimeInterpolator)AnimationUtils.loadInterpolator((Context)context, (int)resID));
        }
        typedArray.recycle();
    }

    public void setInterpolator(TimeInterpolator interpolator) {
        this.mInterpolator = interpolator != null ? interpolator : new LinearInterpolator();
    }

    public void setDelay(long delay) {
        this.mDelay = delay;
    }

    public void setDuration(long duration) {
        this.mDuration = duration;
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.mX = this.getWidth() / 2;
        this.mY = this.getHeight() / 2;
        this.mMaxRadius = Math.max(this.mX, this.mY);
        this.mPaint.setColor(this.mColor);
        this.mPaint.setStyle(this.mStyle);
    }

    public void start() {
        if (this.mStarted) {
            return;
        }
        this.mStarted = true;
        this.mProduceCircleRunnable = new Runnable(){

            @Override
            public void run() {
                ReceiveSearchingView.this.mCircles.add(new Circle());
                ReceiveSearchingView.this.invalidate();
                ReceiveSearchingView.this.postDelayed(this, ReceiveSearchingView.this.mDelay);
            }
        };
        this.post(this.mProduceCircleRunnable);
    }

    public void cancel() {
        this.mStarted = false;
        this.mCircles.clear();
        this.removeCallbacks(this.mProduceCircleRunnable);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        Iterator<Circle> iterator = this.mCircles.iterator();
        while (iterator.hasNext()) {
            Circle circle = iterator.next();
            circle.Compute();
            if (circle.isExpired()) {
                iterator.remove();
                continue;
            }
            this.mPaint.setAlpha(circle.getAlpha());
            canvas.drawCircle((float)this.mX, (float)this.mY, circle.getRadius(), this.mPaint);
        }
        if (!this.mCircles.isEmpty()) {
            this.invalidate();
        }
    }

    public void setWaveColor(int color2) {
        this.mColor = color2;
    }

    public boolean isRunning() {
        return this.mStarted;
    }

    public void setWaveStyle(Paint.Style style) {
        this.mStyle = style;
    }

    private class Circle {
        int maxAlpha = 40;
        float radius = 0.0f;
        int alpha = this.maxAlpha;
        long startTime = 0L;
        private boolean isExpired = false;

        private Circle() {
        }

        public float getRadius() {
            return this.radius;
        }

        public void setRadius(float radius) {
            this.radius = radius;
        }

        public int getAlpha() {
            return this.alpha;
        }

        public void setAlpha(int alpha) {
            this.alpha = alpha;
        }

        public void Compute() {
            float radio;
            long now = SystemClock.uptimeMillis();
            if (this.startTime == 0L) {
                this.startTime = now;
            }
            if (now - this.startTime >= ReceiveSearchingView.this.mDuration) {
                this.isExpired = true;
            }
            if ((radio = ReceiveSearchingView.this.mInterpolator.getInterpolation((float)(now - this.startTime) / (float)ReceiveSearchingView.this.mDuration)) > 1.0f) {
                radio = 1.0f;
            }
            if (radio < 0.0f) {
                radio = 0.0f;
            }
            if (radio == 0.0f || radio == 1.0f) {
                this.startTime = now;
            }
            this.radius = (float)(ReceiveSearchingView.this.mMaxRadius * (double)radio);
            this.alpha = (int)((float)this.maxAlpha * (1.0f - radio));
        }

        public boolean isExpired() {
            return this.isExpired;
        }

        public String toString() {
            return "Circle{radius=" + this.radius + ", alpha=" + this.alpha + ", startTime=" + this.startTime + ", isExpired=" + this.isExpired + '}';
        }
    }
}

