/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.business.wifi;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkRequest;
import android.net.wifi.ScanResult;
import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.xshare.business.utils.WiFiLog;
import com.xshare.business.wifi.ConfigUtil;
import com.xshare.business.wifi.WifiConnection;
import com.xshare.business.wifi.WifiUtils;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

class ApConnect {
    private final String TAG = ApConnect.class.getSimpleName();
    private Context mContext;
    private WifiManager mWifiManager;
    private ConnectivityManager mConnectManager;
    private ConnectivityManager.NetworkCallback mNetworkCallback;
    private Looper mLoop;
    private ApHandler mHandler;
    private String mSSID;
    private String mPass;
    private WifiConnection.Listener mListener;
    private WifiReceiver mReceiver;
    private ScanResult mScanResult;

    public ApConnect(Context context, Looper looper) {
        this.mContext = context;
        this.mLoop = looper;
        this.mWifiManager = (WifiManager)this.mContext.getSystemService("wifi");
        this.mConnectManager = (ConnectivityManager)this.mContext.getSystemService("connectivity");
    }

    void start(String ssid, String pass, WifiConnection.Listener listener) {
        this.mScanResult = null;
        this.mSSID = ssid;
        this.mPass = pass;
        this.mListener = listener;
        listener.onStart();
        WiFiLog.getInstance().d(this.TAG, "start to connect to " + this.mSSID);
        if (this.mHandler != null) {
            this.stop();
        }
        this.mHandler = new ApHandler(this.mLoop);
        if (this.isAlreadyConnected()) {
            this.mHandler.sendEmptyMessage(205);
        } else {
            this.mHandler.sendEmptyMessage(201);
        }
        this.mHandler.sendEmptyMessageDelayed(305, 90000L);
    }

    public void stop() {
        WiFiLog.getInstance().d(this.TAG, "ap connect stop");
        this.mScanResult = null;
        this.mListener = null;
        if (this.mHandler != null) {
            this.mHandler.removeCallbacksAndMessages(null);
            this.mHandler = null;
        }
        if (this.mReceiver != null) {
            this.mContext.unregisterReceiver((BroadcastReceiver)this.mReceiver);
            this.mReceiver = null;
        }
        if (this.mNetworkCallback != null) {
            this.mConnectManager.unregisterNetworkCallback(this.mNetworkCallback);
            this.mNetworkCallback = null;
        }
    }

    public void close() {
        if (this.mHandler != null) {
            this.stop();
        }
        if (this.mNetworkCallback != null) {
            this.mConnectManager.unregisterNetworkCallback(this.mNetworkCallback);
        }
        WiFiLog.getInstance().d(this.TAG, "ap connect close");
    }

    private void doScan() {
        ConfigUtil.removeNetwork(this.mWifiManager, this.mSSID);
        if (this.mReceiver == null) {
            this.mReceiver = new WifiReceiver();
            IntentFilter filter = new IntentFilter("android.net.wifi.SCAN_RESULTS");
            filter.addAction("android.net.wifi.STATE_CHANGE");
            this.mContext.registerReceiver((BroadcastReceiver)this.mReceiver, filter);
        }
        WiFiLog.getInstance();
        WiFiLog.getInstance().d(this.TAG, "start scan wifi");
        if (!this.mWifiManager.startScan() && !this.matchScan()) {
            this.mHandler.sendEmptyMessageDelayed(201, 1000L);
        }
    }

    private void doRequestNetwork() {
        WiFiLog.getInstance().d(this.TAG, "connected, request to bind network");
        NetworkRequest request = new NetworkRequest.Builder().addTransportType(1).build();
        if (this.mNetworkCallback == null) {
            this.mNetworkCallback = new ConnectivityManager.NetworkCallback(){

                public void onAvailable(Network network) {
                    WiFiLog.getInstance().d(ApConnect.this.TAG, "doRequestNetwork onAvailable");
                    super.onAvailable(network);
                    if (Build.VERSION.SDK_INT >= 23) {
                        ApConnect.this.mConnectManager.bindProcessToNetwork(network);
                    } else {
                        ConnectivityManager.setProcessDefaultNetwork((Network)network);
                    }
                    if (ApConnect.this.mHandler != null) {
                        ApConnect.this.mHandler.removeMessages(305);
                    }
                    ApConnect.this.mListener.onSuccess(null);
                }

                public void onUnavailable() {
                    super.onUnavailable();
                    WiFiLog.getInstance().d(ApConnect.this.TAG, "doRequestNetwork onUnavailable");
                    if (ApConnect.this.mHandler != null) {
                        ApConnect.this.mHandler.removeMessages(305);
                    }
                    ApConnect.this.mListener.onFail(-5);
                }

                public void onLost(Network network) {
                    super.onLost(network);
                    WiFiLog.getInstance().d(ApConnect.this.TAG, "doRequestNetwork onLost");
                    if (Build.VERSION.SDK_INT >= 23) {
                        ApConnect.this.mConnectManager.bindProcessToNetwork(null);
                    } else {
                        ConnectivityManager.setProcessDefaultNetwork(null);
                    }
                }
            };
        }
        this.mConnectManager.requestNetwork(request, this.mNetworkCallback);
    }

    private boolean doConnect() {
        WifiConfiguration config;
        if (this.mScanResult != null) {
            config = ConfigUtil.getWifiConfiguration(this.mWifiManager, this.mScanResult);
            if (!this.cleanPreviousConfiguration(config)) {
                // empty if block
            }
            config = new WifiConfiguration();
            config.SSID = WifiUtils.convertToQuotedString(this.mScanResult.SSID);
            config.BSSID = this.mScanResult.BSSID;
            ConfigUtil.setupSecurity(config, this.mScanResult.capabilities, this.mPass);
        } else {
            WiFiLog.getInstance().d(this.TAG, "don't scan target, connect hidden with psk");
            config = new WifiConfiguration();
            config.SSID = WifiUtils.convertToQuotedString(this.mSSID);
            ConfigUtil.setupSecurity(config, "PSK", this.mPass);
        }
        int newPri = this.getMaxPriority() + 1;
        if (newPri > 1000000) {
            newPri = this.shiftPriorityAndSave();
            if ((config = ConfigUtil.getWifiConfiguration(this.mWifiManager, config)) == null) {
                return false;
            }
        }
        config.priority = newPri;
        WiFiLog.getInstance().d(this.TAG, "addNetwork start");
        int networkId = this.mWifiManager.addNetwork(config);
        WiFiLog.getInstance().d(this.TAG, "addNetwork networkId:" + networkId);
        if (networkId == -1) {
            return false;
        }
        WiFiLog.getInstance().d(this.TAG, "enableNetwork start networkId:" + networkId);
        if (!this.mWifiManager.enableNetwork(networkId, false)) {
            WiFiLog.getInstance().d(this.TAG, "enableNetwork failed");
            return false;
        }
        WiFiLog.getInstance().d(this.TAG, "saveConfiguration start");
        if (!this.mWifiManager.saveConfiguration()) {
            WiFiLog.getInstance().d(this.TAG, "saveConfiguration failed");
            return false;
        }
        boolean connectSuccess = (config = ConfigUtil.getWifiConfiguration(this.mWifiManager, config)) != null && this.disableAllButOne(config) && this.mWifiManager.reconnect();
        WiFiLog.getInstance().d(this.TAG, "connect " + (connectSuccess ? "success" : "failed"));
        return connectSuccess;
    }

    private boolean matchScan() {
        if (this.mScanResult != null) {
            return true;
        }
        List list = this.mWifiManager.getScanResults();
        WiFiLog.getInstance().d(this.TAG, "scan result " + (list != null ? list.size() : 0));
        if (list != null && list.size() > 0) {
            for (ScanResult result : list) {
                if (!result.SSID.equals(this.mSSID)) continue;
                WiFiLog.getInstance().d(this.TAG, "found ssid wifi");
                this.mScanResult = result;
                if (this.mHandler != null) {
                    this.mHandler.sendEmptyMessage(203);
                }
                return true;
            }
        }
        return false;
    }

    private boolean isAlreadyConnected() {
        if (this.mWifiManager.getConnectionInfo() != null && this.mWifiManager.getConnectionInfo().getSSID() != null && this.mWifiManager.getConnectionInfo().getIpAddress() != 0 && WifiUtils.convertToQuotedString(this.mSSID).equals(this.mWifiManager.getConnectionInfo().getSSID())) {
            WiFiLog.getInstance().d(this.TAG, "Already connected to: " + this.mWifiManager.getConnectionInfo().getSSID() + "  BSSID: " + this.mWifiManager.getConnectionInfo().getBSSID());
            return true;
        }
        return false;
    }

    private boolean cleanPreviousConfiguration(WifiConfiguration config) {
        WiFiLog.getInstance().d(this.TAG, "Attempting to remove previous network config...");
        if (config == null) {
            return true;
        }
        if (this.mWifiManager.removeNetwork(config.networkId)) {
            this.mWifiManager.saveConfiguration();
            return true;
        }
        return false;
    }

    private int getMaxPriority() {
        List configurations = this.mWifiManager.getConfiguredNetworks();
        int pri = 0;
        for (WifiConfiguration config : configurations) {
            if (config.priority <= pri) continue;
            pri = config.priority;
        }
        return pri;
    }

    private int shiftPriorityAndSave() {
        List configurations = this.mWifiManager.getConfiguredNetworks();
        Collections.sort(configurations, new Comparator<WifiConfiguration>(){

            @Override
            public int compare(WifiConfiguration o1, WifiConfiguration o2) {
                return o1.priority - o2.priority;
            }
        });
        int size = configurations.size();
        int i = 0;
        while (i < size) {
            WifiConfiguration config = (WifiConfiguration)configurations.get(i);
            config.priority = i++;
            this.mWifiManager.updateNetwork(config);
        }
        this.mWifiManager.saveConfiguration();
        return size;
    }

    private boolean disableAllButOne(WifiConfiguration config) {
        List configurations = this.mWifiManager.getConfiguredNetworks();
        if (configurations == null || config == null || configurations.isEmpty()) {
            return false;
        }
        boolean result = false;
        for (WifiConfiguration wifiConfig : configurations) {
            if (wifiConfig == null) continue;
            if (wifiConfig.networkId == config.networkId) {
                result = this.mWifiManager.enableNetwork(wifiConfig.networkId, true);
                continue;
            }
            this.mWifiManager.disableNetwork(wifiConfig.networkId);
        }
        WiFiLog.getInstance().d(this.TAG, "disableAllButOne " + result);
        return result;
    }

    class WifiReceiver
    extends BroadcastReceiver {
        WifiReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if ("android.net.wifi.SCAN_RESULTS".equals(action)) {
                ApConnect.this.matchScan();
            } else if ("android.net.wifi.STATE_CHANGE".equals(action)) {
                WiFiLog.getInstance().d(ApConnect.this.TAG, "receive " + action);
                if (ApConnect.this.isAlreadyConnected() && ApConnect.this.mHandler != null) {
                    ApConnect.this.mHandler.sendEmptyMessageDelayed(205, 500L);
                }
            }
        }
    }

    class ApHandler
    extends Handler {
        private int mTry;
        private int mScanTry;

        public ApHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 203: {
                    WiFiLog.getInstance().d(ApConnect.this.TAG, "request connect mTry " + this.mTry);
                    if (this.mTry < 5) {
                        ++this.mTry;
                        ApConnect.this.doConnect();
                        this.removeMessages(305);
                        this.sendEmptyMessageDelayed(305, 90000L);
                        break;
                    }
                    this.removeMessages(305);
                    ApConnect.this.mListener.onFail(-5);
                    break;
                }
                case 201: {
                    if (this.mScanTry < 5) {
                        ++this.mScanTry;
                        ApConnect.this.doScan();
                        ApConnect.this.mHandler.removeMessages(201);
                        ApConnect.this.mHandler.sendEmptyMessageDelayed(201, 1000L);
                        break;
                    }
                    this.sendEmptyMessageDelayed(203, 500L);
                    break;
                }
                case 205: {
                    ApConnect.this.doRequestNetwork();
                    break;
                }
                case 305: {
                    ApConnect.this.mListener.onFail(-7);
                    break;
                }
                default: {
                    super.handleMessage(msg);
                }
            }
        }
    }
}

