/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.business.wifi;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkRequest;
import android.net.NetworkSpecifier;
import android.net.wifi.WifiNetworkSpecifier;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import com.xshare.business.utils.WiFiLog;
import com.xshare.business.wifi.WifiConnection;

public class ApConnectQ {
    private final String TAG = ApConnectQ.class.getSimpleName();
    private ConnectivityManager mConnManager;
    private ConnectivityManager.NetworkCallback mCallback;
    private WifiConnection.Listener mListener;
    private Handler mHandler;
    private Application mContext;
    private Application.ActivityLifecycleCallbacks mActivityCallback;

    public ApConnectQ(Context context) {
        this.mContext = (Application)context.getApplicationContext();
        this.mConnManager = (ConnectivityManager)context.getSystemService("connectivity");
    }

    public synchronized void connect(String ssid, String password, Looper looper, WifiConnection.Listener listener) {
        this.close();
        WiFiLog.getInstance().d(this.TAG, "start connect with WifiNetworkSpecifier");
        this.mListener = listener;
        this.mListener.onStart();
        if (this.mHandler == null) {
            this.mHandler = new Handler(looper);
        }
        WifiNetworkSpecifier.Builder builder = new WifiNetworkSpecifier.Builder().setSsid(ssid);
        if (!TextUtils.isEmpty((CharSequence)password)) {
            builder.setWpa2Passphrase(password);
        }
        WifiNetworkSpecifier wifiNetworkSpecifier = builder.build();
        NetworkRequest networkRequest = new NetworkRequest.Builder().addTransportType(1).removeCapability(12).setNetworkSpecifier((NetworkSpecifier)wifiNetworkSpecifier).build();
        if (this.mCallback == null) {
            this.mCallback = new ConnectivityManager.NetworkCallback(){

                public void onAvailable(Network network) {
                    super.onAvailable(network);
                    WiFiLog.getInstance().d(ApConnectQ.this.TAG, "WifiNetworkSpecifier connect success");
                    try {
                        if (ApConnectQ.this.mListener != null) {
                            if (ApConnectQ.this.mConnManager != null) {
                                ApConnectQ.this.mConnManager.bindProcessToNetwork(network);
                            }
                            ApConnectQ.this.mListener.onSuccess(null);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }

                public void onUnavailable() {
                    super.onUnavailable();
                    WiFiLog.getInstance().d(ApConnectQ.this.TAG, "WifiNetworkSpecifier connect unavailable");
                    if (ApConnectQ.this.mListener != null) {
                        ApConnectQ.this.mListener.onFail(-5);
                    }
                }

                public void onLost(Network network) {
                    super.onLost(network);
                    WiFiLog.getInstance().d(ApConnectQ.this.TAG, "WifiNetworkSpecifier connect lost");
                    if (ApConnectQ.this.mConnManager != null) {
                        ApConnectQ.this.mConnManager.bindProcessToNetwork(null);
                    }
                }
            };
        }
        this.mConnManager.requestNetwork(networkRequest, this.mCallback);
        this.watchActivity();
    }

    public synchronized void stop() {
        if (this.mActivityCallback != null) {
            this.mContext.unregisterActivityLifecycleCallbacks(this.mActivityCallback);
            this.mActivityCallback = null;
        }
        if (this.mHandler != null) {
            this.mHandler.removeCallbacksAndMessages(null);
            this.mHandler = null;
        }
        this.mListener = null;
    }

    public synchronized void close() {
        if (this.mActivityCallback != null) {
            this.stop();
        }
        if (this.mCallback != null) {
            this.mConnManager.unregisterNetworkCallback(this.mCallback);
            this.mCallback = null;
        }
        this.mConnManager.bindProcessToNetwork(null);
    }

    private void watchActivity() {
        if (this.mActivityCallback == null) {
            this.mActivityCallback = new Application.ActivityLifecycleCallbacks(){
                private boolean mPaused;

                public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
                }

                public void onActivityStarted(Activity activity) {
                }

                public void onActivityResumed(Activity activity) {
                    String clazzName = activity.getLocalClassName();
                    if (this.mPaused && ApConnectQ.this.mListener != null && ApConnectQ.this.isWatchActivity(clazzName)) {
                        ApConnectQ.this.mHandler.postDelayed(new Runnable(){

                            @Override
                            public void run() {
                                WiFiLog.getInstance().d(ApConnectQ.this.TAG, "watchActivity onActivityResumed");
                                if (ApConnectQ.this.mListener != null) {
                                    ApConnectQ.this.mListener.onFail(-5);
                                }
                            }
                        }, 500L);
                        this.mPaused = false;
                    }
                }

                public void onActivityPaused(Activity activity) {
                    String clazzName = activity.getLocalClassName();
                    if (ApConnectQ.this.isWatchActivity(clazzName)) {
                        this.mPaused = true;
                    }
                }

                public void onActivityStopped(Activity activity) {
                }

                public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
                }

                public void onActivityDestroyed(Activity activity) {
                }
            };
        }
        this.mContext.registerActivityLifecycleCallbacks(this.mActivityCallback);
    }

    private boolean isWatchActivity(String clazzName) {
        return clazzName.contains("TransferActivity") || clazzName.contains("CloneConnectActivity") || clazzName.contains("TransferConnectActivity");
    }
}

