/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.business.wifi;

import android.annotation.SuppressLint;
import android.net.wifi.ScanResult;
import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiManager;
import android.net.wifi.p2p.WifiP2pManager;
import android.text.TextUtils;
import com.xshare.business.utils.WiFiLog;
import com.xshare.business.wifi.WifiUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;

@SuppressLint(value={"MissingPermission"})
public final class ConfigUtil {
    private static final String TAG = ConfigUtil.class.getSimpleName();
    public static final String SECURITY_NONE = "OPEN";
    public static final String SECURITY_WEP = "WEP";
    public static final String SECURITY_PSK = "PSK";
    public static final String SECURITY_WPA = "WPA";
    public static final String SECURITY_EAP = "EAP";
    public static final String SECURITY_OTHER = "OTHER";
    private static final int P2P_CHANNEL_LC = 0;
    private static final int[] P2P_CHANNEL_OCS = new int[]{1, 6, 11};

    public static void setWifiP2pChannel(WifiP2pManager wifiP2pManager2, WifiP2pManager.Channel channel, boolean isUse5G) {
        if (wifiP2pManager2 == null || channel == null) {
            return;
        }
        int random = new Random().nextInt(10) % 3;
        int oc = isUse5G ? 0 : P2P_CHANNEL_OCS[random];
        WiFiLog.getInstance().d(TAG, "setWifiP2pChannels: lc=0, oc=" + oc + ", isUse5G=" + isUse5G);
        WifiP2pManager.ActionListener actionListener2 = new WifiP2pManager.ActionListener(){

            public void onSuccess() {
                WiFiLog.getInstance().d(TAG, "Successfully set wifi p2p channels.");
            }

            public void onFailure(int reason) {
                WiFiLog.getInstance().d(TAG, "Failed to set wifi p2p channels with reason " + reason + ".");
            }
        };
        try {
            if (wifiP2pManager2 != null && channel != null) {
                Method method = wifiP2pManager2.getClass().getMethod("setWifiP2pChannels", WifiP2pManager.Channel.class, Integer.TYPE, Integer.TYPE, WifiP2pManager.ActionListener.class);
                method.setAccessible(true);
                method.invoke((Object)wifiP2pManager2, channel, 0, oc, actionListener2);
            }
        }
        catch (Exception e1) {
            WiFiLog.getInstance().d(TAG, "setWifiP2pChannels e1 = " + e1);
        }
    }

    public static void removeNetwork(WifiManager wifiManager2, String ssid) {
        if (wifiManager2 == null) {
            return;
        }
        List configurations = wifiManager2.getConfiguredNetworks();
        if (configurations != null) {
            for (WifiConfiguration config : configurations) {
                if (!config.SSID.equals(ssid)) continue;
                wifiManager2.removeNetwork(config.networkId);
                wifiManager2.saveConfiguration();
                break;
            }
        }
    }

    public static void setupSecurity(WifiConfiguration config, String capability, String password) {
        config.allowedAuthAlgorithms.clear();
        config.allowedGroupCiphers.clear();
        config.allowedKeyManagement.clear();
        config.allowedPairwiseCiphers.clear();
        config.allowedProtocols.clear();
        String security = ConfigUtil.getSecurity(capability);
        WiFiLog.getInstance().d(TAG, "Setting up security " + security);
        switch (security) {
            case "OPEN": {
                config.allowedKeyManagement.set(0);
                break;
            }
            case "WEP": {
                config.hiddenSSID = true;
                config.wepTxKeyIndex = 0;
                config.allowedKeyManagement.set(0);
                config.allowedAuthAlgorithms.set(1);
                config.allowedPairwiseCiphers.set(2);
                config.allowedPairwiseCiphers.set(1);
                config.allowedGroupCiphers.set(0);
                config.allowedGroupCiphers.set(1);
                config.status = 2;
                if (ConfigUtil.isHexWepKey(password)) {
                    config.wepKeys[0] = password;
                    break;
                }
                config.wepKeys[0] = WifiUtils.convertToQuotedString(password);
                break;
            }
            case "PSK": {
                config.hiddenSSID = true;
                config.allowedAuthAlgorithms.set(0);
                config.allowedProtocols.set(1);
                config.allowedProtocols.set(0);
                config.allowedKeyManagement.set(1);
                config.allowedPairwiseCiphers.set(2);
                config.allowedPairwiseCiphers.set(1);
                config.allowedGroupCiphers.set(0);
                config.allowedGroupCiphers.set(1);
                config.allowedGroupCiphers.set(3);
                config.allowedGroupCiphers.set(2);
                config.preSharedKey = WifiUtils.convertToQuotedString(password);
                config.status = 2;
                break;
            }
            case "EAP": {
                config.allowedProtocols.set(1);
                config.allowedProtocols.set(0);
                config.allowedGroupCiphers.set(0);
                config.allowedGroupCiphers.set(1);
                config.allowedGroupCiphers.set(2);
                config.allowedGroupCiphers.set(3);
                config.allowedPairwiseCiphers.set(1);
                config.allowedPairwiseCiphers.set(2);
                config.allowedKeyManagement.set(2);
                config.allowedKeyManagement.set(3);
                config.preSharedKey = WifiUtils.convertToQuotedString(password);
                break;
            }
            default: {
                config.preSharedKey = String.format("\"%s\"", password);
                WiFiLog.getInstance().d(TAG, "Invalid security type: " + security);
            }
        }
        config.status = 2;
    }

    public static int updateNumAssociation(WifiManager wifiManager2, WifiConfiguration config) {
        ConfigUtil.setNumAssociation(wifiManager2, config);
        ConfigUtil.setNoInternetAccessReports(config);
        int netId = wifiManager2.updateNetwork(config);
        return netId;
    }

    static void setNumAssociation(WifiManager wifiManager2, WifiConfiguration wifiConfig) {
        try {
            List list = wifiManager2.getConfiguredNetworks();
            int maxNumAsssociation = 0;
            for (WifiConfiguration con : list) {
                int tmpNumAssociation = ConfigUtil.getNumAssociation(con);
                maxNumAsssociation = tmpNumAssociation > maxNumAsssociation ? tmpNumAssociation : maxNumAsssociation;
            }
            Field field = wifiConfig.getClass().getDeclaredField("numAssociation");
            field.setAccessible(true);
            field.setInt(wifiConfig, maxNumAsssociation);
            WiFiLog.getInstance().d(TAG, "update numAssociation to " + maxNumAsssociation);
        }
        catch (Exception e) {
            WiFiLog.getInstance().d(TAG, "setNumAssociation ", e);
        }
    }

    static int getNumAssociation(WifiConfiguration wifiConfig) {
        try {
            return wifiConfig.getClass().getDeclaredField("numAssociation").getInt(wifiConfig);
        }
        catch (Exception e) {
            WiFiLog.getInstance().d(TAG, "getNumAssociation", e);
            return 0;
        }
    }

    static void setNoInternetAccessReports(WifiConfiguration wifiConfig) {
        try {
            Field field = wifiConfig.getClass().getDeclaredField("numNoInternetAccessReports");
            field.setAccessible(true);
            field.setInt(wifiConfig, 1);
            WiFiLog.getInstance().d(TAG, "setNoInternetAccessReports to 1");
        }
        catch (Exception e) {
            WiFiLog.getInstance().d(TAG, "setNumAssociation ", e);
        }
    }

    static WifiConfiguration getWifiConfiguration(WifiManager wifiMgr, WifiConfiguration configToFind) {
        String ssid = configToFind.SSID;
        if (ssid == null || ssid.isEmpty()) {
            return null;
        }
        String bssid = configToFind.BSSID != null ? configToFind.BSSID : "";
        String security = ConfigUtil.getSecurity(configToFind);
        List configurations = wifiMgr.getConfiguredNetworks();
        if (configurations == null) {
            WiFiLog.getInstance().d(TAG, "NULL configs");
            return null;
        }
        for (WifiConfiguration config : configurations) {
            String configSecurity;
            if (!bssid.equals(config.BSSID) && !ssid.equals(config.SSID) || !Objects.equals(security, configSecurity = ConfigUtil.getSecurity(config))) continue;
            return config;
        }
        WiFiLog.getInstance().d(TAG, "Couldn't find " + ssid);
        return null;
    }

    static WifiConfiguration getWifiConfiguration(WifiManager wifiManager2, ScanResult scanResult) {
        if (scanResult.BSSID == null || scanResult.SSID == null || scanResult.SSID.isEmpty() || scanResult.BSSID.isEmpty()) {
            return null;
        }
        String ssid = WifiUtils.convertToQuotedString(scanResult.SSID);
        String bssid = scanResult.BSSID;
        String security = ConfigUtil.getSecurity(scanResult.capabilities);
        List configurations = wifiManager2.getConfiguredNetworks();
        if (configurations == null) {
            return null;
        }
        for (WifiConfiguration config : configurations) {
            String configSecurity;
            if (!bssid.equals(config.BSSID) && !ssid.equals(config.SSID) || !Objects.equals(security, configSecurity = ConfigUtil.getSecurity(config))) continue;
            return config;
        }
        return null;
    }

    static String getSecurity(WifiConfiguration config) {
        String security = SECURITY_NONE;
        ArrayList<String> securities = new ArrayList<String>();
        if (config.allowedKeyManagement.get(0)) {
            security = config.wepKeys[0] != null ? SECURITY_WEP : SECURITY_NONE;
            securities.add(security);
        }
        if (config.allowedKeyManagement.get(2) || config.allowedKeyManagement.get(3)) {
            security = SECURITY_EAP;
            securities.add(security);
        }
        if (config.allowedKeyManagement.get(1)) {
            security = SECURITY_PSK;
            securities.add(security);
        }
        WiFiLog.getInstance().d(TAG, "Got Security Via WifiConfiguration " + securities);
        return security;
    }

    public static String getSecurity(String capability) {
        String security = SECURITY_NONE;
        if (!TextUtils.isEmpty((CharSequence)capability)) {
            if (capability.contains(SECURITY_WEP)) {
                security = SECURITY_WEP;
            } else if (capability.contains(SECURITY_PSK) || capability.contains(SECURITY_WPA)) {
                security = SECURITY_PSK;
            } else if (capability.contains(SECURITY_EAP)) {
                security = SECURITY_EAP;
            } else if (capability.contains(SECURITY_OTHER)) {
                security = SECURITY_OTHER;
            }
        }
        WiFiLog.getInstance().d(TAG, "Got security via ScanResult " + security);
        return security;
    }

    static boolean isHexWepKey(String wepKey) {
        int passwordLen = wepKey == null ? 0 : wepKey.length();
        return (passwordLen == 10 || passwordLen == 26 || passwordLen == 58) && wepKey.matches("[0-9A-Fa-f]*");
    }
}

