/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.business.wifi;

import android.annotation.SuppressLint;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.NetworkInfo;
import android.net.wifi.p2p.WifiP2pConfig;
import android.net.wifi.p2p.WifiP2pDevice;
import android.net.wifi.p2p.WifiP2pDeviceList;
import android.net.wifi.p2p.WifiP2pGroup;
import android.net.wifi.p2p.WifiP2pInfo;
import android.net.wifi.p2p.WifiP2pManager;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.xshare.business.utils.WiFiLog;
import com.xshare.business.wifi.WifiConnection;
import java.net.InetAddress;

@SuppressLint(value={"MissingPermission"})
public class DirectConnect {
    private final String TAG = DirectConnect.class.getSimpleName();
    private Context mContext;
    private WifiP2pManager mWifiP2pManager;
    private volatile WifiP2pManager.Channel mChannel;
    private String mSSID;
    private String mPass;
    private WifiP2pDevice mDevice;
    private InetAddress mAddress;
    private IntentFilter mFilter;
    private P2pReceive mReceiver;
    private Handler mHandler;
    private Looper mLooper;
    private WifiConnection.Listener mListener;
    private boolean mConnecting;
    public static int retryCount = 5;

    public DirectConnect(Context context, Looper looper) {
        this.mContext = context.getApplicationContext();
        this.mLooper = looper;
        this.mWifiP2pManager = (WifiP2pManager)this.mContext.getSystemService("wifip2p");
    }

    public void stop() {
        WiFiLog.getInstance().d(this.TAG, "p2p connect stop");
        retryCount = 5;
        try {
            this.mListener = null;
            this.mContext.unregisterReceiver((BroadcastReceiver)this.mReceiver);
            this.mHandler.removeCallbacksAndMessages(null);
            this.mHandler = null;
        }
        catch (Exception e) {
            WiFiLog.getInstance().d(this.TAG, "p2p stop Exception = " + e.getMessage());
        }
    }

    public void close() {
        this.mDevice = null;
        this.mAddress = null;
        if (this.mHandler != null) {
            this.stop();
        }
        if (this.mChannel != null) {
            this.mWifiP2pManager.removeGroup(this.mChannel, null);
            this.mChannel = null;
        }
        WiFiLog.getInstance().d(this.TAG, "p2p connect close");
    }

    public void start(String ssid, String pass, WifiConnection.Listener listener) {
        this.init();
        this.mSSID = ssid;
        this.mPass = pass;
        this.mListener = listener;
        this.mConnecting = false;
        if (this.mHandler == null) {
            this.init();
        }
        this.mHandler.sendEmptyMessage(203);
        this.mHandler.sendEmptyMessageDelayed(305, 90000L);
        if (this.mListener != null) {
            this.mListener.onStart();
        } else {
            WiFiLog.getInstance().d(this.TAG, "start listener is null.");
        }
    }

    public String getIp() {
        return this.mAddress != null ? this.mAddress.getHostAddress() : null;
    }

    public String getMac() {
        return this.mDevice != null ? this.mDevice.deviceAddress : null;
    }

    private void init() {
        if (this.mHandler != null) {
            this.close();
        }
        this.mDevice = null;
        this.mAddress = null;
        this.mFilter = new IntentFilter();
        this.mFilter.addAction("android.net.wifi.p2p.STATE_CHANGED");
        this.mFilter.addAction("android.net.wifi.p2p.PEERS_CHANGED");
        this.mFilter.addAction("android.net.wifi.p2p.CONNECTION_STATE_CHANGE");
        this.mFilter.addAction("android.net.wifi.p2p.THIS_DEVICE_CHANGED");
        this.mReceiver = new P2pReceive();
        this.mContext.registerReceiver((BroadcastReceiver)this.mReceiver, this.mFilter);
        this.mChannel = this.mWifiP2pManager.initialize(this.mContext, Looper.getMainLooper(), null);
        this.mHandler = new P2pHandler(this.mLooper);
    }

    private void doConnect() {
        WiFiLog.getInstance().d(this.TAG, "doConnect");
        this.mWifiP2pManager.cancelConnect(this.mChannel, null);
        this.mConnecting = true;
        WifiP2pConfig config = this.getConfig();
        if (config == null) {
            if (this.mHandler != null) {
                this.mHandler.removeMessages(305);
            }
            if (this.mListener != null) {
                this.mListener.onFail(-11);
            } else {
                WiFiLog.getInstance().d(this.TAG, "doConnect listener is null.");
            }
            return;
        }
        this.mWifiP2pManager.connect(this.mChannel, config, new WifiP2pManager.ActionListener(){

            public void onSuccess() {
                WiFiLog.getInstance().d(DirectConnect.this.TAG, "call connect() success");
            }

            public void onFailure(int reason) {
                WiFiLog.getInstance().d(DirectConnect.this.TAG, "call connect() failure " + reason);
                DirectConnect.this.mConnecting = false;
                if (DirectConnect.this.mHandler != null) {
                    DirectConnect.this.mHandler.sendEmptyMessageDelayed(203, 1000L);
                }
            }
        });
    }

    private void doDiscover() {
        WiFiLog.getInstance().d(this.TAG, "doDiscover");
        this.mWifiP2pManager.discoverPeers(this.mChannel, new WifiP2pManager.ActionListener(){

            public void onSuccess() {
                WiFiLog.getInstance().d(DirectConnect.this.TAG, "call discover success");
                if (DirectConnect.this.mHandler != null) {
                    DirectConnect.this.mHandler.sendEmptyMessageDelayed(202, 1000L);
                }
            }

            public void onFailure(int reason) {
                WiFiLog.getInstance().d(DirectConnect.this.TAG, "call discover failure " + reason);
                if (DirectConnect.this.mHandler != null) {
                    DirectConnect.this.mHandler.sendEmptyMessageDelayed(201, 500L);
                }
            }
        });
    }

    private void doRequestDevice() {
        WiFiLog.getInstance().d(this.TAG, "doRequestDevice");
        this.mWifiP2pManager.requestPeers(this.mChannel, new WifiP2pManager.PeerListListener(){

            public void onPeersAvailable(WifiP2pDeviceList peers) {
                WiFiLog.getInstance().d(DirectConnect.this.TAG, "onPeersAvailable");
                DirectConnect.this.matchDevice(peers);
            }
        });
    }

    private void requestNetwork() {
        this.mWifiP2pManager.requestConnectionInfo(this.mChannel, new WifiP2pManager.ConnectionInfoListener(){

            public void onConnectionInfoAvailable(WifiP2pInfo info) {
                if (info != null) {
                    WiFiLog.getInstance().d(DirectConnect.this.TAG, "onConnectionInfoAvailable " + info);
                    if (info.groupFormed) {
                        DirectConnect.this.mAddress = info.groupOwnerAddress;
                        if (DirectConnect.this.mHandler != null) {
                            DirectConnect.this.mHandler.sendEmptyMessage(301);
                        }
                    } else if (DirectConnect.this.mHandler != null) {
                        DirectConnect.this.mHandler.sendEmptyMessageDelayed(205, 500L);
                    }
                } else {
                    if (DirectConnect.this.mHandler != null) {
                        DirectConnect.this.mHandler.removeMessages(305);
                    }
                    if (DirectConnect.this.mListener != null) {
                        DirectConnect.this.mListener.onFail(-5);
                    } else {
                        WiFiLog.getInstance().d(DirectConnect.this.TAG, "requestNetwork listener is null.");
                    }
                }
            }
        });
    }

    private boolean matchDevice(WifiP2pDeviceList peers) {
        if (this.mDevice != null || this.mConnecting) {
            return true;
        }
        if (peers != null) {
            for (WifiP2pDevice device : peers.getDeviceList()) {
                if (!device.isGroupOwner()) continue;
                WiFiLog.getInstance().d(this.TAG, "found p2p device " + device.deviceName);
                this.mDevice = device;
                if (this.mHandler != null) {
                    this.mHandler.sendEmptyMessage(203);
                }
                return true;
            }
        }
        return false;
    }

    private WifiP2pConfig getConfig() {
        WifiP2pConfig config = null;
        if (Build.VERSION.SDK_INT >= 29) {
            try {
                config = new WifiP2pConfig.Builder().setNetworkName(this.mSSID).setPassphrase(this.mPass).build();
            }
            catch (Exception e) {
                WiFiLog.getInstance().d(this.TAG, e.getMessage());
                e.printStackTrace();
            }
        } else if (this.mDevice != null) {
            config = new WifiP2pConfig();
            config.deviceAddress = this.mDevice.deviceAddress;
        }
        if (config != null) {
            config.wps.setup = 0;
        }
        return config;
    }

    class P2pReceive
    extends BroadcastReceiver {
        P2pReceive() {
        }

        public void onReceive(Context context, Intent intent) {
            WiFiLog.getInstance().d(DirectConnect.this.TAG, "P2pReceive onReceive " + intent.getAction());
            if ("android.net.wifi.p2p.PEERS_CHANGED".equals(intent.getAction())) {
                WifiP2pDeviceList peers = (WifiP2pDeviceList)intent.getParcelableExtra("wifiP2pDeviceList");
                DirectConnect.this.matchDevice(peers);
            } else if ("android.net.wifi.p2p.CONNECTION_STATE_CHANGE".equals(intent.getAction())) {
                NetworkInfo networkInfo = (NetworkInfo)intent.getParcelableExtra("networkInfo");
                WiFiLog.getInstance().d(DirectConnect.this.TAG, "P2pReceive connect " + networkInfo);
                if (networkInfo.isConnected()) {
                    WifiP2pInfo p2pInfo;
                    WifiP2pGroup group = (WifiP2pGroup)intent.getParcelableExtra("p2pGroupInfo");
                    if (group != null) {
                        DirectConnect.this.mDevice = group.getOwner();
                    }
                    if ((p2pInfo = (WifiP2pInfo)intent.getParcelableExtra("wifiP2pInfo")) != null && p2pInfo.groupFormed) {
                        DirectConnect.this.mAddress = p2pInfo.groupOwnerAddress;
                        if (DirectConnect.this.mHandler != null) {
                            WiFiLog.getInstance().d(DirectConnect.this.TAG, "P2pReceive msg_success mAddress = " + (DirectConnect.this.mAddress == null ? "null" : DirectConnect.this.mAddress.getHostAddress()));
                            DirectConnect.this.mHandler.sendEmptyMessage(301);
                        }
                    } else if (DirectConnect.this.mHandler != null) {
                        DirectConnect.this.mHandler.sendEmptyMessage(205);
                    }
                } else if (networkInfo.getState() == NetworkInfo.State.DISCONNECTED) {
                    WiFiLog.getInstance().d(DirectConnect.this.TAG, "P2pReceive NetworkInfo.State.DISCONNECTED = ");
                    DirectConnect.this.mConnecting = false;
                    if (DirectConnect.this.mHandler != null) {
                        WiFiLog.getInstance().d(DirectConnect.this.TAG, "P2pReceive NetworkInfo.State.DISCONNECTED = ");
                        DirectConnect.this.mHandler.sendEmptyMessageDelayed(203, 2000L);
                    }
                }
            }
        }
    }

    class P2pHandler
    extends Handler {
        private int discoverRetry;
        private int connectRetry;

        public P2pHandler(Looper looper) {
            super(looper);
            this.discoverRetry = 0;
            this.connectRetry = 0;
        }

        public void handleMessage(Message msg) {
            WiFiLog.getInstance().d(DirectConnect.this.TAG, "P2pHandler handleMessage msg.what = " + msg.what);
            switch (msg.what) {
                case 201: {
                    if (this.discoverRetry < retryCount) {
                        ++this.discoverRetry;
                        DirectConnect.this.doDiscover();
                        break;
                    }
                    this.sendEmptyMessage(203);
                    break;
                }
                case 202: {
                    DirectConnect.this.doRequestDevice();
                    break;
                }
                case 203: {
                    if (DirectConnect.this.mConnecting) break;
                    if (this.connectRetry < retryCount) {
                        ++this.connectRetry;
                        DirectConnect.this.doConnect();
                        break;
                    }
                    this.removeMessages(305);
                    if (DirectConnect.this.mListener != null) {
                        DirectConnect.this.mListener.onFail(-4);
                        break;
                    }
                    WiFiLog.getInstance().d(DirectConnect.this.TAG, "P2pHandler MSG_REQUEST_CONNECT listener is null.");
                    break;
                }
                case 205: {
                    DirectConnect.this.requestNetwork();
                    break;
                }
                case 301: {
                    this.removeMessages(305);
                    if (DirectConnect.this.mListener != null) {
                        DirectConnect.this.mListener.onSuccess(DirectConnect.this.mAddress);
                        break;
                    }
                    WiFiLog.getInstance().d(DirectConnect.this.TAG, "P2pHandler MSG_SUCCESS listener is null.");
                    break;
                }
                case 305: {
                    if (DirectConnect.this.mListener != null) {
                        DirectConnect.this.mListener.onFail(-7);
                        break;
                    }
                    WiFiLog.getInstance().d(DirectConnect.this.TAG, "P2pHandler MSG_TIMEOUT listener is null.");
                    break;
                }
                default: {
                    super.handleMessage(msg);
                }
            }
        }
    }
}

