/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.business.wifi;

import android.annotation.SuppressLint;
import android.content.Context;
import android.net.wifi.p2p.WifiP2pManager;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.xshare.business.utils.WiFiLog;
import com.xshare.business.wifi.HotSpotManagerQ;
import com.xshare.business.wifi.HotSpotUtil;
import java.lang.reflect.Method;

class DirectHotSpot {
    private Context mContext;
    private WifiP2pManager mWifiP2pManager;
    private WifiP2pManager.Channel mChannel;
    private HotSpotManagerQ.Listener mListener;
    private P2pHandler mHandler;

    public DirectHotSpot(Context context, Looper looper) {
        this.mContext = context;
        this.mWifiP2pManager = (WifiP2pManager)this.mContext.getSystemService("wifip2p");
        this.mHandler = new P2pHandler(looper);
        this.mChannel = this.mWifiP2pManager.initialize(this.mContext, this.mHandler.getLooper(), null);
    }

    public void create(HotSpotManagerQ.Listener listener) {
        this.mListener = listener;
        this.mHandler.sendEmptyMessage(101);
    }

    public void release() {
        this.mListener = null;
        if (Build.VERSION.SDK_INT > 26) {
            this.mChannel.close();
        }
        this.mHandler.removeCallbacksAndMessages(null);
    }

    private void doCreate(int retry) {
        WifiP2pManager.ActionListener listener = new WifiP2pManager.ActionListener(){

            public void onSuccess() {
                DirectHotSpot.this.mHandler.sendEmptyMessageDelayed(103, 100L);
            }

            public void onFailure(int reason) {
                DirectHotSpot.this.mWifiP2pManager.removeGroup(DirectHotSpot.this.mChannel, null);
                DirectHotSpot.this.mHandler.sendEmptyMessageDelayed(101, 500L);
            }
        };
        HotSpotUtil.createGroup(this.mContext, this.mChannel, retry, listener);
    }

    @SuppressLint(value={"MissingPermission"})
    private void doRequest() {
        try {
            this.mWifiP2pManager.requestGroupInfo(this.mChannel, group -> {
                if (group == null) {
                    this.mHandler.sendEmptyMessage(103);
                } else {
                    String mac = null;
                    if (group.getOwner() != null) {
                        mac = group.getOwner().deviceAddress;
                    }
                    this.mListener.onSuccess(mac, group.getNetworkName(), group.getPassphrase());
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setP2pChannel() {
        try {
            Method method = this.mWifiP2pManager.getClass().getMethod("setWifiP2pChannels", WifiP2pManager.Channel.class, Integer.TYPE, Integer.TYPE, WifiP2pManager.ActionListener.class);
            method.setAccessible(true);
            method.invoke((Object)this.mWifiP2pManager, this.mChannel, 11, 11);
        }
        catch (Exception e) {
            WiFiLog.getInstance().e("DirectHotSpot", "setP2pChannel", e);
        }
    }

    class P2pHandler
    extends Handler {
        private int mCreateRetry;
        private int mRequestRetry;

        public P2pHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 101: {
                    if (this.mCreateRetry < 5) {
                        DirectHotSpot.this.doCreate(this.mCreateRetry);
                        ++this.mCreateRetry;
                        break;
                    }
                    DirectHotSpot.this.mListener.onFail(-3);
                    break;
                }
                case 103: {
                    if (this.mRequestRetry < 5) {
                        DirectHotSpot.this.doRequest();
                        ++this.mRequestRetry;
                        break;
                    }
                    DirectHotSpot.this.mListener.onFail(-5);
                    break;
                }
                case 305: {
                    DirectHotSpot.this.mListener.onFail(-7);
                    break;
                }
                default: {
                    super.handleMessage(msg);
                }
            }
        }
    }
}

