/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.business.wifi;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Context;
import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiManager;
import android.net.wifi.p2p.WifiP2pGroup;
import android.net.wifi.p2p.WifiP2pManager;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.provider.Settings;
import android.util.Log;
import com.xshare.base.BaseApplication;
import com.xshare.business.utils.MD5Utils;
import com.xshare.business.utils.UserUtils;
import com.xshare.business.utils.WiFiLog;
import com.xshare.business.utils.WifiManagerHelper;
import com.xshare.business.utils.XShareUtils;
import com.xshare.business.utils.XsDeviceUtils;
import com.xshare.business.wifi.CreateHotSpotCallBack;
import com.xshare.business.wifi.HotSpotUtil;
import com.xshare.business.wifi.XSWiFiManager;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;

public class HotSpotManager {
    private final String TAG = HotSpotManager.class.getSimpleName();
    private WeakReference<CreateHotSpotCallBack> mXsWifiCallBack;
    private final WifiManager mWifiManager;
    private final WifiP2pManager mWifiP2pManager;
    private WifiP2pManager.Channel mChannel;
    private WifiP2pManager.ActionListener mActionListener;
    private static final String WIFI_P2P_DEVICE_NAME = "wifi_p2p_device_name";
    private HandlerThread mHandlerThread;
    private Handler mHandler;
    public static final int CHECK_WIFI_STATE = 14;
    public static final int CREATE_DIRECT_GROUP = 15;
    public static final int REQUEST_GROUP_INFO = 16;
    public static final int SHOW_OPEN_WIFI_MESSAGE = 17;
    public static final int SET_DEVICE_NAME = 18;
    public static final int GET_IP = 19;
    public static final int CREATE_AP_HOT_SPORT = 20;
    private int mGetGroupInfoCount = 0;
    private static final int RETRY_COUNTS = 10;
    private int mTryCounts = 0;
    private int mWaitCount = 0;
    private String strSSID;
    private String strPWD;
    private long mIP;
    private int currentConnectType = 0;
    private boolean releaseFlag = false;
    private boolean enforce5G = false;

    public HotSpotManager(WifiManager wifiManager2, WifiP2pManager wifiP2pManager2, WifiP2pManager.Channel channel) {
        this.mWifiManager = wifiManager2;
        this.mWifiP2pManager = wifiP2pManager2;
    }

    public void initHandlerThread() {
        if (this.mHandlerThread != null && this.mHandlerThread.isAlive()) {
            this.mHandlerThread.quitSafely();
            this.mHandlerThread.interrupt();
            this.mHandlerThread = null;
        }
        if (this.mHandler != null) {
            this.mHandler.removeCallbacksAndMessages(null);
            this.mHandler = null;
        }
        this.mHandlerThread = new HandlerThread("HotSpotManager", 0);
        this.mHandlerThread.start();
        this.mHandler = new Handler(this.mHandlerThread.getLooper()){

            public void dispatchMessage(Message msg) {
                switch (msg.what) {
                    case 15: {
                        HotSpotManager.this.createDirectGroup();
                        break;
                    }
                    case 16: {
                        HotSpotManager.this.requestGroupInfo();
                        break;
                    }
                    case 14: {
                        HotSpotManager.this.setWifiDirect();
                        break;
                    }
                    case 17: {
                        HotSpotManager.this.showOpenWifiAlert();
                        break;
                    }
                    case 18: {
                        HotSpotManager.this.setDeviceName(msg.arg1);
                        break;
                    }
                    case 19: {
                        HotSpotManager.this.findLocalRightIP();
                        break;
                    }
                    case 20: {
                        HotSpotManager.this.createApHotSport();
                    }
                }
            }
        };
        this.releaseFlag = false;
        this.resetChannel();
    }

    private void showOpenWifiAlert() {
        WiFiLog.getInstance().e(this.TAG, "SHOW_OPEN_WIFI_MESSAGE");
        if (this.mXsWifiCallBack != null && this.mXsWifiCallBack.get() != null) {
            ((CreateHotSpotCallBack)this.mXsWifiCallBack.get()).showOpenWifi();
        }
    }

    public synchronized void initDirect(CreateHotSpotCallBack callBack, boolean force5G) {
        this.mXsWifiCallBack = new WeakReference<CreateHotSpotCallBack>(callBack);
        this.enforce5G = force5G;
        this.mTryCounts = 0;
        this.mGetGroupInfoCount = 0;
        this.currentConnectType = 1044481;
        this.mHandler.sendEmptyMessage(14);
    }

    public int getCurrentHotSpotType() {
        return this.currentConnectType;
    }

    private void setWifiDirect() {
        try {
            WiFiLog.getInstance().d(this.TAG, "WifiState:" + this.mWifiManager.getWifiState());
            if (this.mHandler == null) {
                this.initHandlerThread();
                this.mHandler.sendEmptyMessage(14);
            } else if (!XSWiFiManager.getInstance().checkWifiEnable()) {
                this.mWifiManager.setWifiEnabled(true);
                ++this.mWaitCount;
                if (this.mWaitCount >= 10) {
                    this.mHandler.sendEmptyMessage(17);
                    this.mWaitCount = 0;
                } else {
                    this.mHandler.sendEmptyMessageDelayed(14, 1000L);
                }
            } else if (Build.VERSION.SDK_INT < 29) {
                String deviceName = Settings.Global.getString((ContentResolver)BaseApplication.baseApplication.getContentResolver(), (String)WIFI_P2P_DEVICE_NAME);
                if (deviceName == null || !deviceName.equals(UserUtils.getUserName())) {
                    WiFiLog.getInstance().d(this.TAG, "SET_DEVICE_NAME: ");
                    Message msg = this.mHandler.obtainMessage();
                    msg.what = 18;
                    msg.arg1 = 0;
                    msg.sendToTarget();
                } else {
                    WiFiLog.getInstance().d(this.TAG, "CREATE_DIRECT_GROUP: ");
                    this.mHandler.sendEmptyMessage(15);
                }
            } else {
                WiFiLog.getInstance().d(this.TAG, "CREATE_DIRECT_GROUP(>= Q): ");
                this.mHandler.sendEmptyMessage(15);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void resetChannel() {
        if (Build.VERSION.SDK_INT > 26 && this.mChannel != null) {
            this.mChannel.close();
        }
        this.mChannel = XSWiFiManager.getInstance().getP2pChannel();
    }

    private void createDirectGroup() {
        if (this.mActionListener == null) {
            this.mActionListener = new WifiP2pManager.ActionListener(){

                public void onSuccess() {
                    WiFiLog.getInstance().d(HotSpotManager.this.TAG, "createGroup onSuccess");
                    if (!HotSpotManager.this.releaseFlag) {
                        HotSpotManager.this.mGetGroupInfoCount = 0;
                        if (HotSpotManager.this.mHandler != null) {
                            HotSpotManager.this.mHandler.sendEmptyMessageDelayed(16, 500L);
                        }
                    }
                }

                public void onFailure(int reason) {
                    WiFiLog.getInstance().d(HotSpotManager.this.TAG, "createGroup failed reason:" + reason + ", releaseFlag:" + HotSpotManager.this.releaseFlag);
                    if (!HotSpotManager.this.releaseFlag) {
                        HotSpotManager.this.mTryCounts++;
                        XSWiFiManager.getInstance().releaseWifiP2P();
                        HotSpotManager.this.mChannel = null;
                        HotSpotManager.this.mWifiManager.setWifiEnabled(false);
                        if (HotSpotManager.this.mHandler != null) {
                            HotSpotManager.this.mHandler.sendEmptyMessageDelayed(14, 800L);
                        }
                    }
                }
            };
        }
        if (this.mTryCounts < 10) {
            try {
                if (this.mChannel == null) {
                    this.resetChannel();
                }
                HotSpotUtil.createGroup((Context)BaseApplication.baseApplication, this.mChannel, this.mTryCounts, this.mActionListener, this.enforce5G);
            }
            catch (Exception e) {
                XSWiFiManager.getInstance().releaseWifiP2P();
                this.mChannel = null;
                this.resetChannel();
                this.mHandler.sendEmptyMessageDelayed(15, 800L);
            }
        } else {
            this.releaseFlag = true;
            if (this.mChannel != null) {
                XSWiFiManager.getInstance().releaseWifiP2P();
                this.mChannel = null;
                this.mActionListener = null;
            }
            if (!this.enforce5G) {
                WiFiLog.getInstance().d(this.TAG, "createGroup createDirectGroup Failed mTryCounts\uff1a" + this.mTryCounts);
                this.tryOtherHotSpotModule();
            } else {
                XSWiFiManager.getInstance().updateWifiStatus(1044483);
                if (this.mXsWifiCallBack != null && this.mXsWifiCallBack.get() != null && this.currentConnectType == 1044481) {
                    ((CreateHotSpotCallBack)this.mXsWifiCallBack.get()).onFailed("WiFiP2PManager CreateGroup Over 5 Times ");
                }
            }
        }
    }

    @SuppressLint(value={"MissingPermission"})
    public void requestGroupInfo() {
        if (!this.releaseFlag) {
            if (this.mChannel == null) {
                WiFiLog.getInstance().d(this.TAG, "requestGroupInfo mChannel is null");
                this.tryOtherHotSpotModule();
            } else {
                try {
                    XSWiFiManager.getInstance().getWifiP2p().requestGroupInfo(this.mChannel, wifiP2pGroup -> {
                        try {
                            if (null == wifiP2pGroup) {
                                ++this.mGetGroupInfoCount;
                                if (this.mGetGroupInfoCount < 5) {
                                    if (this.mHandler != null) {
                                        this.mHandler.sendEmptyMessageDelayed(16, 500L);
                                    }
                                } else {
                                    WiFiLog.getInstance().d(this.TAG, "requestGroupInfo mGetGroupInfoCount:" + this.mGetGroupInfoCount);
                                    this.tryOtherHotSpotModule();
                                }
                            } else {
                                this.sendCallBack(wifiP2pGroup);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void tryOtherHotSpotModule() {
        this.mTryCounts = 0;
        WiFiLog.getInstance().d(this.TAG, "tryOtherHotSpotModule");
        if (Build.VERSION.SDK_INT >= 26) {
            this.initLocalHotspot(null);
        } else {
            this.initWifiApStatus(null);
        }
    }

    private void sendCallBack(WifiP2pGroup wifiP2pGroup) {
        this.strSSID = wifiP2pGroup.getNetworkName();
        this.strPWD = wifiP2pGroup.getPassphrase();
        this.currentConnectType = 1044481;
        this.findLocalRightIP();
        WiFiLog.getInstance().e(this.TAG, "Local IP:" + wifiP2pGroup.getOwner().deviceAddress);
    }

    private void sendResult() {
        if (this.mXsWifiCallBack != null && this.mXsWifiCallBack.get() != null) {
            XSWiFiManager.getInstance().updateWifiDevice(this.strSSID, this.strPWD, this.mIP);
            ((CreateHotSpotCallBack)this.mXsWifiCallBack.get()).onSucceed(this.strSSID, this.strPWD, this.currentConnectType);
        }
    }

    private void findLocalRightIP() {
        this.mIP = XSWiFiManager.getInstance().getLocalIP();
        this.sendResult();
    }

    @SuppressLint(value={"MissingPermission"})
    public synchronized void initLocalHotspot(CreateHotSpotCallBack callBack) {
        WiFiLog.getInstance().d(this.TAG, "initLocalHotspot");
        try {
            if (this.mXsWifiCallBack != null && callBack != null) {
                this.mXsWifiCallBack.clear();
            }
            if (callBack != null) {
                this.mXsWifiCallBack = new WeakReference<CreateHotSpotCallBack>(callBack);
            }
            if (Build.VERSION.SDK_INT >= 26) {
                this.mWifiManager.startLocalOnlyHotspot(new WifiManager.LocalOnlyHotspotCallback(){

                    public void onStarted(WifiManager.LocalOnlyHotspotReservation reservation) {
                        super.onStarted(reservation);
                        WiFiLog.getInstance().d(HotSpotManager.this.TAG, "startLocalOnlyHotspot onStarted");
                        if (reservation.getWifiConfiguration() != null) {
                            HotSpotManager.this.strSSID = reservation.getWifiConfiguration().SSID;
                            HotSpotManager.this.strPWD = reservation.getWifiConfiguration().preSharedKey;
                            HotSpotManager.this.currentConnectType = 1044482;
                            HotSpotManager.this.findLocalRightIP();
                        }
                        WiFiLog.getInstance().d(HotSpotManager.this.TAG, "initLocalHotspot onStarted");
                    }

                    public void onStopped() {
                        super.onStopped();
                    }

                    public void onFailed(int reason) {
                        super.onFailed(reason);
                        XSWiFiManager.getInstance().updateWifiStatus(1044483);
                        if (HotSpotManager.this.mXsWifiCallBack != null && HotSpotManager.this.mXsWifiCallBack.get() != null) {
                            ((CreateHotSpotCallBack)HotSpotManager.this.mXsWifiCallBack.get()).onFailed("startLocalOnlyHotspot Failed\uff0cFailed reason:" + reason);
                        }
                        WiFiLog.getInstance().d(HotSpotManager.this.TAG, "initLocalHotspot onFailed reason = " + reason);
                    }
                }, this.mHandler);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized void initWifiApStatus(CreateHotSpotCallBack callBack) {
        if (this.mXsWifiCallBack != null && callBack != null) {
            this.mXsWifiCallBack.clear();
        }
        if (callBack != null) {
            this.mXsWifiCallBack = new WeakReference<CreateHotSpotCallBack>(callBack);
        }
        this.mHandler.sendEmptyMessage(20);
    }

    private void createApHotSport() {
        block15: {
            try {
                WifiConfiguration mUsersConfiguration = WifiManagerHelper.getWifiApConfiguration(this.mWifiManager);
                WifiConfiguration mConfiguration = new WifiConfiguration();
                mConfiguration.SSID = XsDeviceUtils.generateSsidName((Context)BaseApplication.baseApplication);
                String pwd = XShareUtils.encodeSsid(mConfiguration.SSID);
                try {
                    pwd = MD5Utils.getMD5String(mConfiguration.SSID).substring(0, 8);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                mConfiguration.preSharedKey = pwd;
                WiFiLog.getInstance().e(this.TAG, "WIFI PWD:" + pwd);
                if (Build.VERSION.SDK_INT >= 24) {
                    mConfiguration.allowedKeyManagement.set(4);
                } else {
                    mConfiguration.allowedKeyManagement.set(0);
                }
                this.setApConfig(mUsersConfiguration, mConfiguration);
                WifiConfiguration newApConfig = null;
                for (int startApRetry = 0; startApRetry < 10; ++startApRetry) {
                    try {
                        newApConfig = WifiManagerHelper.getWifiApConfiguration(this.mWifiManager);
                        if (newApConfig != null) {
                            WiFiLog.getInstance().e(this.TAG, "newApConfig SSID:" + newApConfig.SSID + ", mConfiguration SSID:" + mConfiguration.SSID);
                        } else {
                            WiFiLog.getInstance().e(this.TAG, "newApConfig SSID:NULL, mConfiguration SSID:" + mConfiguration.SSID);
                        }
                        if (newApConfig != null && mConfiguration.SSID.equals(newApConfig.SSID)) break;
                        this.setApConfig(mUsersConfiguration, mConfiguration);
                        Thread.sleep(350L);
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (newApConfig != null) {
                    WiFiLog.getInstance().e(this.TAG, "Lasted newApConfig SSID:" + newApConfig.SSID + ", mConfiguration SSID:" + mConfiguration.SSID);
                } else {
                    WiFiLog.getInstance().e(this.TAG, "Lasted newApConfig SSID:NULL, mConfiguration SSID:" + mConfiguration.SSID);
                }
                if (newApConfig != null) {
                    this.strSSID = mConfiguration.SSID.equals(newApConfig.SSID) ? newApConfig.SSID : mConfiguration.SSID;
                    this.strPWD = Build.VERSION.SDK_INT >= 24 ? newApConfig.preSharedKey : null;
                } else {
                    this.strSSID = mConfiguration.SSID;
                    this.strPWD = Build.VERSION.SDK_INT >= 24 ? mConfiguration.preSharedKey : null;
                }
                this.currentConnectType = 1044483;
                this.findLocalRightIP();
            }
            catch (Exception e) {
                e.printStackTrace();
                XSWiFiManager.getInstance().updateWifiStatus(1044483);
                if (this.mXsWifiCallBack.get() == null) break block15;
                ((CreateHotSpotCallBack)this.mXsWifiCallBack.get()).onFailed("Exception:" + e.getMessage());
            }
        }
        this.mXsWifiCallBack.clear();
    }

    private void setApConfig(WifiConfiguration mUsersConfiguration, WifiConfiguration mConfiguration) {
        if (mUsersConfiguration != null && this.mWifiManager != null && WifiManagerHelper.isWifiApEnabled(this.mWifiManager)) {
            if (Build.VERSION.SDK_INT >= 24) {
                WifiManagerHelper.setWifiApEnabled(this.mWifiManager, mUsersConfiguration, false);
                WifiManagerHelper.setWifiApEnabled(this.mWifiManager, mConfiguration, true);
            } else {
                WifiManagerHelper.setWifiApEnabled(this.mWifiManager, mUsersConfiguration, false);
                WifiManagerHelper.setWifiApEnabled(this.mWifiManager, mConfiguration, true);
            }
        } else if (Build.VERSION.SDK_INT == 25) {
            Log.d((String)this.TAG, (String)"initWifiApStatus: 25");
            if (this.mWifiManager != null) {
                WifiManagerHelper.setWifiApConfiguration(this.mWifiManager, mConfiguration);
            }
        } else {
            if (Build.VERSION.SDK_INT == 22 && this.mWifiManager != null) {
                this.mWifiManager.setWifiEnabled(false);
            }
            if (this.mWifiManager != null) {
                WifiManagerHelper.setWifiApEnabled(this.mWifiManager, mConfiguration, true);
            }
        }
    }

    public void setDeviceName(final int count) {
        WifiP2pManager.ActionListener actionListener2 = new WifiP2pManager.ActionListener(){

            public void onSuccess() {
                String deviceName = Settings.Global.getString((ContentResolver)BaseApplication.baseApplication.getContentResolver(), (String)HotSpotManager.WIFI_P2P_DEVICE_NAME);
                WiFiLog.getInstance().d(HotSpotManager.this.TAG, "setDeviceName onSuccess, Devices Name:" + deviceName);
                HotSpotManager.this.mHandler.sendEmptyMessage(15);
            }

            public void onFailure(int reason) {
                WiFiLog.getInstance().d(HotSpotManager.this.TAG, "setDeviceName onFailure" + reason + ",count " + count);
                if (count > 10) {
                    HotSpotManager.this.mHandler.sendEmptyMessage(15);
                } else {
                    Message msg = HotSpotManager.this.mHandler.obtainMessage();
                    msg.arg1 = count + 1;
                    msg.what = 18;
                    msg.sendToTarget();
                }
            }
        };
        if (this.mWifiP2pManager != null) {
            try {
                Class<?> wifiP2pManagerClass = this.mWifiP2pManager.getClass();
                Method setDeviceName2 = wifiP2pManagerClass.getDeclaredMethod("setDeviceName", WifiP2pManager.Channel.class, String.class, WifiP2pManager.ActionListener.class);
                setDeviceName2.invoke((Object)this.mWifiP2pManager, this.mChannel, UserUtils.getUserName(), actionListener2);
            }
            catch (Exception e) {
                WiFiLog.getInstance().d(this.TAG, "setDeviceName Exception:" + e.getMessage());
                this.mHandler.sendEmptyMessage(15);
            }
        }
    }

    private void setWifiP2pChannels(WifiP2pManager.Channel channel, int lc, int oc) {
        WiFiLog.getInstance().d(this.TAG, "setWifiP2pChannels: lc=" + lc + ", oc=" + oc);
        WifiP2pManager.ActionListener actionListener2 = new WifiP2pManager.ActionListener(){

            public void onSuccess() {
                WiFiLog.getInstance().d(HotSpotManager.this.TAG, "Successfully set wifi p2p channels.");
            }

            public void onFailure(int reason) {
                WiFiLog.getInstance().e(HotSpotManager.this.TAG, "Failed to set wifi p2p channels with reason " + reason + ".");
            }
        };
        try {
            if (this.mWifiP2pManager != null && channel != null) {
                Method method = this.mWifiP2pManager.getClass().getMethod("setWifiP2pChannels", WifiP2pManager.Channel.class, Integer.TYPE, Integer.TYPE, WifiP2pManager.ActionListener.class);
                method.setAccessible(true);
                method.invoke((Object)this.mWifiP2pManager, channel, lc, oc, actionListener2);
            }
        }
        catch (Exception e1) {
            WiFiLog.getInstance().d(this.TAG, "setWifiP2pChannels e1 = " + e1);
            e1.printStackTrace();
        }
    }

    public void release() {
        try {
            this.releaseFlag = true;
            WiFiLog.getInstance().e(this.TAG, "release");
            if (this.mXsWifiCallBack != null) {
                this.mXsWifiCallBack.clear();
            }
            if (this.mActionListener != null && this.mChannel != null) {
                WiFiLog.getInstance().e(this.TAG, " mWifiP2pManager.clearLocalServices(mChannel, mActionListener)");
                this.mWifiP2pManager.removeGroup(this.mChannel, null);
                this.mWifiP2pManager.clearLocalServices(this.mChannel, null);
                if (Build.VERSION.SDK_INT > 26) {
                    this.mChannel.close();
                }
                this.mChannel = null;
                this.mActionListener = null;
            }
            if (this.mHandler != null) {
                this.mHandler.removeCallbacksAndMessages(null);
            }
            if (this.mHandlerThread != null) {
                this.mHandlerThread.quitSafely();
                this.mHandlerThread.interrupt();
                this.mHandlerThread = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

