/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.business.wifi;

import android.content.Context;
import android.net.wifi.WifiManager;
import android.os.HandlerThread;
import com.xshare.business.wifi.ApHotSpot;
import com.xshare.business.wifi.DirectHotSpot;

public class HotSpotManagerQ {
    private static HotSpotManagerQ INSTANCE;
    private Context mContext;
    private WifiManager mWifiManager;
    private DirectHotSpot mP2pHotSpot;
    private ApHotSpot mApHotSpot;
    private HandlerThread mThread;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HotSpotManagerQ getInstance(Context context) {
        if (INSTANCE != null) return INSTANCE;
        Class<HotSpotManagerQ> clazz = HotSpotManagerQ.class;
        synchronized (HotSpotManagerQ.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new HotSpotManagerQ(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return INSTANCE;
        }
    }

    private HotSpotManagerQ(Context context) {
        this.mContext = context.getApplicationContext();
        this.mWifiManager = (WifiManager)this.mContext.getSystemService("wifi");
        this.mThread = new HandlerThread("hot-spot", 0);
        this.mThread.start();
    }

    public void create(Listener listener) {
        if (this.mWifiManager.isP2pSupported()) {
            if (this.mP2pHotSpot != null) {
                this.mP2pHotSpot.release();
            }
            this.mP2pHotSpot = new DirectHotSpot(this.mContext, this.mThread.getLooper());
            this.mP2pHotSpot.create(listener);
        } else {
            if (this.mApHotSpot != null) {
                this.mApHotSpot.release();
            }
            this.mApHotSpot = new ApHotSpot(this.mContext, this.mThread.getLooper());
            this.mApHotSpot.create(listener);
        }
    }

    public void release() {
        if (this.mP2pHotSpot != null) {
            this.mP2pHotSpot.release();
            this.mP2pHotSpot = null;
        }
        if (this.mThread != null) {
            this.mThread.quitSafely();
            this.mThread = null;
        }
    }

    public static interface Listener {
        public void onFail(int var1);

        public void onSuccess(String var1, String var2, String var3);
    }
}

