/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.business.wifi;

import android.annotation.SuppressLint;
import android.content.Context;
import android.net.wifi.p2p.WifiP2pConfig;
import android.net.wifi.p2p.WifiP2pManager;
import android.os.Build;
import com.xshare.business.utils.MD5Utils;
import com.xshare.business.utils.WiFiLog;
import com.xshare.business.utils.WifiManagerHelper;
import com.xshare.business.wifi.ConfigUtil;
import com.xshare.business.wifi.WifiUtils;
import com.xshare.business.wifi.XSWiFiManager;

public class HotSpotUtil {
    private static final String TAG = HotSpotUtil.class.getSimpleName();
    private static final int[] FREQUENCY = new int[]{2462, 2437, 2412};
    private static final String DEFAULT_PWD = "12345678";

    @SuppressLint(value={"NewApi"})
    public static void createGroup(Context context, WifiP2pManager.Channel channel, int retry, WifiP2pManager.ActionListener listener) {
        HotSpotUtil.createGroup(context, channel, retry, listener, false);
    }

    @SuppressLint(value={"MissingPermission"})
    public static void createGroup(Context context, WifiP2pManager.Channel channel, int retry, WifiP2pManager.ActionListener listener, boolean isUse5G) {
        WifiP2pManager wifiP2pManager2 = (WifiP2pManager)context.getSystemService("wifip2p");
        WiFiLog.getInstance().d(TAG, "createGroup retry:" + retry + ", isUse5G:" + isUse5G);
        if (Build.VERSION.SDK_INT < 29) {
            if (Build.VERSION.SDK_INT >= 21) {
                boolean is5GHzSupport = WifiManagerHelper.is5GHzBandSupported(XSWiFiManager.getInstance().getWifiManager());
                WiFiLog.getInstance().d(TAG, "is5GHzSupport = " + is5GHzSupport);
                if (is5GHzSupport && channel != null) {
                    ConfigUtil.setWifiP2pChannel(wifiP2pManager2, channel, isUse5G);
                }
            }
            wifiP2pManager2.createGroup(channel, listener);
        } else {
            String pwd;
            String wifiSSID = "";
            WiFiLog.getInstance().e(TAG, "DIRECT WIFI SSID:" + wifiSSID);
            try {
                pwd = MD5Utils.getMD5String(wifiSSID).substring(0, 8);
            }
            catch (Exception e) {
                pwd = "XSHARE";
                e.printStackTrace();
            }
            WiFiLog.getInstance().e(TAG, "DIRECT WIFI PWD:" + pwd);
            WifiP2pConfig.Builder builder = new WifiP2pConfig.Builder().setNetworkName(wifiSSID).setPassphrase(pwd);
            if (isUse5G) {
                builder.setGroupOperatingBand(2);
            } else {
                builder.setGroupOperatingBand(1);
            }
            XSWiFiManager.getInstance().setCurrentWifiModule(isUse5G);
            WifiP2pConfig config = builder.build();
            wifiP2pManager2.createGroup(channel, config, listener);
        }
    }

    private static String getWifiSSID(Context context, boolean isUse5G) {
        try {
            String userName = "xshare";
            String userIconID = "a";
            byte[] nameBytes = userName.getBytes();
            if (isUse5G) {
                if (nameBytes.length > 18) {
                    userName = new String(nameBytes, 0, 17);
                }
                return "DIRECT-5G-X" + userIconID + "-" + userName;
            }
            if (nameBytes.length > 21) {
                userName = new String(nameBytes, 0, 20);
            }
            return "DIRECT-" + WifiUtils.getRandom(2) + "-" + userName;
        }
        catch (Exception e) {
            e.printStackTrace();
            String userName = "xshare";
            byte[] nameBytes = userName.getBytes();
            if (isUse5G) {
                if (nameBytes.length > 18) {
                    userName = new String(nameBytes, 0, 17);
                }
                return "DIRECT-5G-" + WifiUtils.getRandom(2) + "-" + userName;
            }
            if (nameBytes.length > 21) {
                userName = new String(nameBytes, 0, 20);
            }
            return "DIRECT-" + WifiUtils.getRandom(2) + "-" + userName;
        }
    }
}

