/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.business.wifi;

import android.net.wifi.ScanResult;
import android.net.wifi.WifiManager;
import android.text.TextUtils;
import android.util.Log;
import com.xshare.base.BaseApplication;
import com.xshare.business.bean.wifi.WifiInfoModel;
import com.xshare.business.wifi.VerifyCodeBean;
import com.xshare.business.wifi.VerifyCodeManager;
import java.util.Random;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.DelicateCoroutinesApi;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u001f\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0010\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001VB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010<\u001a\u00020\bJ\u0010\u0010=\u001a\u00020\u00172\u0006\u0010>\u001a\u00020?H\u0002J\u0010\u0010@\u001a\u00020\u00152\u0006\u0010A\u001a\u00020\u0017H\u0002J\b\u0010B\u001a\u00020CH\u0002J\u0006\u0010D\u001a\u00020CJ\u000e\u0010E\u001a\u00020C2\u0006\u0010F\u001a\u00020GJ\u000e\u0010H\u001a\u00020\u00172\u0006\u0010I\u001a\u00020\u0004J\u0010\u0010J\u001a\u00020\u00172\b\u0010K\u001a\u0004\u0018\u00010\u0004J\u000e\u0010L\u001a\u00020\u00172\u0006\u0010M\u001a\u00020\u0004J\b\u0010N\u001a\u00020CH\u0003J\u0006\u0010O\u001a\u00020CJ\u0006\u0010P\u001a\u00020CJ\u0006\u0010Q\u001a\u00020CJ\u0006\u0010R\u001a\u00020CJ\u0006\u0010S\u001a\u00020CJ\u0010\u0010T\u001a\u00020C2\u0006\u0010U\u001a\u00020\u0013H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\n\"\u0004\b\u000f\u0010\fR\u000e\u0010\u0010\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\u00020\u0017X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001aR\u001a\u0010\u001c\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\n\"\u0004\b#\u0010\fR\u001a\u0010$\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\n\"\u0004\b&\u0010\fR\u001a\u0010'\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\n\"\u0004\b)\u0010\fR\u001a\u0010*\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010\u001a\"\u0004\b,\u0010-R\u001a\u0010.\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010\u001a\"\u0004\b0\u0010-R\u000e\u00101\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u00102\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u0010\n\"\u0004\b4\u0010\fR\u000e\u00105\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u00106\u001a\u0002078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b:\u0010;\u001a\u0004\b8\u00109\u00a8\u0006W"}, d2={"Lcom/xshare/business/wifi/VerifyCodeManager;", "", "()V", "NUM_LETTER", "", "NUM_X_LETTER", "TAG", "codeCreateTime", "", "getCodeCreateTime", "()J", "setCodeCreateTime", "(J)V", "codeInputTime", "getCodeInputTime", "setCodeInputTime", "defaultSSID", "delayTime", "fourCodeWifiListener", "Lcom/xshare/business/wifi/VerifyCodeManager$OnScanFourCodeWifiListener;", "getResultCount", "", "isFind", "", "isInit5G", "isNotSupportFourCodeLink", "()Z", "isSupport5G", "linkType", "getLinkType", "()Ljava/lang/String;", "setLinkType", "(Ljava/lang/String;)V", "receiveConnectTime", "getReceiveConnectTime", "setReceiveConnectTime", "receiveLinkSuccessTime", "getReceiveLinkSuccessTime", "setReceiveLinkSuccessTime", "receiveOtherTypeTime", "getReceiveOtherTypeTime", "setReceiveOtherTypeTime", "sIsSupport5G", "getSIsSupport5G", "setSIsSupport5G", "(Z)V", "sRemoteNotSupportFourCodeLink", "getSRemoteNotSupportFourCodeLink", "setSRemoteNotSupportFourCodeLink", "scanCount", "sendLinkSuccessTime", "getSendLinkSuccessTime", "setSendLinkSuccessTime", "stopScan", "wifiManager", "Landroid/net/wifi/WifiManager;", "getWifiManager", "()Landroid/net/wifi/WifiManager;", "wifiManager$delegate", "Lkotlin/Lazy;", "checkLinkTime", "checkVerifyBean", "bean", "Lcom/xshare/business/wifi/VerifyCodeBean;", "createWifiTypeNum", "enable5G", "findXShareWifi", "", "init", "initSenderLinkCode", "wifiInfoModel", "Lcom/xshare/business/bean/wifi/WifiInfoModel;", "is5GCode", "code", "is5GSsid", "ssid", "is5GWifiSSid", "wifiSsid", "openWifiScan", "recodeQrOrOneTapLinkTime", "recordReceiveLinkTime", "recordSendLinkTime", "release", "resetStatus", "startScanWifiResult", "listener", "OnScanFourCodeWifiListener", "app_release"})
public final class VerifyCodeManager {
    @NotNull
    public static final VerifyCodeManager INSTANCE = new VerifyCodeManager();
    @NotNull
    private static final String TAG = "VerifyCodeManager";
    @NotNull
    private static final String NUM_LETTER = "1234567890";
    @NotNull
    private static final String NUM_X_LETTER = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static boolean isInit5G;
    private static boolean sIsSupport5G;
    private static boolean sRemoteNotSupportFourCodeLink;
    private static boolean stopScan;
    @NotNull
    private static final Lazy wifiManager$delegate;
    @Nullable
    private static OnScanFourCodeWifiListener fourCodeWifiListener;
    private static final long delayTime;
    private static final boolean isNotSupportFourCodeLink;
    @NotNull
    private static final String defaultSSID;
    private static boolean isFind;
    private static int getResultCount;
    private static int scanCount;
    private static long codeInputTime;
    private static long sendLinkSuccessTime;
    private static long codeCreateTime;
    private static long receiveLinkSuccessTime;
    private static long receiveConnectTime;
    private static long receiveOtherTypeTime;
    @NotNull
    private static String linkType;

    private VerifyCodeManager() {
    }

    public final boolean getSIsSupport5G() {
        return sIsSupport5G;
    }

    public final void setSIsSupport5G(boolean bl) {
        sIsSupport5G = bl;
    }

    public final boolean getSRemoteNotSupportFourCodeLink() {
        return sRemoteNotSupportFourCodeLink;
    }

    public final void setSRemoteNotSupportFourCodeLink(boolean bl) {
        sRemoteNotSupportFourCodeLink = bl;
    }

    private final WifiManager getWifiManager() {
        Lazy lazy = wifiManager$delegate;
        return (WifiManager)lazy.getValue();
    }

    public final void init() {
        scanCount = 0;
        getResultCount = 0;
        isFind = false;
        stopScan = false;
    }

    public final void release() {
        stopScan = true;
        isFind = true;
    }

    public final boolean isNotSupportFourCodeLink() {
        return isNotSupportFourCodeLink;
    }

    public final synchronized boolean isSupport5G() {
        if (isInit5G) {
            return sIsSupport5G;
        }
        sIsSupport5G = this.getWifiManager().is5GHzBandSupported();
        isInit5G = true;
        return sIsSupport5G;
    }

    public final void initSenderLinkCode(@NotNull WifiInfoModel wifiInfoModel) {
        Intrinsics.checkNotNullParameter((Object)wifiInfoModel, (String)"wifiInfoModel");
        wifiInfoModel.setWifiChannelCode(this.createWifiTypeNum(this.isSupport5G()));
        wifiInfoModel.setUserIconIndex(BaseApplication.Companion.getTransConfig().getUserAvatarIndex());
        wifiInfoModel.setRandomInfo(new Random().nextInt(100));
        Log.d((String)"XSLOG:", (String)Intrinsics.stringPlus((String)"initSenderLinkCode wifiInfoModel = ", (Object)wifiInfoModel));
    }

    private final int createWifiTypeNum(boolean enable5G) {
        int random = new Random().nextInt(5);
        return enable5G ? random + 5 : random;
    }

    public final boolean is5GCode(@NotNull String code) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        if (TextUtils.isEmpty((CharSequence)code)) {
            return false;
        }
        if (code.length() > 4) {
            return false;
        }
        try {
            int codeNum = Integer.parseInt(code);
            return codeNum >= 5000;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public final boolean is5GSsid(@Nullable String ssid) {
        if (ssid != null) {
            return StringsKt.contains$default((CharSequence)ssid, (CharSequence)"-XSHARE-5G", (boolean)false, (int)2, null);
        }
        return false;
    }

    public final boolean is5GWifiSSid(@NotNull String wifiSsid) {
        Intrinsics.checkNotNullParameter((Object)wifiSsid, (String)"wifiSsid");
        return TextUtils.isEmpty((CharSequence)wifiSsid) ? false : StringsKt.contains$default((CharSequence)wifiSsid, (CharSequence)"-5G-", (boolean)false, (int)2, null);
    }

    @DelicateCoroutinesApi
    public final void startScanWifiResult(@NotNull OnScanFourCodeWifiListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.openWifiScan();
        fourCodeWifiListener = listener;
    }

    @DelicateCoroutinesApi
    private final void openWifiScan() {
    }

    public final void resetStatus() {
        scanCount = 0;
        getResultCount = 0;
        isFind = false;
        stopScan = false;
    }

    private final boolean checkVerifyBean(VerifyCodeBean bean) {
        return bean.getWifiType() >= 0;
    }

    private final void findXShareWifi() {
    }

    public final long getCodeInputTime() {
        return codeInputTime;
    }

    public final void setCodeInputTime(long l) {
        codeInputTime = l;
    }

    public final long getSendLinkSuccessTime() {
        return sendLinkSuccessTime;
    }

    public final void setSendLinkSuccessTime(long l) {
        sendLinkSuccessTime = l;
    }

    public final long checkLinkTime() {
        long costTime = System.currentTimeMillis() - codeInputTime;
        if (costTime >= 8000L) {
            costTime -= (long)5000;
        }
        return costTime;
    }

    public final void recordSendLinkTime() {
        Log.d((String)TAG, (String)("send link cost time = " + (sendLinkSuccessTime - codeInputTime) + " ---- codeInputTime = " + codeInputTime + "  ----  sendLinkSuccessTime = " + sendLinkSuccessTime));
    }

    public final long getCodeCreateTime() {
        return codeCreateTime;
    }

    public final void setCodeCreateTime(long l) {
        codeCreateTime = l;
    }

    public final long getReceiveLinkSuccessTime() {
        return receiveLinkSuccessTime;
    }

    public final void setReceiveLinkSuccessTime(long l) {
        receiveLinkSuccessTime = l;
    }

    public final void recordReceiveLinkTime() {
        Log.d((String)TAG, (String)("receive link cost time = " + (receiveLinkSuccessTime - codeCreateTime) + " ---- codeCreateTime = " + codeCreateTime + "  ----  receiveLinkSuccessTime = " + receiveLinkSuccessTime));
    }

    public final long getReceiveConnectTime() {
        return receiveConnectTime;
    }

    public final void setReceiveConnectTime(long l) {
        receiveConnectTime = l;
    }

    public final long getReceiveOtherTypeTime() {
        return receiveOtherTypeTime;
    }

    public final void setReceiveOtherTypeTime(long l) {
        receiveOtherTypeTime = l;
    }

    @NotNull
    public final String getLinkType() {
        return linkType;
    }

    public final void setLinkType(@NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
        linkType = string2;
    }

    public final void recodeQrOrOneTapLinkTime() {
        Log.d((String)TAG, (String)(linkType + " receive link cost time = " + (receiveOtherTypeTime - receiveConnectTime) + " ---- receiveOtherTypeTime = " + receiveOtherTypeTime + "  ----  receiveConnectTime = " + receiveConnectTime));
    }

    static {
        wifiManager$delegate = LazyKt.lazy((Function0)wifiManager.2.INSTANCE);
        delayTime = INSTANCE.isSupport5G() ? 4000L : 10000L;
        defaultSSID = "DIRECT-Xa-XSHARE-5G-1234";
        linkType = "unkown";
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0012\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/xshare/business/wifi/VerifyCodeManager$OnScanFourCodeWifiListener;", "", "onSuccess", "", "result", "Landroid/net/wifi/ScanResult;", "app_release"})
    public static interface OnScanFourCodeWifiListener {
        public void onSuccess(@Nullable ScanResult var1);
    }
}

