/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.business.wifi;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.HandlerThread;
import android.text.TextUtils;
import com.xshare.base.BaseApplication;
import com.xshare.business.utils.WiFiLog;
import com.xshare.business.wifi.ApConnect;
import com.xshare.business.wifi.ApConnectQ;
import com.xshare.business.wifi.DirectConnect;
import com.xshare.business.wifi.WifiUtils;
import java.net.InetAddress;

public class WifiConnection {
    private final String TAG = WifiConnection.class.getSimpleName();
    private boolean ENABLE_CONNECT2 = false;
    public static final int CONNECTION_NULL = 0;
    public static final int CONNECTION_DIRECT = 1;
    public static final int CONNECTION_AP = 2;
    public static final int CONNECTION_AP_Q = 3;
    private static WifiConnection mInstance;
    private Context mContext;
    private WrapListener mWrapListener;
    private HandlerThread mThread;
    private String mSSid;
    private String mPassword;
    private DirectConnect mP2pConnect;
    private ApConnectQ mApConnectQ;
    private ApConnect mApConnect;
    private WifiManager.WifiLock mWifiLock;
    private boolean isTargetSdkLessThanQOrPrivileged;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static WifiConnection getInstance(Context context) {
        if (mInstance != null) return mInstance;
        Class<WifiConnection> clazz = WifiConnection.class;
        synchronized (WifiConnection.class) {
            if (mInstance != null) return mInstance;
            mInstance = new WifiConnection(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return mInstance;
        }
    }

    private WifiConnection(Context context) {
        this.mContext = context.getApplicationContext();
        this.isTargetSdkLessThanQOrPrivileged = WifiUtils.isTargetSdkLessThanQOrPrivileged(context);
    }

    public String getTargetIp() {
        if (this.mP2pConnect != null) {
            return this.mP2pConnect.getIp();
        }
        return "";
    }

    public boolean isP2pConnect() {
        return !TextUtils.isEmpty((CharSequence)this.getTargetIp());
    }

    public String getTargetMac() {
        if (this.mP2pConnect != null) {
            return this.mP2pConnect.getMac();
        }
        return "";
    }

    public void stop() {
        if (this.mP2pConnect != null) {
            this.mP2pConnect.stop();
        }
        if (this.mApConnectQ != null) {
            this.mApConnectQ.stop();
        }
        if (this.mApConnect != null) {
            this.mApConnect.stop();
        }
    }

    public void close() {
        try {
            if (this.mWrapListener != null) {
                this.mWrapListener.setListener(null);
                this.mWrapListener = null;
            }
            if (this.mThread != null) {
                this.mThread.quitSafely();
                this.mThread = null;
            }
            if (this.mP2pConnect != null) {
                this.mP2pConnect.close();
                this.mP2pConnect = null;
            }
            if (this.mApConnectQ != null) {
                this.mApConnectQ.close();
                this.mApConnectQ = null;
            }
            if (this.mApConnect != null) {
                this.mApConnect.close();
                this.mApConnect = null;
            }
            if (this.mWifiLock != null && this.mWifiLock.isHeld()) {
                this.mWifiLock.release();
                this.mWifiLock = null;
            }
            mInstance = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean connect(String ssid, String pass, Listener listener) {
        this.mSSid = ssid;
        this.mPassword = pass;
        boolean isP2p = this.isP2p();
        WiFiLog.getInstance().d(this.TAG, "connect ssid:" + ssid + ", pass:" + pass + ", isTargetSdkLessThanQOrPrivileged:" + this.isTargetSdkLessThanQOrPrivileged + ", isP2p:" + isP2p + ", Thread ID:" + Thread.currentThread().getId());
        if (this.mThread == null) {
            this.mThread = new HandlerThread("connection", 0);
            this.mThread.start();
        }
        if (this.mWrapListener == null) {
            this.mWrapListener = new WrapListener();
        }
        this.mWrapListener.setListener(listener);
        boolean start = false;
        if (!TextUtils.isEmpty((CharSequence)this.mSSid)) {
            if (isP2p && !WifiUtils.isTargetSdkLessThanQOrPrivileged((Context)BaseApplication.baseApplication)) {
                WiFiLog.getInstance().d(this.TAG, "connect DirectConnect");
                if (this.mP2pConnect == null) {
                    this.mP2pConnect = new DirectConnect(this.mContext, this.mThread.getLooper());
                }
                ConnectivityManager cm = (ConnectivityManager)this.mContext.getSystemService("connectivity");
                if (Build.VERSION.SDK_INT >= 23) {
                    cm.bindProcessToNetwork(null);
                } else {
                    ConnectivityManager.setProcessDefaultNetwork(null);
                }
                this.mWrapListener.setConnectType(1);
                this.mP2pConnect.start(this.mSSid, this.mPassword, this.mWrapListener);
                start = true;
            } else if (!this.isTargetSdkLessThanQOrPrivileged) {
                WiFiLog.getInstance().d(this.TAG, "connect tryConnectWithSpecifier");
                this.tryConnectWithSpecifier();
                start = true;
            } else if (this.ENABLE_CONNECT2) {
                WiFiLog.getInstance().d(this.TAG, "connect ApConnect");
                if (this.mApConnect == null) {
                    this.mApConnect = new ApConnect(this.mContext, this.mThread.getLooper());
                }
                this.mWrapListener.setConnectType(2);
                this.mApConnect.start(this.mSSid, this.mPassword, this.mWrapListener);
                start = true;
            }
        }
        if (start) {
            WiFiLog.getInstance().d("ConnectManager", "connect createWifiLock");
            WifiManager wm = (WifiManager)this.mContext.getSystemService("wifi");
            this.mWifiLock = wm.createWifiLock(3, "XshareWifiLock");
            this.mWifiLock.acquire();
            WiFiLog.getInstance().d("ConnectManager", "\u63a5\u6536\u65b9****************had connect wifi suc**********************");
        }
        return start;
    }

    private void tryConnectWithSpecifier() {
        if (this.mP2pConnect != null) {
            this.mP2pConnect.close();
        }
        if (this.mApConnectQ == null) {
            this.mApConnectQ = new ApConnectQ(this.mContext);
        }
        this.mWrapListener.setConnectType(3);
        this.mApConnectQ.connect(this.mSSid, this.mPassword, this.mThread.getLooper(), this.mWrapListener);
    }

    private boolean isP2p() {
        WifiManager wifiManager2 = (WifiManager)this.mContext.getSystemService("wifi");
        if (!TextUtils.isEmpty((CharSequence)this.mSSid)) {
            WiFiLog.getInstance().d(this.TAG, "start with DIRECT:" + this.mSSid.startsWith("DIRECT-") + ",  isP2PSupport:" + wifiManager2.isP2pSupported());
        } else {
            WiFiLog.getInstance().d(this.TAG, "isP2p mSSid:" + this.mSSid);
        }
        return this.mSSid != null && this.mSSid.startsWith("DIRECT-") && wifiManager2.isP2pSupported();
    }

    class WrapListener
    implements Listener {
        private int connectType = 0;
        private Listener mListener;

        WrapListener() {
        }

        public void setListener(Listener listener) {
            this.mListener = listener;
        }

        public int getConnectType() {
            return this.connectType;
        }

        public void setConnectType(int connectType) {
            this.connectType = connectType;
        }

        @Override
        public void onStart() {
            WiFiLog.getInstance().d(WifiConnection.this.TAG, "onStart");
            if (this.mListener != null) {
                this.mListener.onStart();
            }
        }

        @Override
        public void onFail(int reason) {
            WiFiLog.getInstance().d(WifiConnection.this.TAG, "onFail reason:" + reason);
            if (reason == -4) {
                WifiConnection.this.tryConnectWithSpecifier();
            } else if (this.mListener != null) {
                this.mListener.onFail(reason);
            }
        }

        @Override
        public void onSuccess(InetAddress address) {
            try {
                WiFiLog.getInstance().d(WifiConnection.this.TAG, "onSuccess " + address);
                if (this.mListener != null) {
                    this.mListener.onSuccess(address);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static interface Listener {
        public void onStart();

        public void onFail(int var1);

        public void onSuccess(InetAddress var1);
    }
}

