/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.business.wifi;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import com.google.gson.Gson;
import com.xshare.base.BaseApplication;
import com.xshare.business.utils.ApkUtils;
import com.xshare.business.utils.RandomUtils;
import com.xshare.business.utils.WiFiLog;
import com.xshare.business.wifi.XSWiFiManager;
import java.util.ArrayList;

public class WifiDeviceBean
implements Parcelable {
    private String wifiSSID;
    private String password;
    private String transferId;
    private long ipAddresses;
    private String channel;
    private String clientId;
    public static final Parcelable.Creator<WifiDeviceBean> CREATOR = new Parcelable.Creator<WifiDeviceBean>(){

        public WifiDeviceBean createFromParcel(Parcel in) {
            return new WifiDeviceBean(in);
        }

        public WifiDeviceBean[] newArray(int size) {
            return new WifiDeviceBean[size];
        }
    };

    public WifiDeviceBean() {
    }

    public WifiDeviceBean(String decodeInfo) {
        WifiDeviceBean.qrCovertObject(decodeInfo);
    }

    public WifiDeviceBean(String wifiSSID, String password, long address) {
        this.wifiSSID = wifiSSID;
        this.password = password;
        this.ipAddresses = address;
        this.transferId = RandomUtils.getRandomString(8);
    }

    public WifiDeviceBean(String wifiSSID, String password, String transferId) {
        this.wifiSSID = wifiSSID;
        this.password = password;
        this.transferId = TextUtils.isEmpty((CharSequence)transferId) ? RandomUtils.getRandomString(8) : transferId;
    }

    protected WifiDeviceBean(Parcel in) {
        this.wifiSSID = in.readString();
        this.password = in.readString();
        this.transferId = in.readString();
        this.ipAddresses = in.readLong();
        this.channel = in.readString();
        this.clientId = in.readString();
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.wifiSSID);
        dest.writeString(this.password);
        dest.writeString(this.transferId);
        dest.writeLong(this.ipAddresses);
        dest.writeString(this.channel);
        dest.writeString(this.clientId);
    }

    public int describeContents() {
        return 0;
    }

    public String getWifiSSID() {
        return this.wifiSSID;
    }

    public void setWifiSSID(String wifiSSID) {
        this.wifiSSID = wifiSSID;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getTransferId() {
        return this.transferId;
    }

    public void setTransferId(String transferId) {
        this.transferId = transferId;
    }

    public long getIpAddresses() {
        return this.ipAddresses;
    }

    public void setIpAddresses(long ipAddresses) {
        this.ipAddresses = ipAddresses;
    }

    public String getChannel() {
        return this.channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public ArrayList<String> generateList() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(this.wifiSSID);
        list.add(this.transferId);
        list.add(this.password);
        list.add(this.ipAddresses + "");
        list.add(this.channel);
        list.add(this.clientId);
        return list;
    }

    public String toString() {
        return "WifiDeviceBean{wifiSSID='" + this.wifiSSID + '\'' + ", password='" + this.password + '\'' + ", transferId='" + this.transferId + '\'' + ", ipAddresses=" + this.ipAddresses + ", channel='" + this.channel + '\'' + ", clientId='" + this.clientId + '\'' + '}';
    }

    public String createQrStr() {
        return "XSC:" + new Gson().toJson((Object)this);
    }

    public static WifiDeviceBean qrCovertObject(String qrStr) {
        try {
            if (!TextUtils.isEmpty((CharSequence)qrStr)) {
                String strGson = qrStr.replace("XSC:", "");
                WifiDeviceBean temp = (WifiDeviceBean)new Gson().fromJson(strGson, WifiDeviceBean.class);
                return temp;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.e((String)"WifiDevicesBean", (String)("Covert QrData Exception:" + e.getMessage()));
        }
        return null;
    }

    public String createTransferQrStr() {
        WiFiLog.getInstance().e("WifiDevicesBean", "initQrString: SSID=" + this.wifiSSID + "\t ShareKey:" + this.password);
        StringBuilder builder = new StringBuilder();
        builder.append("https://play.google.com/store/apps/details?id=com.infinix.xshare&referrer=utm_source%3Dshare_link");
        builder.append("gp");
        builder.append("&");
        if (!XSWiFiManager.getInstance().isUse5G()) {
            builder.append("?c=").append("2.4G");
        } else {
            builder.append("?c=").append("5G");
        }
        builder.append("?t=").append(ApkUtils.getVersionCode((Context)BaseApplication.baseApplication)).append("?b=").append(this.transferId).append("?i=").append(this.wifiSSID);
        if (!TextUtils.isEmpty((CharSequence)this.password)) {
            builder.append("?x=").append(this.password);
        }
        return builder.toString();
    }
}

