/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.business.wifi;

import android.annotation.SuppressLint;
import android.content.Context;
import android.net.wifi.WifiManager;
import android.os.PowerManager;
import com.xshare.base.BaseApplication;
import com.xshare.business.utils.WiFiLog;

public class WifiLockManager {
    private final String TAG = WifiLockManager.class.getSimpleName();
    private WifiManager.WifiLock mWifiLock;
    private PowerManager.WakeLock mWakeLock;
    private Context mContext = BaseApplication.baseApplication.getApplicationContext();

    private WifiLockManager() {
    }

    public static WifiLockManager getInstance() {
        return SingleTonHolder.INSTANCE;
    }

    @SuppressLint(value={"InvalidWakeLockTag"})
    public void acquire() {
        try {
            if (this.mWifiLock == null) {
                WifiManager wifiManager2 = (WifiManager)this.mContext.getSystemService("wifi");
                this.mWifiLock = wifiManager2.createWifiLock(3, "XS:Wifi-Connect");
            }
            if (this.mWakeLock == null) {
                PowerManager powerManager = (PowerManager)this.mContext.getSystemService("power");
                this.mWakeLock = powerManager.newWakeLock(1, "XS:Wifi-Connect");
            }
            if (!this.mWifiLock.isHeld()) {
                WiFiLog.getInstance().d(this.TAG, "acquire wifi lock");
                this.mWifiLock.acquire();
            }
            if (!this.mWakeLock.isHeld()) {
                WiFiLog.getInstance().d(this.TAG, "acquire wake lock");
                this.mWakeLock.acquire();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void release() {
        if (this.mWifiLock != null && this.mWifiLock.isHeld()) {
            WiFiLog.getInstance().d(this.TAG, "release wifi lock");
            this.mWifiLock.release();
            this.mWifiLock = null;
        }
        if (this.mWakeLock != null && this.mWakeLock.isHeld()) {
            WiFiLog.getInstance().d(this.TAG, "release wake lock");
            this.mWakeLock.release();
            this.mWakeLock = null;
        }
    }

    private static class SingleTonHolder {
        private static WifiLockManager INSTANCE = new WifiLockManager();

        private SingleTonHolder() {
        }
    }
}

