/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.business.wifi;

import android.app.admin.DevicePolicyManager;
import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import java.util.Random;

public class WifiUtils {
    public static final String USER_ICON = "X";
    private static final int APP_INFO_FLAGS_SYSTEM_APP = 129;

    static boolean isTargetSdkLessThanQOrPrivileged(Context context) {
        return Build.VERSION.SDK_INT < 29 || context.getApplicationInfo().targetSdkVersion < 29 || WifiUtils.isDeviceOrProfileOwner(context, context.getPackageName()) || (context.getApplicationInfo().flags & 0x81) != 0;
    }

    private static boolean isDeviceOrProfileOwner(Context context, String pacakgeName) {
        if (Build.VERSION.SDK_INT >= 23) {
            DevicePolicyManager devicePolicyManager = (DevicePolicyManager)context.getSystemService(DevicePolicyManager.class);
            return devicePolicyManager != null && (devicePolicyManager.isDeviceOwnerApp(pacakgeName) || devicePolicyManager.isProfileOwnerApp(pacakgeName));
        }
        return false;
    }

    public static String getRandom(int len) {
        char[] str = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
        StringBuffer stringBuffer = new StringBuffer("");
        Random r = new Random();
        for (int count = 0; count < len; ++count) {
            int i = r.nextInt(str.length);
            stringBuffer.append(str[i]);
        }
        return stringBuffer.toString();
    }

    static String convertToQuotedString(String ssid) {
        if (TextUtils.isEmpty((CharSequence)ssid)) {
            return "";
        }
        int lastPos = ssid.length() - 1;
        if (lastPos < 0 || ssid.charAt(0) == '\"' && ssid.charAt(lastPos) == '\"') {
            return ssid;
        }
        return "\"" + ssid + "\"";
    }
}

