/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.business.wifi;

import android.annotation.SuppressLint;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.DhcpInfo;
import android.net.Network;
import android.net.NetworkInfo;
import android.net.wifi.SupplicantState;
import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.net.wifi.p2p.WifiP2pManager;
import android.os.Build;
import android.os.Looper;
import android.text.TextUtils;
import android.util.Log;
import com.xshare.base.BaseApplication;
import com.xshare.business.utils.LogUtils;
import com.xshare.business.utils.NetUtils;
import com.xshare.business.utils.PermissionCheckUtils;
import com.xshare.business.utils.SPUtils;
import com.xshare.business.utils.WiFiLog;
import com.xshare.business.utils.WifiManagerHelper;
import com.xshare.business.utils.XSMatch;
import com.xshare.business.utils.XShareUtils;
import com.xshare.business.wifi.ConnectCallBack;
import com.xshare.business.wifi.CreateHotSpotCallBack;
import com.xshare.business.wifi.HotSpotManager;
import com.xshare.business.wifi.IWifiManager;
import com.xshare.business.wifi.WifiConnection;
import com.xshare.business.wifi.WifiDeviceBean;
import com.xshare.business.wifi.XsConnectManager;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.List;

public class XSWiFiManager
implements IWifiManager {
    private static final String TAG = XSWiFiManager.class.getSimpleName();
    public WifiManager mWifiManager = null;
    public WifiP2pManager mWifiP2pManager = null;
    public WifiP2pManager.Channel mChannel = null;
    public HotSpotManager hotSpotManager = null;
    public XsConnectManager connectManager = null;
    public WifiDeviceBean mWifiDeviceBean = null;
    private Network mDefaultNetWork;
    public static final String UNKNOWN_SSID = "unknown ssid";
    public int WIFI_STATUS = 1044481;
    private boolean support5G;
    private boolean current5G;
    private long startConnectTime;

    private XSWiFiManager() {
        try {
            this.mWifiManager = (WifiManager)BaseApplication.baseApplication.getApplicationContext().getSystemService("wifi");
            this.mWifiP2pManager = (WifiP2pManager)BaseApplication.baseApplication.getSystemService("wifip2p");
            this.support5G = WifiManagerHelper.is5GHzBandSupported(this.mWifiManager) && !XSMatch.noSupport5GBand() && !XSMatch.connectAPOnly() && Build.VERSION.SDK_INT >= 26;
            LogUtils.e(TAG, "support5G mWifiManager.is5GHzBandSupported():" + WifiManagerHelper.is5GHzBandSupported(this.mWifiManager));
            LogUtils.e(TAG, "support5G XSMatch.noSupport5GBand():" + XSMatch.noSupport5GBand() + ",BRAND:" + XSMatch.BRAND + ",MODEL:" + XSMatch.MODEL);
            LogUtils.e(TAG, "support5G XSMatch.connectAPOnly() :" + XSMatch.connectAPOnly());
            LogUtils.e(TAG, "support5G  :" + this.support5G);
            this.mChannel = this.mWifiP2pManager.initialize((Context)BaseApplication.baseApplication, Looper.getMainLooper(), null);
            this.hotSpotManager = new HotSpotManager(this.mWifiManager, this.mWifiP2pManager, this.mChannel);
            this.connectManager = new XsConnectManager(this.mWifiManager);
            this.mDefaultNetWork = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static IWifiManager getInstance() {
        return SingleTonHolder.INSTANCE;
    }

    @Override
    public WifiManager getWifiManager() {
        return this.mWifiManager;
    }

    @Override
    public WifiP2pManager getWifiP2p() {
        return this.mWifiP2pManager;
    }

    @Override
    public WifiP2pManager.Channel getP2pChannel() {
        if (this.mWifiP2pManager != null) {
            return this.mWifiP2pManager.initialize((Context)BaseApplication.baseApplication, Looper.getMainLooper(), null);
        }
        return null;
    }

    private void saveCheck() {
        if (this.hotSpotManager == null) {
            if (this.mWifiP2pManager == null) {
                this.mWifiP2pManager = (WifiP2pManager)BaseApplication.baseApplication.getSystemService("wifip2p");
            }
            if (this.mChannel == null) {
                this.mChannel = this.mWifiP2pManager.initialize((Context)BaseApplication.baseApplication, Looper.getMainLooper(), null);
                this.hotSpotManager = new HotSpotManager(this.mWifiManager, this.mWifiP2pManager, this.mChannel);
            } else {
                this.hotSpotManager = new HotSpotManager(this.mWifiManager, this.mWifiP2pManager, this.mChannel);
            }
        }
    }

    @Override
    public synchronized void createHotSpotHost(CreateHotSpotCallBack createHotSpotCallBack, int wifiType) {
        WiFiLog.getInstance().d(TAG, "createHotSpotHost wifiType\uff1a" + wifiType);
        try {
            this.saveCheck();
            this.hotSpotManager.initHandlerThread();
            switch (wifiType) {
                case 1044481: {
                    this.hotSpotManager.initDirect(createHotSpotCallBack, false);
                    break;
                }
                case 1044482: {
                    this.hotSpotManager.initLocalHotspot(createHotSpotCallBack);
                    break;
                }
                case 1044483: {
                    this.hotSpotManager.initWifiApStatus(createHotSpotCallBack);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public synchronized void createHotSpot(CreateHotSpotCallBack createHotSpotCallBack, boolean enforce5G) {
        this.saveCheck();
        this.hotSpotManager.initHandlerThread();
        XSWiFiManager.getInstance().updateWifiStatus(1044484);
        if (Build.VERSION.SDK_INT >= 26) {
            this.hotSpotManager.initDirect(createHotSpotCallBack, enforce5G);
        } else if (PermissionCheckUtils.checkCanWriteSetting(BaseApplication.baseApplication.getApplicationContext())) {
            this.hotSpotManager.initWifiApStatus(createHotSpotCallBack);
        } else {
            createHotSpotCallBack.onFailed("No Permission");
        }
    }

    @Override
    public synchronized void addNetWork(WifiDeviceBean wifiDeviceBean, ConnectCallBack connectCallBack) {
        if (this.connectManager != null) {
            this.connectManager.initHandlerThread();
            this.connectManager.addNetWork(wifiDeviceBean, connectCallBack);
        } else if (connectCallBack != null) {
            connectCallBack.addNetFailed("connectManager is null");
        }
    }

    @Override
    @SuppressLint(value={"MissingPermission"})
    public synchronized String getCurrentSSID() {
        try {
            String ssidWithQuote = this.mWifiManager.getConnectionInfo().getSSID();
            if (ssidWithQuote.length() >= 3 && !this.mWifiManager.getConnectionInfo().getSupplicantState().equals((Object)SupplicantState.DISCONNECTED)) {
                String realSsid = ssidWithQuote.substring(1, ssidWithQuote.length() - 1);
                if (realSsid.contains(UNKNOWN_SSID)) {
                    try {
                        ConnectivityManager cm = (ConnectivityManager)BaseApplication.baseApplication.getSystemService("connectivity");
                        NetworkInfo networkInfo = cm.getActiveNetworkInfo();
                        if (networkInfo != null) {
                            realSsid = networkInfo.getExtraInfo();
                        }
                        if (realSsid == null) {
                            return "";
                        }
                    }
                    catch (Exception e) {
                        WiFiLog.getInstance().d(TAG, "getCurrentSSID->Current SSID:" + realSsid);
                    }
                }
                return realSsid;
            }
            return "";
        }
        catch (Exception e) {
            WiFiLog.getInstance().d(TAG, "getCurrentSSID Exception:" + e.getMessage());
            return "";
        }
    }

    @Override
    public boolean isSupport5G() {
        return this.support5G;
    }

    @Override
    public boolean reGetSupport5G() {
        this.support5G = WifiManagerHelper.is5GHzBandSupported(this.mWifiManager) && !XSMatch.noSupport5GBand() && !XSMatch.connectAPOnly() && Build.VERSION.SDK_INT >= 26;
        return this.support5G;
    }

    @Override
    public boolean isUse5G() {
        return this.isSupport5G() && SPUtils.isEnableHighSpeedMode((Context)BaseApplication.baseApplication);
    }

    @Override
    public boolean isXShareWifiConnected() {
        return XShareUtils.isXshareSsid((Context)BaseApplication.baseApplication, this.getCurrentSSID());
    }

    @Override
    public boolean isXShareSSID(String ssid) {
        return XShareUtils.isXshareSsid((Context)BaseApplication.baseApplication, ssid);
    }

    @Override
    public boolean wifiIsEnable() {
        if (this.mWifiManager != null) {
            return this.mWifiManager.isWifiEnabled();
        }
        return false;
    }

    @Override
    public void releaseWifiP2P() {
        block5: {
            try {
                if (this.mWifiP2pManager == null || this.mChannel == null) break block5;
                this.mWifiP2pManager.clearLocalServices(this.mChannel, null);
                this.mWifiP2pManager.removeGroup(this.mChannel, null);
                if (this.mChannel == null) break block5;
                try {
                    if (Build.VERSION.SDK_INT > 26) {
                        this.mChannel.close();
                    }
                }
                catch (Exception e) {
                    Log.i((String)TAG, (String)"onDestroy: mChannel.close() error");
                }
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"Remove Owner WifiP2PManager Group Exception");
            }
        }
    }

    @Override
    public void removeNetwork() {
        int id = BaseApplication.Companion.getNetworkId();
        WiFiLog.getInstance().i(TAG, "removeNetwork:" + id);
        this.removeNetwork(id);
    }

    @Override
    public void removeNetwork(int networkId) {
        WiFiLog.getInstance().i(TAG, "removeNetwork:" + networkId);
        if (networkId > -1) {
            try {
                if (null != this.mWifiManager) {
                    this.mWifiManager.disconnect();
                    boolean isRemove = this.mWifiManager.removeNetwork(networkId);
                    this.mWifiManager.saveConfiguration();
                    if (isRemove) {
                        BaseApplication.Companion.setNetworkId(-1);
                    }
                    WiFiLog.getInstance().i(TAG, "isRemove:" + isRemove);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    @SuppressLint(value={"MissingPermission"})
    public boolean isNetWorkConnect() {
        try {
            NetworkInfo networkInfo;
            ConnectivityManager connectivityManager = (ConnectivityManager)BaseApplication.baseApplication.getSystemService("connectivity");
            if (connectivityManager != null && (networkInfo = connectivityManager.getActiveNetworkInfo()) != null) {
                return networkInfo.isAvailable();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    @SuppressLint(value={"MissingPermission"})
    public boolean setProcessDefaultNetwork() {
        if (!WifiConnection.getInstance((Context)BaseApplication.baseApplication).isP2pConnect()) {
            ConnectivityManager cm = (ConnectivityManager)BaseApplication.baseApplication.getSystemService("connectivity");
            boolean ok = false;
            int curTime = 0;
            int maxTime = 20;
            do {
                ++curTime;
                Network[] networks = cm.getAllNetworks();
                Log.e((String)TAG, (String)("setProcessDefaultNetwork size:" + networks.length));
                for (Network network : networks) {
                    NetworkInfo networkInfo = null;
                    try {
                        networkInfo = cm.getNetworkInfo(network);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    Log.e((String)TAG, (String)("setProcessDefaultNetwork " + networkInfo + ", network:" + network));
                    if (networkInfo == null || networkInfo.getType() != 1) continue;
                    Log.e((String)TAG, (String)("setProcessDefaultNetwork2 " + network));
                    this.mDefaultNetWork = network;
                    if (Build.VERSION.SDK_INT >= 23) {
                        cm.bindProcessToNetwork(network);
                    } else {
                        ConnectivityManager.setProcessDefaultNetwork((Network)network);
                    }
                    ok = true;
                }
                if (ok) {
                    Log.e((String)TAG, (String)"setProcessDefaultNetwork OK!");
                    break;
                }
                Log.e((String)TAG, (String)"setProcessDefaultNetwork failed, start to sleep");
            } while (curTime < maxTime);
            return ok;
        }
        return false;
    }

    @Override
    public void releaseDefaultNetwork() {
        try {
            Log.e((String)TAG, (String)"releaseDefaultNetwork");
            if (this.mDefaultNetWork != null) {
                this.mDefaultNetWork = null;
            }
            ConnectivityManager cm = (ConnectivityManager)BaseApplication.baseApplication.getSystemService("connectivity");
            if (Build.VERSION.SDK_INT >= 23) {
                cm.bindProcessToNetwork(null);
            } else {
                ConnectivityManager.setProcessDefaultNetwork(null);
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"releaseDefaultNetwork.onAvailable: ", (Throwable)e);
        }
    }

    @Override
    @SuppressLint(value={"MissingPermission"})
    public void removeCurrentNet() {
        try {
            NetworkInfo networkInfo;
            Log.e((String)TAG, (String)"removeCurrentNet");
            ConnectivityManager connectivityManager = (ConnectivityManager)BaseApplication.baseApplication.getSystemService("connectivity");
            if (connectivityManager != null && (networkInfo = connectivityManager.getActiveNetworkInfo()) != null && networkInfo.isAvailable()) {
                WifiInfo wifiInfo = this.mWifiManager.getConnectionInfo();
                this.mWifiManager.removeNetwork(wifiInfo.getNetworkId());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    @SuppressLint(value={"MissingPermission"})
    public void removeXShareNet() {
        try {
            NetworkInfo networkInfo;
            Log.e((String)TAG, (String)"removeXShareNet");
            ConnectivityManager connectivityManager = (ConnectivityManager)BaseApplication.baseApplication.getApplicationContext().getSystemService("connectivity");
            if (connectivityManager != null && (networkInfo = connectivityManager.getActiveNetworkInfo()) != null && networkInfo.isAvailable()) {
                WifiInfo wifiInfo = this.mWifiManager.getConnectionInfo();
                if (XShareUtils.isXshareSsid(BaseApplication.baseApplication.getApplicationContext(), wifiInfo.getSSID())) {
                    this.mWifiManager.removeNetwork(wifiInfo.getNetworkId());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public synchronized void removeXShareNetBySSID(String targetSSID) {
        try {
            List mScanWifiConfiguration;
            if (!TextUtils.isEmpty((CharSequence)targetSSID) && (mScanWifiConfiguration = XSWiFiManager.getInstance().getWifiManager().getConfiguredNetworks()) != null) {
                for (WifiConfiguration scanConfig : mScanWifiConfiguration) {
                    String mSSID = scanConfig.SSID.replace("\"", "");
                    if (!targetSSID.equals(mSSID)) continue;
                    if (scanConfig.networkId > 1) {
                        WiFiLog.getInstance().e(TAG, "removeXShareNetBySSID\uff0ctargetSSID=" + targetSSID + ",scanConfigSSID =" + mSSID + ",scanConfigNetID=" + scanConfig.networkId);
                        WifiManagerHelper.forgetNetwork(XSWiFiManager.getInstance().getWifiManager(), scanConfig.networkId);
                        this.mWifiManager.disconnect();
                        boolean isRemove = this.mWifiManager.removeNetwork(scanConfig.networkId);
                        if (isRemove) {
                            BaseApplication.Companion.setNetworkId(-1);
                        } else {
                            this.removeNetwork(scanConfig.networkId);
                        }
                        WiFiLog.getInstance().e(TAG, "removeXShareNetBySSID->isRemove:" + isRemove);
                    }
                    this.mWifiManager.saveConfiguration();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean checkWifiStatus() {
        if (Build.VERSION.SDK_INT > 28) {
            return this.wifiIsEnable();
        }
        return true;
    }

    public long getGateIp() {
        DhcpInfo di = this.mWifiManager.getDhcpInfo();
        long gatewayIP = di.gateway;
        return gatewayIP;
    }

    @Override
    public boolean checkWifiEnable() {
        return this.wifiIsEnable();
    }

    @Override
    public void releaseWifi(boolean rmXshareNet) {
        try {
            WiFiLog.getInstance().e(TAG, "release");
            if (rmXshareNet) {
                this.removeXShareNet();
            } else {
                this.removeCurrentNet();
            }
            if (this.hotSpotManager != null) {
                this.hotSpotManager.release();
            }
            if (this.connectManager != null) {
                this.connectManager.release();
            }
            this.releaseWifiP2P();
            this.releaseDefaultNetwork();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void updateWifiStatus(int status) {
        this.WIFI_STATUS = status;
    }

    @Override
    public int getCurrentConnectType() {
        if (this.hotSpotManager != null) {
            return this.hotSpotManager.getCurrentHotSpotType();
        }
        return 1044481;
    }

    @Override
    public int getWifiStatus() {
        return this.WIFI_STATUS;
    }

    @Override
    public void updateWifiDevice(String ssid, String pwd, long ip) {
        this.mWifiDeviceBean = new WifiDeviceBean(ssid, pwd, ip);
    }

    @Override
    public WifiDeviceBean getWifiDeviceInfo() {
        return this.mWifiDeviceBean;
    }

    @Override
    public void clearHostInfo() {
        this.mWifiDeviceBean = null;
    }

    @Override
    public long getLocalIP() {
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en != null && en.hasMoreElements()) {
                NetworkInterface intf = en.nextElement();
                Enumeration<InetAddress> enumIpAddr = intf.getInetAddresses();
                while (enumIpAddr != null && enumIpAddr.hasMoreElements()) {
                    InetAddress inetAddress = enumIpAddr.nextElement();
                    WiFiLog.getInstance().e("getLocalIpAddress", "IP:" + inetAddress.getHostAddress());
                    if (inetAddress.isLoopbackAddress() || !inetAddress.getHostAddress().startsWith("192.168")) continue;
                    return NetUtils.ipToLong(inetAddress.getHostAddress());
                }
            }
        }
        catch (Exception ex) {
            Log.e((String)TAG, (String)("Can't getIP SocketException:" + ex.toString()));
        }
        return 0L;
    }

    @Override
    public boolean isXShareSender() {
        return 1044482 == this.WIFI_STATUS && this.mWifiDeviceBean != null && this.getLocalIP() == this.mWifiDeviceBean.getIpAddresses();
    }

    @SuppressLint(value={"MissingPermission"})
    private boolean isMobile() {
        ConnectivityManager connectivityManager = (ConnectivityManager)BaseApplication.baseApplication.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        networkInfo.getDetailedState();
        return networkInfo != null && networkInfo.getType() == 0;
    }

    @Override
    @SuppressLint(value={"MissingPermission"})
    public boolean isWifiConnected() {
        ConnectivityManager connectivityManager = (ConnectivityManager)BaseApplication.baseApplication.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        WiFiLog.getInstance().d(TAG, "isWifiConnected " + networkInfo);
        return networkInfo != null && networkInfo.getType() == 1 && networkInfo.isConnected();
    }

    @Override
    @SuppressLint(value={"MissingPermission"})
    public NetworkInfo.DetailedState getCurrentConnectStatus() {
        ConnectivityManager connectivityManager = (ConnectivityManager)BaseApplication.baseApplication.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        if (networkInfo != null) {
            return networkInfo.getDetailedState();
        }
        return null;
    }

    private int getNetworkId(WifiInfo wifiInfo) {
        try {
            return wifiInfo.getNetworkId();
        }
        catch (Throwable unused) {
            return -1;
        }
    }

    private String getSsid(WifiInfo wifiInfo) {
        try {
            String ssid = wifiInfo.getSSID();
            if (ssid == null) {
                return null;
            }
            if (TextUtils.equals((CharSequence)"<unknown ssid>", (CharSequence)ssid)) {
                return null;
            }
            return ssid.replace("\"", "");
        }
        catch (Throwable unused) {
            return null;
        }
    }

    private WifiInfo getWifiInfo() {
        try {
            return this.mWifiManager.getConnectionInfo();
        }
        catch (Throwable unused) {
            return null;
        }
    }

    public boolean checkIp(WifiInfo wifiInfo) {
        try {
            int ipAddress = wifiInfo.getIpAddress();
            String str = ipAddress == 0 ? null : NetUtils.longToIp(ipAddress);
            return !TextUtils.isEmpty((CharSequence)str);
        }
        catch (Throwable unused) {
            return false;
        }
    }

    @Override
    public boolean checkIp() {
        try {
            int ipAddress = this.getWifiManager().getConnectionInfo().getIpAddress();
            String str = ipAddress == 0 ? null : NetUtils.longToIp(ipAddress);
            return !TextUtils.isEmpty((CharSequence)str);
        }
        catch (Throwable unused) {
            return false;
        }
    }

    @Override
    public int getConnectIp() {
        try {
            return this.getWifiManager().getConnectionInfo().getIpAddress();
        }
        catch (Throwable unused) {
            return 0;
        }
    }

    @Override
    public long getGateway() {
        try {
            DhcpInfo di = this.getWifiManager().getDhcpInfo();
            long gatewayIP = di.gateway;
            if (gatewayIP != 0L) {
                return gatewayIP;
            }
        }
        catch (Exception e) {
            WiFiLog.getInstance().e(TAG, "getGateway useGatewayAsIPWithoutMac Exception:" + e);
        }
        return 0L;
    }

    @Override
    public void printNetworkLog(String TAG) {
        try {
            WiFiLog.printNetworkLog((Context)BaseApplication.baseApplication, TAG);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setStartAddNetWorkTime(long time) {
        this.startConnectTime = time;
    }

    @Override
    public long getStartAddNetWorkTime() {
        return this.startConnectTime;
    }

    @Override
    public void setCurrentWifiModule(boolean is5G) {
        this.current5G = is5G;
    }

    @Override
    public boolean getCurrentWifiModule() {
        return this.current5G;
    }

    private static class SingleTonHolder {
        private static IWifiManager INSTANCE = new XSWiFiManager();

        private SingleTonHolder() {
        }
    }
}

