/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.business.wifi;

import android.annotation.SuppressLint;
import android.net.NetworkInfo;
import android.net.wifi.ScanResult;
import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.text.TextUtils;
import android.util.Log;
import com.xshare.base.BaseApplication;
import com.xshare.business.utils.WiFiLog;
import com.xshare.business.utils.XsDeviceUtils;
import com.xshare.business.wifi.ConfigUtil;
import com.xshare.business.wifi.ConnectCallBack;
import com.xshare.business.wifi.WifiDeviceBean;
import com.xshare.business.wifi.WifiLockManager;
import com.xshare.business.wifi.XSWiFiManager;
import com.xshare.trans.R;
import java.lang.reflect.Method;
import java.util.List;

public class XsConnectManager {
    private final String TAG = XsConnectManager.class.getSimpleName();
    private HandlerThread mHandlerThread;
    private Handler mHandler;
    private volatile ConnectCallBack mConnectCallBack;
    private int ADD_NETWORK_RETRY_COUNTS = 5;
    private int mLastNetworkId = -1;
    private int mCurrentNetworkId = -1;
    private int RETRY_TIMES = 10;
    private int blindConnectCounts = 0;
    private final WifiManager mWifiManager;
    private final int WAIT_WIFI_CONNECT_TIME = 350;
    private int CHECK_TIMES = 15;
    private long CHECK_WIFI_STATUS_TIME = 1000L;
    private List<ScanResult> mScanResultList;
    private final Object WIFI_LOCK = new Object();
    private final int MSG_CONNECT = 1001;
    int netId = -1;
    boolean findOldConfig = false;
    WifiDeviceBean mWifiDeviceBean;

    public XsConnectManager(WifiManager wifiManager2) {
        this.mWifiManager = wifiManager2;
    }

    public void addNetWork(WifiDeviceBean wifiDeviceBean, ConnectCallBack connectCallBack) {
        this.mConnectCallBack = connectCallBack;
        this.blindConnectCounts = 0;
        WiFiLog.getInstance().e(this.TAG, "addNetWork");
        Message msgObj = this.mHandler.obtainMessage();
        msgObj.obj = wifiDeviceBean;
        msgObj.what = 1001;
        this.mHandler.sendMessage(msgObj);
    }

    private void initParameter() {
        long lowMemLimit = 0x200000L;
        if (XsDeviceUtils.isTranssionPhone() && XsDeviceUtils.getTotalMemory(BaseApplication.baseApplication.getApplicationContext()) < lowMemLimit) {
            WiFiLog.getInstance().d(this.TAG, "Transsion Phone lowMemLimit");
            this.CHECK_WIFI_STATUS_TIME = 1500L;
            this.CHECK_TIMES = 30;
            this.RETRY_TIMES = 20;
            this.ADD_NETWORK_RETRY_COUNTS = 8;
        }
    }

    public void initHandlerThread() {
        if (this.mHandlerThread != null && this.mHandlerThread.isAlive()) {
            this.mHandlerThread.quitSafely();
            this.mHandlerThread = null;
        }
        if (this.mHandler != null) {
            this.mHandler.removeCallbacksAndMessages(null);
        }
        WiFiLog.getInstance().e(this.TAG, "initHandlerThread");
        this.mHandlerThread = new HandlerThread("XsConnectManager", 0);
        this.mHandlerThread.start();
        this.mHandler = new Handler(this.mHandlerThread.getLooper()){

            public void dispatchMessage(Message msg) {
                switch (msg.what) {
                    case 1001: {
                        XsConnectManager.this.connectNetWork((WifiDeviceBean)msg.obj);
                    }
                }
            }
        };
    }

    private void connectNetWork(WifiDeviceBean wifiDeviceBean) {
        WifiLockManager.getInstance().acquire();
        this.initParameter();
        this.mWifiDeviceBean = wifiDeviceBean;
        if (this.mWifiDeviceBean == null) {
            return;
        }
        try {
            this.netId = -1;
            this.findOldConfig = false;
            WiFiLog.getInstance().e(this.TAG, "Connect Step 1 START_CONNECT\uff0cTarget SSID=" + wifiDeviceBean.getWifiSSID());
            for (int tryCount = 0; this.mWifiManager.getWifiState() != 3 && tryCount < this.RETRY_TIMES * 2; ++tryCount) {
                try {
                    WiFiLog.getInstance().e(this.TAG, "wait wifi open, time:" + tryCount);
                    this.mWifiManager.setWifiEnabled(true);
                    Thread.sleep(350L);
                    continue;
                }
                catch (InterruptedException e) {
                    return;
                }
            }
            this.processWifiConnect();
        }
        catch (Exception e) {
            e.printStackTrace();
            if (this.mConnectCallBack != null) {
                this.mConnectCallBack.addNetFailed("connectNetWork Error Exception");
            }
            WiFiLog.getInstance().e(this.TAG, "mConnectCallBack3 is null");
        }
    }

    @SuppressLint(value={"MissingPermission"})
    private void processWifiConnect() {
        WiFiLog.getInstance().e(this.TAG, "Connect Step 2 CONNECTION_INITIALIZED ssid:" + this.mWifiDeviceBean.getWifiSSID());
        this.mWifiManager.startScan();
        int currentConnectId = this.mWifiManager.getConnectionInfo().getNetworkId();
        List existingConfigs = this.mWifiManager.getConfiguredNetworks();
        WiFiLog.getInstance().d(this.TAG, "Connect Step 2.1  Saved WifiConfigs  existingConfigs Size:" + existingConfigs.size());
        for (Object existingConfig : existingConfigs) {
            String saveConfigSSID = ((WifiConfiguration)existingConfig).SSID.replaceAll("\"", "");
            String pwd = ((WifiConfiguration)existingConfig).preSharedKey;
            if (TextUtils.isEmpty((CharSequence)saveConfigSSID) || !this.mWifiDeviceBean.getWifiSSID().equals(saveConfigSSID)) continue;
            this.netId = ((WifiConfiguration)existingConfig).networkId;
            WiFiLog.getInstance().d(this.TAG, "Connect Step 2.2  currentConnectId:" + currentConnectId + ", netId=" + this.netId + ", pwd=" + pwd);
            if (saveConfigSSID.startsWith(BaseApplication.baseApplication.getString(R.string.wifi_direct_prefix)) && TextUtils.isEmpty((CharSequence)pwd)) {
                WiFiLog.getInstance().d(this.TAG, "Connect Step 2.3  error pwd type save WifiConfiguration SSID:" + saveConfigSSID + ", netId=" + this.netId);
                XSWiFiManager.getInstance().removeNetwork(this.netId);
                this.netId = -1;
                this.findOldConfig = false;
                break;
            }
            WiFiLog.getInstance().d(this.TAG, "Connect Step 2.4  reEnableNetWork WifiConfiguration SSID:" + saveConfigSSID + ", netId=" + this.netId);
            this.mLastNetworkId = currentConnectId;
            if (this.mWifiManager != null) {
                this.mWifiManager.disconnect();
            }
            this.reEnableNetWork(this.netId);
            this.findOldConfig = true;
            break;
        }
        if (!this.findOldConfig) {
            for (int i = 0; i < this.RETRY_TIMES; ++i) {
                this.mScanResultList = this.mWifiManager.getScanResults();
                WiFiLog.getInstance().d(this.TAG, "Connect Step 2.5  Start WifiScan Retry counts:" + i + ", ScanResultList Size:" + this.mScanResultList.size());
                for (ScanResult result : this.mScanResultList) {
                    if (!this.mWifiDeviceBean.getWifiSSID().equals(result.SSID)) continue;
                    WiFiLog.getInstance().e(this.TAG, "Connect Step 3 Find XShare HotSpot , Start Connect to Target WIFI , SSID=" + result.SSID + ", capabilities:" + result.capabilities);
                    this.netId = this.connectToWifi(this.mWifiDeviceBean.getWifiSSID(), this.mWifiDeviceBean.getPassword(), result.capabilities);
                    WiFiLog.getInstance().e(this.TAG, "Connect Step 3.1 Connect to Target WIFI Finished netId:" + this.netId);
                    if (this.netId == -1) continue;
                    break;
                }
                if (this.netId != -1) break;
                try {
                    Thread.sleep(this.CHECK_WIFI_STATUS_TIME);
                    if (i % 3 != 0) continue;
                    this.mWifiManager.startScan();
                    continue;
                }
                catch (InterruptedException e) {
                    WiFiLog.getInstance().d(this.TAG, "CONFIGURED_WIFI InterruptedException: " + e);
                    return;
                }
            }
        }
        this.processWifiScanResult();
    }

    private void processWifiScanResult() {
        WiFiLog.getInstance().e(this.TAG, "Connect Step 4 processWifiScanResult findOldConfig=" + this.findOldConfig);
        if (!this.findOldConfig) {
            this.doBlindConnect();
        } else {
            NetworkInfo.DetailedState currentStatus = XSWiFiManager.getInstance().getCurrentConnectStatus();
            boolean connecting = true;
            if (currentStatus != null) {
                connecting = currentStatus == NetworkInfo.DetailedState.CONNECTING || currentStatus == NetworkInfo.DetailedState.AUTHENTICATING;
            }
            for (int checkStart = 0; connecting && checkStart < this.CHECK_TIMES; ++checkStart) {
                try {
                    Thread.sleep(350L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    break;
                }
                currentStatus = XSWiFiManager.getInstance().getCurrentConnectStatus();
                if (currentStatus == null) continue;
                connecting = currentStatus == NetworkInfo.DetailedState.CONNECTING || currentStatus == NetworkInfo.DetailedState.AUTHENTICATING;
            }
            String currentSSID = XSWiFiManager.getInstance().getCurrentSSID();
            boolean isCurrentWIFI = false;
            if (!TextUtils.isEmpty((CharSequence)currentSSID)) {
                isCurrentWIFI = currentSSID.equals(this.mWifiDeviceBean.getWifiSSID());
            }
            if (isCurrentWIFI) {
                if (this.mConnectCallBack != null) {
                    if (this.netId != -1) {
                        WiFiLog.getInstance().e(this.TAG, "Connect Step 7 addNetSucceed");
                        this.mConnectCallBack.addNetSucceed(this.netId);
                    } else {
                        WiFiLog.getInstance().e(this.TAG, "Connect Step 7 SHOW_RETRY");
                        this.mConnectCallBack.addNetFailed("processWifiScanResult Add Net Error");
                    }
                } else {
                    WiFiLog.getInstance().e(this.TAG, " processWifiScanResult mConnectCallBack2 is null");
                }
            } else {
                WiFiLog.getInstance().e(this.TAG, "Connect Step 7.1 blindConnectCounts\uff1a" + this.blindConnectCounts);
                if (this.blindConnectCounts < this.ADD_NETWORK_RETRY_COUNTS) {
                    XSWiFiManager.getInstance().removeNetwork(this.netId);
                    this.mWifiManager.startScan();
                    try {
                        Thread.sleep(this.CHECK_WIFI_STATUS_TIME);
                    }
                    catch (InterruptedException e) {
                        WiFiLog.getInstance().d(this.TAG, "blindConnectCounts InterruptedException: " + e);
                    }
                    this.netId = -1;
                    this.findOldConfig = false;
                    ++this.blindConnectCounts;
                    this.doBlindConnect();
                } else {
                    WiFiLog.getInstance().e(this.TAG, "Connect Step 7.1 SHOW_RETRY");
                    this.mConnectCallBack.addNetFailed("doBlindConnect Add Net Error");
                }
            }
        }
    }

    private void doBlindConnect() {
        this.netId = this.blindConnect(this.netId, this.mWifiDeviceBean.getWifiSSID(), this.mWifiDeviceBean.getPassword());
        WiFiLog.getInstance().e(this.TAG, "Connect Step 5 No Need Scan Result,Force Connect Result=" + this.netId);
        if (this.netId != -1) {
            if (XSWiFiManager.getInstance().getCurrentSSID().equals(this.mWifiDeviceBean.getWifiSSID())) {
                WiFiLog.getInstance().e(this.TAG, "Connect Step 6.0 connected wifi " + this.mWifiDeviceBean.getWifiSSID() + ", netId:" + this.netId + ", isOkRetryConnect:");
            } else {
                try {
                    Thread.sleep(350L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    return;
                }
                WiFiLog.getInstance().e(this.TAG, "Connect Step 6.1 didn't connect wifi\uff0creEnableNetWork ssid:" + this.mWifiDeviceBean.getWifiSSID() + ", netId:" + this.netId + "");
                this.reEnableNetWork(this.netId);
            }
        } else {
            this.mScanResultList = null;
        }
        NetworkInfo.DetailedState currentStatus = XSWiFiManager.getInstance().getCurrentConnectStatus();
        boolean connecting = true;
        if (currentStatus != null) {
            connecting = currentStatus == NetworkInfo.DetailedState.CONNECTING || currentStatus == NetworkInfo.DetailedState.AUTHENTICATING;
        }
        for (int checkStart = 0; connecting && checkStart < this.CHECK_TIMES; ++checkStart) {
            try {
                Thread.sleep(350L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                break;
            }
            currentStatus = XSWiFiManager.getInstance().getCurrentConnectStatus();
            if (currentStatus == null) continue;
            connecting = currentStatus == NetworkInfo.DetailedState.CONNECTING || currentStatus == NetworkInfo.DetailedState.AUTHENTICATING;
        }
        String currentSSID = XSWiFiManager.getInstance().getCurrentSSID();
        boolean isCurrentWIFI = false;
        if (!TextUtils.isEmpty((CharSequence)currentSSID)) {
            isCurrentWIFI = currentSSID.equals(this.mWifiDeviceBean.getWifiSSID());
        }
        if (isCurrentWIFI) {
            if (this.mConnectCallBack != null) {
                if (this.netId != -1) {
                    WiFiLog.getInstance().e(this.TAG, "Connect Step 9 addNetSucceed");
                    this.mConnectCallBack.addNetSucceed(this.netId);
                } else {
                    WiFiLog.getInstance().e(this.TAG, "Connect Step 9 SHOW_RETRY");
                    this.mConnectCallBack.addNetFailed("doBlindConnect Add Net Error");
                }
            } else {
                WiFiLog.getInstance().e(this.TAG, "doBlindConnect mConnectCallBack2 is null");
            }
        } else {
            WiFiLog.getInstance().e(this.TAG, "Connect Step 9.1 blindConnectCounts\uff1a" + this.blindConnectCounts);
            if (this.blindConnectCounts < this.ADD_NETWORK_RETRY_COUNTS) {
                XSWiFiManager.getInstance().removeNetwork(this.netId);
                this.mWifiManager.startScan();
                try {
                    Thread.sleep(this.CHECK_WIFI_STATUS_TIME);
                }
                catch (InterruptedException e) {
                    WiFiLog.getInstance().d(this.TAG, "blindConnectCounts InterruptedException: " + e);
                }
                this.netId = -1;
                this.findOldConfig = false;
                ++this.blindConnectCounts;
                this.processWifiConnect();
            } else {
                WiFiLog.getInstance().e(this.TAG, "Connect Step 9.1 SHOW_RETRY");
                this.mConnectCallBack.addNetFailed("doBlindConnect Add Net Error");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int connectToWifi(String ssid, String shareKey, String capabilities) {
        int netId = -1;
        try {
            Object object = this.WIFI_LOCK;
            synchronized (object) {
                if (XSWiFiManager.getInstance().getCurrentSSID().equals(ssid)) {
                    WiFiLog.getInstance().d(this.TAG, "Current XShare SSID had Connected. current SSID:" + XSWiFiManager.getInstance().getCurrentSSID());
                    return 0;
                }
                this.mLastNetworkId = this.mCurrentNetworkId;
                WifiConfiguration config = new WifiConfiguration();
                config.SSID = String.format("\"%s\"", ssid);
                config.priority = 1000000;
                ConfigUtil.setupSecurity(config, capabilities, shareKey);
                int addRetry = 0;
                while (addRetry < this.ADD_NETWORK_RETRY_COUNTS) {
                    if (this.mWifiManager != null) {
                        netId = this.mWifiManager.addNetwork(config);
                    }
                    if (netId != -1) break;
                    ++addRetry;
                    try {
                        Thread.sleep(350L);
                    }
                    catch (InterruptedException e) {
                        Log.e((String)this.TAG, (String)("addNetwork Interrupt:" + e.getMessage()));
                    }
                }
                WiFiLog.getInstance().d(this.TAG, "new network id:" + netId);
                if (netId == -1) {
                    WiFiLog.getInstance().d(this.TAG, "add ssid to network failure!");
                    return netId;
                }
                if (!TextUtils.isEmpty((CharSequence)shareKey)) {
                    ConfigUtil.updateNumAssociation(this.mWifiManager, config);
                }
                if (this.mWifiManager != null) {
                    this.mWifiManager.disconnect();
                }
                this.mCurrentNetworkId = netId;
                WiFiLog.getInstance().d(this.TAG, "set network id:" + netId + ", mLastNetworkId:" + this.mLastNetworkId);
                if (this.mLastNetworkId != -1 && this.mLastNetworkId != this.mCurrentNetworkId) {
                    WiFiLog.getInstance().d(this.TAG, "disableNetwork ID:" + this.mLastNetworkId);
                    this.mWifiManager.disableNetwork(this.mLastNetworkId);
                }
                boolean enableNetWork = false;
                if (this.mWifiManager != null) {
                    WiFiLog.getInstance().d(this.TAG, "enableNetwork ID:" + netId);
                    enableNetWork = this.mWifiManager.enableNetwork(netId, true);
                }
                if (!enableNetWork) {
                    this.mWifiManager.reassociate();
                }
                this.removeOldNetwork();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return netId;
    }

    public void reEnableNetWork(int netId) {
        try {
            this.mCurrentNetworkId = netId;
            WiFiLog.getInstance().d(this.TAG, "set network id:" + netId);
            if (this.mLastNetworkId != -1 && this.mLastNetworkId != this.mCurrentNetworkId && this.mWifiManager != null) {
                this.mWifiManager.disableNetwork(this.mLastNetworkId);
            }
            boolean enableNetWork = false;
            if (Build.VERSION.SDK_INT <= 23) {
                Method connectMethod = this.connectWifiByReflectMethod(netId);
                if (connectMethod == null && this.mWifiManager != null) {
                    WiFiLog.getInstance().d(this.TAG, "connect wifi by enableNetwork method");
                    enableNetWork = this.mWifiManager.enableNetwork(netId, true);
                }
            } else if (this.mWifiManager != null) {
                enableNetWork = this.mWifiManager.enableNetwork(netId, true);
            }
            if (!enableNetWork && this.mWifiManager != null) {
                this.mWifiManager.reassociate();
            }
            this.removeOldNetwork();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Method connectWifiByReflectMethod(int netId) {
        Method connectMethod = null;
        if (this.mWifiManager != null) {
            if (Build.VERSION.SDK_INT >= 17) {
                Log.i((String)this.TAG, (String)"connectWifiByReflectMethod road 1");
                for (Method methodSub : this.mWifiManager.getClass().getDeclaredMethods()) {
                    Class<?>[] types;
                    if (!"connect".equalsIgnoreCase(methodSub.getName()) || (types = methodSub.getParameterTypes()) == null || types.length <= 0 || !"int".equalsIgnoreCase(types[0].getName())) continue;
                    connectMethod = methodSub;
                }
                if (connectMethod != null) {
                    try {
                        connectMethod.invoke((Object)this.mWifiManager, netId, null);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        Log.i((String)this.TAG, (String)("connectWifiByReflectMethod Android " + Build.VERSION.SDK_INT + " error!"));
                        return null;
                    }
                }
            } else if (Build.VERSION.SDK_INT == 16) {
                Log.i((String)this.TAG, (String)"connectWifiByReflectMethod road 2");
            } else if (Build.VERSION.SDK_INT >= 14 && Build.VERSION.SDK_INT < 16) {
                Log.i((String)this.TAG, (String)"connectWifiByReflectMethod road 3");
                for (Method methodSub : this.mWifiManager.getClass().getDeclaredMethods()) {
                    Class<?>[] types;
                    if (!"connectNetwork".equalsIgnoreCase(methodSub.getName()) || (types = methodSub.getParameterTypes()) == null || types.length <= 0 || !"int".equalsIgnoreCase(types[0].getName())) continue;
                    connectMethod = methodSub;
                }
                if (connectMethod != null) {
                    try {
                        connectMethod.invoke((Object)this.mWifiManager, netId);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        Log.i((String)this.TAG, (String)("connectWifiByReflectMethod Android " + Build.VERSION.SDK_INT + " error!"));
                        return null;
                    }
                }
            } else {
                return null;
            }
        }
        return connectMethod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOldNetwork() {
        Object object = this.WIFI_LOCK;
        synchronized (object) {
            WiFiLog.getInstance().i(this.TAG, "removeOldNetwork mLastNetworkId:" + this.mLastNetworkId + ", mCurrentNetworkId=" + this.mCurrentNetworkId);
            if (this.mLastNetworkId != -1 && this.mLastNetworkId != this.mCurrentNetworkId) {
                WiFiLog.getInstance().i(this.TAG, "remove network id:" + this.mLastNetworkId);
                int i = 0;
                boolean removeSuccess = false;
                while (i < 10 && !removeSuccess) {
                    try {
                        removeSuccess = this.mWifiManager.removeNetwork(this.mLastNetworkId);
                        WiFiLog.getInstance().i(this.TAG, "removeNetwork Result:" + removeSuccess);
                        ++i;
                    }
                    catch (Exception e) {
                        ++i;
                    }
                }
                this.mWifiManager.saveConfiguration();
            }
        }
    }

    public void removeCurrentNetwork() {
        XSWiFiManager.getInstance().removeNetwork(this.mLastNetworkId);
        XSWiFiManager.getInstance().removeNetwork(this.mCurrentNetworkId);
    }

    private int blindConnect(int id, String ssid, String pass) {
        int netId = id;
        WiFiLog.getInstance().e(this.TAG, "Connect Step 4 No Need Scan Result,Force Connect ");
        if (netId == -1) {
            if (ssid.startsWith(BaseApplication.baseApplication.getString(R.string.wifi_direct_prefix))) {
                netId = this.reConnect(ssid, pass, "PSK");
                if (netId == -1) {
                    netId = this.reConnect(ssid, pass, "EAP");
                }
                if (netId == -1) {
                    netId = this.reConnect(ssid, pass, "WEP");
                }
            } else if (TextUtils.isEmpty((CharSequence)pass)) {
                netId = this.reConnect(ssid, pass, "OPEN");
            } else {
                netId = this.reConnect(ssid, pass, "PSK");
                if (netId == -1) {
                    netId = this.reConnect(ssid, pass, "EAP");
                }
                if (netId == -1) {
                    netId = this.reConnect(ssid, pass, "WEP");
                }
            }
        }
        return netId;
    }

    private int reConnect(String ssid, String pass, String security) {
        try {
            WiFiLog.getInstance().d(this.TAG, "ssid:" + ssid + ", pass:" + pass + ", type:" + security);
            Thread.sleep(300L);
            return this.connectToWifi(ssid, pass, security);
        }
        catch (InterruptedException e) {
            WiFiLog.getInstance().d(this.TAG, "reConnect InterruptedException: " + e);
            return -1;
        }
    }

    public void release() {
        if (this.mHandlerThread != null) {
            this.mHandlerThread.quitSafely();
            this.mHandlerThread = null;
        }
        if (this.mConnectCallBack != null) {
            this.mConnectCallBack = null;
        }
        if (this.mScanResultList != null) {
            this.mScanResultList.clear();
        }
    }
}

