/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.camera;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.drawable.AdaptiveIconDrawable;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;

public class BitmapUtil {
    public static final String APP_THUMBNAIL = "AppThumbnail";
    private static final int ICON_WIDTH = 144;
    public static final int ASSISTANT_ICON_WIDTH = 48;
    private static final int ICON_QUALITY = 100;
    private static final String TAG = BitmapUtil.class.getName();

    public static String getAppBundleIconExist(Context context, String appName) {
        String fileName;
        String root = context.getFilesDir().getAbsolutePath();
        File appDir = new File(root, APP_THUMBNAIL);
        File file = new File(appDir, fileName = appName + ".png");
        if (file != null && file.exists()) {
            return file.getPath();
        }
        return "";
    }

    public static byte[] Bitmap2Bytes(Bitmap bm) {
        if (bm == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        bm.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)baos);
        return baos.toByteArray();
    }

    public static Bitmap Bytes2Bimap(byte[] b) {
        if (b.length == 0) {
            return null;
        }
        return BitmapFactory.decodeByteArray((byte[])b, (int)0, (int)b.length);
    }

    public static Bitmap drawable2Bitmap(Drawable drawable) {
        Bitmap.Config config;
        if (drawable == null) {
            return null;
        }
        int width = drawable.getIntrinsicWidth();
        int height = drawable.getIntrinsicHeight();
        if (Build.VERSION.SDK_INT >= 26 && drawable instanceof AdaptiveIconDrawable) {
            config = Bitmap.Config.ARGB_8888;
        } else {
            Bitmap.Config config2 = config = drawable.getOpacity() != -1 ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565;
        }
        if (width > 0 && height > 0) {
            Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)config);
            Canvas canvas = new Canvas(bitmap);
            drawable.setBounds(0, 0, width, height);
            drawable.draw(canvas);
            return bitmap;
        }
        return null;
    }

    public static Drawable bitmap2Drawable(Bitmap bm) {
        if (bm == null) {
            return null;
        }
        return new BitmapDrawable(bm);
    }

    public static Bitmap drawbale2Bitmap(Drawable drawable) {
        if (Build.VERSION.SDK_INT >= 26 && drawable instanceof AdaptiveIconDrawable) {
            Bitmap bitmap = Bitmap.createBitmap((int)drawable.getIntrinsicWidth(), (int)drawable.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(bitmap);
            drawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
            drawable.draw(canvas);
            return bitmap;
        }
        return ((BitmapDrawable)drawable).getBitmap();
    }

    public static Bitmap parseBitmap(Context context, byte[] data) {
        if (data == null) {
            return null;
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(data, 0, 8);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        int width = intBuffer.get();
        int height = intBuffer.get();
        byteBuffer = ByteBuffer.wrap(data, 8, data.length - 8);
        intBuffer = byteBuffer.order(ByteOrder.BIG_ENDIAN).asIntBuffer();
        int[] pixels = new int[intBuffer.remaining()];
        intBuffer.get(pixels);
        Bitmap bitmap = null;
        try {
            bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            bitmap.setPixels(pixels, 0, width, 0, 0, width, height);
        }
        catch (IllegalArgumentException e) {
            Log.e((String)TAG, (String)("parseBitmap:IllegalArgumentException  e = " + e));
            return null;
        }
        return bitmap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBitmapByte(Context context, String apkIconPath) {
        if (TextUtils.isEmpty((CharSequence)apkIconPath)) {
            return null;
        }
        Bitmap bitmap = null;
        ByteBuffer byteBuffer = null;
        try {
            byte[] bytesArray;
            bitmap = BitmapFactory.decodeFile((String)apkIconPath);
            if (bitmap == null) {
                byte[] byArray = null;
                return byArray;
            }
            int width = bitmap.getWidth();
            int height = bitmap.getHeight();
            int[] pixels = new int[width * height];
            bitmap.getPixels(pixels, 0, width, 0, 0, width, height);
            byteBuffer = ByteBuffer.allocate((pixels.length + 2) * 4);
            IntBuffer intBuffer = byteBuffer.order(ByteOrder.BIG_ENDIAN).asIntBuffer();
            intBuffer.put(width);
            intBuffer.put(height);
            intBuffer.put(pixels);
            byte[] byArray = bytesArray = byteBuffer.array();
            return byArray;
        }
        catch (Exception e) {
            e.printStackTrace();
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (byteBuffer != null) {
                byteBuffer.clear();
            }
        }
    }

    public static boolean drawableCanUse(Drawable drawable) {
        try {
            if (drawable instanceof BitmapDrawable) {
                BitmapDrawable bitmapDrawable = (BitmapDrawable)drawable;
                return bitmapDrawable.getBitmap() != null && !bitmapDrawable.getBitmap().isRecycled();
            }
            if (Build.VERSION.SDK_INT >= 26 && drawable instanceof AdaptiveIconDrawable) {
                Drawable backgroundDr = ((AdaptiveIconDrawable)drawable).getBackground();
                Drawable foregroundDr = ((AdaptiveIconDrawable)drawable).getForeground();
                if (foregroundDr instanceof BitmapDrawable) {
                    BitmapDrawable forgBitmap = (BitmapDrawable)foregroundDr;
                    return backgroundDr != null && foregroundDr != null && forgBitmap != null && !forgBitmap.getBitmap().isRecycled();
                }
                return true;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }
}

