/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.camera;

import android.app.Activity;
import android.content.Context;
import android.graphics.Matrix;
import android.graphics.Point;
import android.graphics.RectF;
import android.graphics.SurfaceTexture;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.TotalCaptureResult;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.media.Image;
import android.media.ImageReader;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.Size;
import android.util.SparseIntArray;
import android.view.Surface;
import android.view.TextureView;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.core.app.ActivityCompat;
import com.xshare.camera.AutoFitTextureView;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public class Camera2Helper {
    private static Activity activity;
    private static final SparseIntArray ORIENTATIONS;
    private static final int STATE_PREVIEW = 0;
    private static final int STATE_WAITING_LOCK = 1;
    private static final int STATE_WAITING_PRECAPTURE = 2;
    private static final int STATE_WAITING_NON_PRECAPTURE = 3;
    private static final int STATE_PICTURE_TAKEN = 4;
    private static final int MAX_PREVIEW_WIDTH = 1920;
    private static final int MAX_PREVIEW_HEIGHT = 1080;
    private AutoFitTextureView textureView;
    private String mCameraId;
    private CameraCaptureSession mCaptureSession;
    private static CameraDevice mCameraDevice;
    private Size mPreviewSize;
    private HandlerThread mBackgroundThread;
    private Handler mBackgroundHandler;
    private ImageReader mImageReader;
    private static File mFile;
    private Semaphore mCameraOpenCloseLock = new Semaphore(1);
    private boolean mFlashSupported;
    private int mSensorOrientation;
    private CaptureRequest.Builder mPreviewRequestBuilder;
    private CaptureRequest mPreviewRequest;
    private int mState = 0;
    private static CameraManager manager;
    private AfterDoListener listener;
    private boolean isNeedHideProgressbar = true;
    private final ImageReader.OnImageAvailableListener mOnImageAvailableListener = new ImageReader.OnImageAvailableListener(){

        public void onImageAvailable(ImageReader reader) {
            Camera2Helper.this.mBackgroundHandler.post((Runnable)new ImageSaver(reader.acquireNextImage(), mFile));
        }
    };
    private final TextureView.SurfaceTextureListener mSurfaceTextureListener = new TextureView.SurfaceTextureListener(){

        public void onSurfaceTextureAvailable(SurfaceTexture texture, int width, int height) {
            Camera2Helper.this.openCamera(width, height);
        }

        public void onSurfaceTextureSizeChanged(SurfaceTexture texture, int width, int height) {
            Camera2Helper.this.configureTransform(width, height);
        }

        public boolean onSurfaceTextureDestroyed(SurfaceTexture texture) {
            return true;
        }

        public void onSurfaceTextureUpdated(SurfaceTexture texture) {
        }
    };
    private final CameraDevice.StateCallback mStateCallback = new CameraDevice.StateCallback(){

        public void onOpened(@NonNull CameraDevice cameraDevice) {
            Camera2Helper.this.mCameraOpenCloseLock.release();
            mCameraDevice = cameraDevice;
            Camera2Helper.this.createCameraPreviewSession();
        }

        public void onDisconnected(@NonNull CameraDevice cameraDevice) {
            Camera2Helper.this.mCameraOpenCloseLock.release();
            cameraDevice.close();
            mCameraDevice = null;
        }

        public void onError(@NonNull CameraDevice cameraDevice, int error) {
            Camera2Helper.this.mCameraOpenCloseLock.release();
            cameraDevice.close();
            mCameraDevice = null;
        }
    };
    private CameraCaptureSession.CaptureCallback mCaptureCallback = new CameraCaptureSession.CaptureCallback(){

        private void process(CaptureResult result) {
            switch (Camera2Helper.this.mState) {
                case 0: {
                    if (!Camera2Helper.this.isNeedHideProgressbar) break;
                    Camera2Helper.this.listener.onAfterPreviewBack();
                    Camera2Helper.this.isNeedHideProgressbar = false;
                    break;
                }
                case 1: {
                    Integer afState = (Integer)result.get(CaptureResult.CONTROL_AF_STATE);
                    if (afState == null) {
                        Camera2Helper.this.captureStillPicture();
                        break;
                    }
                    if (4 != afState && 5 != afState) break;
                    Integer aeState = (Integer)result.get(CaptureResult.CONTROL_AE_STATE);
                    if (aeState == null || aeState == 2) {
                        Camera2Helper.this.mState = 4;
                        Camera2Helper.this.captureStillPicture();
                        break;
                    }
                    Camera2Helper.this.runPrecaptureSequence();
                    break;
                }
                case 2: {
                    Integer aeState = (Integer)result.get(CaptureResult.CONTROL_AE_STATE);
                    if (aeState != null && aeState != 5 && aeState != 4) break;
                    Camera2Helper.this.mState = 3;
                    break;
                }
                case 3: {
                    Integer aeState = (Integer)result.get(CaptureResult.CONTROL_AE_STATE);
                    if (aeState != null && aeState == 5) break;
                    Camera2Helper.this.mState = 4;
                    Camera2Helper.this.captureStillPicture();
                    break;
                }
            }
        }

        public void onCaptureProgressed(@NonNull CameraCaptureSession session, @NonNull CaptureRequest request, @NonNull CaptureResult partialResult) {
            this.process(partialResult);
        }

        public void onCaptureCompleted(@NonNull CameraCaptureSession session, @NonNull CaptureRequest request, @NonNull TotalCaptureResult result) {
            this.process((CaptureResult)result);
        }
    };
    private static volatile Camera2Helper singleton;

    private Camera2Helper(Activity act, AutoFitTextureView view) {
    }

    private Camera2Helper(Activity act, AutoFitTextureView view, File file) {
        activity = act;
        this.textureView = view;
        mFile = file;
        manager = (CameraManager)activity.getSystemService("camera");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Camera2Helper getInstance(Activity act, AutoFitTextureView view, File file) {
        if (singleton != null) return singleton;
        Class<Camera2Helper> clazz = Camera2Helper.class;
        synchronized (Camera2Helper.class) {
            singleton = new Camera2Helper(act, view, file);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return singleton;
        }
    }

    public void startCameraPreView() {
        this.startBackgroundThread();
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                if (Camera2Helper.this.textureView != null) {
                    if (Camera2Helper.this.textureView.isAvailable()) {
                        Camera2Helper.this.openCamera(Camera2Helper.this.textureView.getWidth(), Camera2Helper.this.textureView.getHeight());
                    } else {
                        Camera2Helper.this.textureView.setSurfaceTextureListener(Camera2Helper.this.mSurfaceTextureListener);
                    }
                }
            }
        }, 300L);
    }

    private void startBackgroundThread() {
        this.mBackgroundThread = new HandlerThread("CameraBackground", 0);
        this.mBackgroundThread.start();
        this.mBackgroundHandler = new Handler(this.mBackgroundThread.getLooper());
    }

    private void stopBackgroundThread() {
        if (this.mBackgroundThread == null) {
            return;
        }
        this.mBackgroundThread.quitSafely();
        try {
            this.mBackgroundThread.join();
            this.mBackgroundThread = null;
            this.mBackgroundHandler = null;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void takePicture() {
        this.lockFocus();
    }

    private void captureStillPicture() {
        try {
            if (null == mCameraDevice) {
                return;
            }
            CaptureRequest.Builder captureBuilder = mCameraDevice.createCaptureRequest(2);
            captureBuilder.addTarget(this.mImageReader.getSurface());
            captureBuilder.set(CaptureRequest.CONTROL_AF_MODE, (Object)4);
            this.setAutoFlash(captureBuilder);
            int rotation = activity.getWindowManager().getDefaultDisplay().getRotation();
            captureBuilder.set(CaptureRequest.JPEG_ORIENTATION, (Object)this.getOrientation(rotation));
            CameraCaptureSession.CaptureCallback CaptureCallback2 = new CameraCaptureSession.CaptureCallback(){

                public void onCaptureCompleted(@NonNull CameraCaptureSession session, @NonNull CaptureRequest request, @NonNull TotalCaptureResult result) {
                    Camera2Helper.this.unlockFocus();
                    Camera2Helper.this.listener.onAfterTakePicture();
                }
            };
            this.mCaptureSession.stopRepeating();
            this.mCaptureSession.capture(captureBuilder.build(), CaptureCallback2, null);
        }
        catch (CameraAccessException e) {
            e.printStackTrace();
        }
    }

    private void lockFocus() {
        try {
            if (this.mCaptureSession == null) {
                return;
            }
            this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)1);
            this.mState = 1;
            this.mCaptureSession.capture(this.mPreviewRequestBuilder.build(), this.mCaptureCallback, this.mBackgroundHandler);
        }
        catch (CameraAccessException e) {
            e.printStackTrace();
        }
    }

    private void unlockFocus() {
        try {
            if (this.mCaptureSession == null) {
                return;
            }
            this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)2);
            this.setAutoFlash(this.mPreviewRequestBuilder);
            this.mCaptureSession.capture(this.mPreviewRequestBuilder.build(), this.mCaptureCallback, this.mBackgroundHandler);
            this.mState = 0;
            this.mCaptureSession.setRepeatingRequest(this.mPreviewRequest, this.mCaptureCallback, this.mBackgroundHandler);
        }
        catch (CameraAccessException e) {
            e.printStackTrace();
        }
    }

    private void setAutoFlash(CaptureRequest.Builder requestBuilder) {
        if (this.mFlashSupported) {
            requestBuilder.set(CaptureRequest.CONTROL_AE_MODE, (Object)2);
        }
    }

    private int getOrientation(int rotation) {
        return (ORIENTATIONS.get(rotation) + this.mSensorOrientation + 270) % 360;
    }

    private void runPrecaptureSequence() {
        try {
            this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AE_PRECAPTURE_TRIGGER, (Object)1);
            this.mState = 2;
            this.mCaptureSession.capture(this.mPreviewRequestBuilder.build(), this.mCaptureCallback, this.mBackgroundHandler);
        }
        catch (CameraAccessException e) {
            e.printStackTrace();
        }
    }

    private void createCameraPreviewSession() {
        try {
            SurfaceTexture texture = this.textureView.getSurfaceTexture();
            assert (texture != null);
            texture.setDefaultBufferSize(this.mPreviewSize.getWidth(), this.mPreviewSize.getHeight());
            Surface surface = new Surface(texture);
            this.mPreviewRequestBuilder = mCameraDevice.createCaptureRequest(1);
            this.mPreviewRequestBuilder.addTarget(surface);
            mCameraDevice.createCaptureSession(Arrays.asList(surface, this.mImageReader.getSurface()), new CameraCaptureSession.StateCallback(){

                public void onConfigured(@NonNull CameraCaptureSession cameraCaptureSession) {
                    if (null == mCameraDevice) {
                        return;
                    }
                    Camera2Helper.this.mCaptureSession = cameraCaptureSession;
                    try {
                        Camera2Helper.this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AF_MODE, (Object)4);
                        Camera2Helper.this.setAutoFlash(Camera2Helper.this.mPreviewRequestBuilder);
                        Camera2Helper.this.mPreviewRequest = Camera2Helper.this.mPreviewRequestBuilder.build();
                        Camera2Helper.this.mCaptureSession.setRepeatingRequest(Camera2Helper.this.mPreviewRequest, Camera2Helper.this.mCaptureCallback, Camera2Helper.this.mBackgroundHandler);
                    }
                    catch (CameraAccessException e) {
                        e.printStackTrace();
                    }
                }

                public void onConfigureFailed(@NonNull CameraCaptureSession cameraCaptureSession) {
                }
            }, null);
        }
        catch (CameraAccessException e) {
            e.printStackTrace();
        }
    }

    private void setUpCameraOutputs(int width, int height) {
        try {
            for (String cameraId : manager.getCameraIdList()) {
                CameraCharacteristics characteristics = manager.getCameraCharacteristics(cameraId);
                StreamConfigurationMap map = (StreamConfigurationMap)characteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
                if (map == null) continue;
                Size largest = Collections.max(Arrays.asList(map.getOutputSizes(256)), new CompareSizesByArea());
                this.mImageReader = ImageReader.newInstance((int)largest.getWidth(), (int)largest.getHeight(), (int)256, (int)2);
                this.mImageReader.setOnImageAvailableListener(this.mOnImageAvailableListener, this.mBackgroundHandler);
                int displayRotation = activity.getWindowManager().getDefaultDisplay().getRotation();
                this.mSensorOrientation = (Integer)characteristics.get(CameraCharacteristics.SENSOR_ORIENTATION);
                boolean swappedDimensions = false;
                switch (displayRotation) {
                    case 0: 
                    case 2: {
                        if (this.mSensorOrientation != 90 && this.mSensorOrientation != 270) break;
                        swappedDimensions = true;
                        break;
                    }
                    case 1: 
                    case 3: {
                        if (this.mSensorOrientation != 0 && this.mSensorOrientation != 180) break;
                        swappedDimensions = true;
                        break;
                    }
                }
                Point displaySize = new Point();
                activity.getWindowManager().getDefaultDisplay().getSize(displaySize);
                int rotatedPreviewWidth = width;
                int rotatedPreviewHeight = height;
                int maxPreviewWidth = displaySize.x;
                int maxPreviewHeight = displaySize.y;
                if (swappedDimensions) {
                    rotatedPreviewWidth = height;
                    rotatedPreviewHeight = width;
                    maxPreviewWidth = displaySize.y;
                    maxPreviewHeight = displaySize.x;
                }
                if (maxPreviewWidth > 1920) {
                    maxPreviewWidth = 1920;
                }
                if (maxPreviewHeight > 1080) {
                    maxPreviewHeight = 1080;
                }
                this.mPreviewSize = Camera2Helper.chooseOptimalSize(map.getOutputSizes(SurfaceTexture.class), rotatedPreviewWidth, rotatedPreviewHeight, maxPreviewWidth, maxPreviewHeight, largest);
                int orientation = Camera2Helper.activity.getResources().getConfiguration().orientation;
                if (orientation == 2) {
                    this.textureView.setAspectRatio(this.mPreviewSize.getWidth(), this.mPreviewSize.getHeight());
                } else {
                    this.textureView.setAspectRatio(this.mPreviewSize.getHeight(), this.mPreviewSize.getWidth());
                }
                Boolean available = (Boolean)characteristics.get(CameraCharacteristics.FLASH_INFO_AVAILABLE);
                this.mFlashSupported = available == null ? false : available;
                this.mCameraId = cameraId;
                return;
            }
        }
        catch (CameraAccessException e) {
            e.printStackTrace();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private static Size chooseOptimalSize(Size[] choices, int textureViewWidth, int textureViewHeight, int maxWidth, int maxHeight, Size aspectRatio) {
        ArrayList<Size> bigEnough = new ArrayList<Size>();
        ArrayList<Size> notBigEnough = new ArrayList<Size>();
        int w = aspectRatio.getWidth();
        int h = aspectRatio.getHeight();
        for (Size option : choices) {
            if (option.getWidth() > maxWidth || option.getHeight() > maxHeight || option.getHeight() != option.getWidth() * h / w) continue;
            if (option.getWidth() >= textureViewWidth && option.getHeight() >= textureViewHeight) {
                bigEnough.add(option);
                continue;
            }
            notBigEnough.add(option);
        }
        if (bigEnough.size() > 0) {
            return Collections.min(bigEnough, new CompareSizesByArea());
        }
        if (notBigEnough.size() > 0) {
            return Collections.max(notBigEnough, new CompareSizesByArea());
        }
        return choices[0];
    }

    private void openCamera(int width, int height) {
        this.setUpCameraOutputs(width, height);
        this.configureTransform(width, height);
        try {
            if (!this.mCameraOpenCloseLock.tryAcquire(2500L, TimeUnit.MILLISECONDS)) {
                throw new RuntimeException("Time out waiting to lock camera opening.");
            }
            if (ActivityCompat.checkSelfPermission((Context)activity, (String)"android.permission.CAMERA") != 0) {
                return;
            }
            manager.openCamera(this.mCameraId, this.mStateCallback, this.mBackgroundHandler);
        }
        catch (CameraAccessException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted while trying to lock camera opening.", e);
        }
    }

    private void closeCamera() {
        try {
            this.mCameraOpenCloseLock.acquire();
            if (null != this.mCaptureSession) {
                this.mCaptureSession.close();
                this.mCaptureSession = null;
            }
            if (null != mCameraDevice) {
                mCameraDevice.close();
                mCameraDevice = null;
            }
            if (null != this.mImageReader) {
                this.mImageReader.close();
                this.mImageReader = null;
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted while trying to lock camera closing.", e);
        }
        finally {
            this.mCameraOpenCloseLock.release();
        }
    }

    private void configureTransform(int viewWidth, int viewHeight) {
        if (null == this.textureView || null == this.mPreviewSize) {
            return;
        }
        int rotation = activity.getWindowManager().getDefaultDisplay().getRotation();
        Matrix matrix = new Matrix();
        RectF viewRect = new RectF(0.0f, 0.0f, (float)viewWidth, (float)viewHeight);
        RectF bufferRect = new RectF(0.0f, 0.0f, (float)this.mPreviewSize.getHeight(), (float)this.mPreviewSize.getWidth());
        float centerX = viewRect.centerX();
        float centerY = viewRect.centerY();
        if (1 == rotation || 3 == rotation) {
            bufferRect.offset(centerX - bufferRect.centerX(), centerY - bufferRect.centerY());
            matrix.setRectToRect(viewRect, bufferRect, Matrix.ScaleToFit.FILL);
            float scale = Math.max((float)viewHeight / (float)this.mPreviewSize.getHeight(), (float)viewWidth / (float)this.mPreviewSize.getWidth());
            matrix.postScale(scale, scale, centerX, centerY);
            matrix.postRotate((float)(90 * (rotation - 2)), centerX, centerY);
        } else if (2 == rotation) {
            matrix.postRotate(180.0f, centerX, centerY);
        }
        this.textureView.setTransform(matrix);
    }

    public void onDestroyHelper() {
        this.stopBackgroundThread();
        this.closeCamera();
        activity = null;
        this.textureView = null;
        this.listener = null;
    }

    public void setAfterDoListener(AfterDoListener listener) {
        this.listener = listener;
    }

    static {
        ORIENTATIONS = new SparseIntArray();
        mFile = null;
        ORIENTATIONS.append(0, 90);
        ORIENTATIONS.append(1, 0);
        ORIENTATIONS.append(2, 270);
        ORIENTATIONS.append(3, 180);
    }

    public static interface AfterDoListener {
        public void onAfterPreviewBack();

        public void onAfterTakePicture();
    }

    private static class ImageSaver
    implements Runnable {
        private final Image mImage;
        private final File mFile;

        public ImageSaver(Image image, File file) {
            this.mImage = image;
            this.mFile = file;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ByteBuffer buffer = this.mImage.getPlanes()[0].getBuffer();
            byte[] bytes = new byte[buffer.remaining()];
            FileOutputStream output = null;
            buffer.get(bytes);
            try {
                output = new FileOutputStream(this.mFile);
                output.write(bytes);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                this.mImage.close();
                if (null != output) {
                    try {
                        output.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private static class CompareSizesByArea
    implements Comparator<Size> {
        private CompareSizesByArea() {
        }

        @Override
        @RequiresApi(api=21)
        public int compare(Size lhs, Size rhs) {
            return Long.signum((long)lhs.getWidth() * (long)lhs.getHeight() - (long)rhs.getWidth() * (long)rhs.getHeight());
        }
    }
}

