/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.camera;

import android.content.Context;
import android.graphics.PointF;
import android.view.MotionEvent;
import android.view.View;

public abstract class OnGestureListener
implements View.OnTouchListener {
    private final int totalTime = 500;
    private long lastClickTime = 0L;
    Context mContext;
    PointF first = new PointF(0.0f, 0.0f);
    PointF sencond = new PointF(0.0f, 0.0f);
    float distance = 0.0f;
    float total = 0.0f;

    public OnGestureListener(Context context) {
        this.mContext = context;
    }

    public abstract void onStepFingerChange(float var1, float var2);

    public abstract void onStepEnd();

    public abstract void onDoubleClick();

    public boolean onTouch(View v, MotionEvent event) {
        if (event.getActionMasked() == 1) {
            this.distance = 0.0f;
            this.total = 0.0f;
        }
        if (event.getPointerCount() > 1 && event.getActionMasked() == 2) {
            this.first.x = event.getX(0);
            this.first.y = event.getY(0);
            this.sencond.x = event.getX(1);
            this.sencond.y = event.getY(1);
            if (this.distance != 0.0f) {
                int offset = (int)(this.getDistance(this.first, this.sencond) - this.distance);
                this.total += (float)offset;
                this.onStepFingerChange(this.total, offset);
            }
            this.distance = this.getDistance(this.first, this.sencond);
            return true;
        }
        if (event.getActionMasked() == 6) {
            this.distance = 0.0f;
        }
        if (event.getActionMasked() == 1) {
            this.onStepEnd();
        }
        if (0 == event.getAction()) {
            if (System.currentTimeMillis() - this.lastClickTime < 500L) {
                this.onDoubleClick();
                this.lastClickTime = 0L;
            } else {
                this.lastClickTime = System.currentTimeMillis();
            }
        }
        return true;
    }

    private float getDistance(PointF a, PointF b) {
        int py = (int)(Math.pow(b.x - a.x, 2.0) + Math.pow(b.y - a.y, 2.0));
        return (float)Math.sqrt(py);
    }
}

