/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.camera;

import com.xshare.camera.ExecutorEnd;
import com.xshare.camera.RespectScaleQueue;
import com.xshare.camera.TypeRunnable;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

class RespectScalePool
extends ThreadPoolExecutor {
    private ExecutorEnd runEnd;

    public RespectScalePool(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<? extends Runnable> workQueue, RejectedExecutionHandler handler, ExecutorEnd runEnd) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, handler);
        this.runEnd = runEnd;
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
        if (r instanceof TypeRunnable && this.runEnd != null) {
            this.runEnd.executorEnd((TypeRunnable)r);
        }
    }

    public static class RespectScalePolicy
    extends ThreadPoolExecutor.DiscardOldestPolicy {
        private final ExecutorEnd runEnd;

        public RespectScalePolicy(ExecutorEnd runEnd) {
            this.runEnd = runEnd;
        }

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            if (executor.isShutdown()) {
                return;
            }
            if (!(r instanceof TypeRunnable) || !(executor instanceof RespectScalePool)) {
                super.rejectedExecution(r, executor);
                return;
            }
            if (!(executor.getQueue() instanceof RespectScaleQueue)) {
                super.rejectedExecution(r, executor);
                return;
            }
            TypeRunnable typeRunnable = (TypeRunnable)r;
            RespectScaleQueue respectScaleQueue = (RespectScaleQueue)executor.getQueue();
            Object targetRun = respectScaleQueue.poll(typeRunnable.type);
            if (targetRun != null && this.runEnd != null) {
                this.runEnd.executorEnd((TypeRunnable)targetRun);
            }
            executor.execute(r);
        }
    }
}

