/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.camera;

import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.xshare.camera.TypeRunnable;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;

class RespectScaleQueue<T extends TypeRunnable>
implements BlockingQueue<T>,
Serializable {
    ArrayBlockingQueue<T> normalQueue;
    ArrayBlockingQueue<T> scaleQueue;
    int ratio;
    int removeIndex = 0;
    int pollIndex = 0;
    int elementIndex = 0;
    int peekIndex = 0;
    int takeIndex = 0;

    private RespectScaleQueue(int normalSize, int scaleSize) {
        this.normalQueue = new ArrayBlockingQueue(normalSize, true);
        this.scaleQueue = new ArrayBlockingQueue(scaleSize, true);
        this.ratio = (normalSize + scaleSize) / scaleSize;
    }

    public static RespectScaleQueue<TypeRunnable> create(int normalSize, int scaleSize) {
        return new RespectScaleQueue<TypeRunnable>(normalSize, scaleSize);
    }

    @Override
    public boolean add(T t) {
        if (((TypeRunnable)t).getType() == 0) {
            return this.normalQueue.add(t);
        }
        return this.scaleQueue.add(t);
    }

    @Override
    public boolean offer(T t) {
        if (((TypeRunnable)t).getType() == 0) {
            return this.normalQueue.offer(t);
        }
        return this.scaleQueue.offer(t);
    }

    @Override
    public T remove() {
        if (this.removeIndex++ % this.ratio == 0) {
            return (T)((TypeRunnable)this.scaleQueue.remove());
        }
        return (T)((TypeRunnable)this.normalQueue.remove());
    }

    @Override
    @Nullable
    public T poll() {
        if (this.pollIndex++ % this.ratio == 0) {
            return (T)((TypeRunnable)this.scaleQueue.poll());
        }
        return (T)((TypeRunnable)this.normalQueue.poll());
    }

    public T poll(@IntRange(from=0L, to=1L) int type) {
        switch (type) {
            case 0: {
                for (TypeRunnable t : this.normalQueue) {
                    if (t.isImportant()) continue;
                    this.normalQueue.remove(t);
                    return (T)t;
                }
                break;
            }
            case 1: {
                for (TypeRunnable t : this.scaleQueue) {
                    if (t.isImportant()) continue;
                    this.scaleQueue.remove(t);
                    return (T)t;
                }
                break;
            }
        }
        if (type == 0) {
            return (T)((TypeRunnable)this.normalQueue.poll());
        }
        return (T)((TypeRunnable)this.scaleQueue.poll());
    }

    @Override
    public T element() {
        if (this.elementIndex++ % this.ratio == 0) {
            return (T)((TypeRunnable)this.scaleQueue.peek());
        }
        return (T)((TypeRunnable)this.normalQueue.peek());
    }

    @Override
    @Nullable
    public T peek() {
        if (this.peekIndex++ % this.ratio == 0) {
            return (T)((TypeRunnable)this.normalQueue.peek());
        }
        return (T)((TypeRunnable)this.scaleQueue.peek());
    }

    @Override
    public void put(T t) throws InterruptedException {
        if (((TypeRunnable)t).getType() == 0) {
            this.normalQueue.put(t);
        } else {
            this.scaleQueue.put(t);
        }
    }

    @Override
    public boolean offer(T t, long timeout, TimeUnit unit) throws InterruptedException {
        if (((TypeRunnable)t).getType() == 0) {
            return this.normalQueue.offer(t, timeout, unit);
        }
        return this.scaleQueue.offer(t, timeout, unit);
    }

    @Override
    public T take() throws InterruptedException {
        if (this.takeIndex++ % this.ratio != 0) {
            TypeRunnable t = null;
            if (this.normalQueue.size() != 0) {
                t = (TypeRunnable)this.normalQueue.take();
            } else if (this.scaleQueue.size() != 0) {
                t = (TypeRunnable)this.scaleQueue.take();
            }
            return (T)t;
        }
        TypeRunnable t = null;
        if (this.scaleQueue.size() != 0) {
            t = (TypeRunnable)this.scaleQueue.take();
        } else if (this.normalQueue.size() != 0) {
            t = (TypeRunnable)this.normalQueue.take();
        }
        return (T)t;
    }

    @Override
    public T poll(long timeout, TimeUnit unit) throws InterruptedException {
        if (this.pollIndex++ % this.ratio != 0) {
            return (T)((TypeRunnable)this.normalQueue.poll(timeout, unit));
        }
        return (T)((TypeRunnable)this.scaleQueue.poll(timeout, unit));
    }

    @Override
    public int remainingCapacity() {
        return this.normalQueue.remainingCapacity() + this.scaleQueue.remainingCapacity();
    }

    @Override
    public boolean remove(Object o) {
        if (o instanceof TypeRunnable) {
            if (((TypeRunnable)o).getType() == 0) {
                return this.normalQueue.remove(o);
            }
            return this.scaleQueue.remove(o);
        }
        return this.normalQueue.remove(o) || this.scaleQueue.remove(o);
    }

    @Override
    public boolean containsAll(@NonNull Collection<?> c) {
        return this.normalQueue.containsAll(c) || this.scaleQueue.containsAll(c);
    }

    @Override
    public boolean addAll(@NonNull Collection<? extends T> c) {
        if (this.isNormal(c)) {
            return this.normalQueue.addAll(c);
        }
        return this.scaleQueue.addAll(c);
    }

    @Override
    public boolean removeAll(@NonNull Collection<?> c) {
        if (this.isNormal(c)) {
            return this.normalQueue.removeAll(c);
        }
        return this.scaleQueue.removeAll(c);
    }

    @Override
    public boolean retainAll(@NonNull Collection<?> c) {
        if (this.isNormal(c)) {
            return this.normalQueue.retainAll(c);
        }
        return this.scaleQueue.retainAll(c);
    }

    @Override
    public void clear() {
        this.normalQueue.clear();
        this.scaleQueue.clear();
    }

    @Override
    public int size() {
        return this.normalQueue.size() + this.scaleQueue.size();
    }

    @Override
    public boolean isEmpty() {
        return this.normalQueue.isEmpty() && this.scaleQueue.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof TypeRunnable) {
            if (((TypeRunnable)o).getType() == 0) {
                return this.normalQueue.contains(o);
            }
            return this.scaleQueue.contains(o);
        }
        return this.normalQueue.contains(o) || this.scaleQueue.contains(o);
    }

    @Override
    @NonNull
    public Iterator<T> iterator() {
        ArrayBlockingQueue<T> all = new ArrayBlockingQueue<T>(this.normalQueue.size() + this.scaleQueue.size(), true);
        all.addAll(this.normalQueue);
        all.addAll(this.scaleQueue);
        return all.iterator();
    }

    @Override
    @NonNull
    public Object[] toArray() {
        ArrayBlockingQueue<T> all = new ArrayBlockingQueue<T>(this.normalQueue.size() + this.scaleQueue.size(), true);
        all.addAll(this.normalQueue);
        all.addAll(this.scaleQueue);
        return all.toArray();
    }

    @Override
    @NonNull
    public <T1> T1[] toArray(@NonNull T1[] a) {
        if (a.length == 0) {
            return a;
        }
        if (a[0] instanceof TypeRunnable) {
            if (((TypeRunnable)a[0]).getType() == 0) {
                return this.normalQueue.toArray(a);
            }
            return this.scaleQueue.toArray(a);
        }
        return a;
    }

    @Override
    public int drainTo(Collection<? super T> c) {
        if (this.isNormal(c)) {
            return this.normalQueue.drainTo(c);
        }
        return this.scaleQueue.drainTo(c);
    }

    @Override
    public int drainTo(Collection<? super T> c, int maxElements) {
        if (this.isNormal(c)) {
            return this.normalQueue.drainTo(c, maxElements);
        }
        return this.scaleQueue.drainTo(c, maxElements);
    }

    private boolean isNormal(Collection<?> c) {
        Iterator<?> iterator = c.iterator();
        if (iterator.hasNext()) {
            Object o = iterator.next();
            return o instanceof TypeRunnable && ((TypeRunnable)o).getType() == 0;
        }
        return false;
    }
}

