/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.camera;

import android.app.Activity;
import android.content.ContentUris;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.provider.MediaStore;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import androidx.annotation.NonNull;

public class Utils {
    public static int dp2Px(@NonNull Context context, Float dpValue) {
        return (int)TypedValue.applyDimension((int)1, (float)dpValue.floatValue(), (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    public static void requstPermission(Context context) {
        if (Build.VERSION.SDK_INT >= 23 && context instanceof Activity) {
            Activity activity = (Activity)context;
            String[] permissions = new String[]{"android.permission.CAMERA"};
            activity.requestPermissions(permissions, 103);
        }
    }

    public static Boolean checkPermissionCamera(Context context) {
        if (Build.VERSION.SDK_INT >= 23) {
            return context.checkSelfPermission("android.permission.CAMERA") == 0;
        }
        return true;
    }

    public static Uri getMediaUriFromPath(Context context, String path) {
        Uri mediaUri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
        String[] args = new String[]{path.substring(path.lastIndexOf("/") + 1), path.substring(path.lastIndexOf("/") + 1, path.length() - 1)};
        Cursor cursor = context.getContentResolver().query(mediaUri, null, "_display_name= ?", args, null);
        Uri uri = null;
        if (cursor != null) {
            cursor.moveToFirst();
            uri = ContentUris.withAppendedId((Uri)mediaUri, (long)cursor.getLong(cursor.getColumnIndex("_id")));
            cursor.close();
        }
        return uri != null ? uri : Uri.EMPTY;
    }
}

