/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.camera;

import com.xshare.camera.Config;
import com.xshare.camera.ExecutorEnd;
import com.xshare.camera.RespectScalePool;
import com.xshare.camera.RespectScaleQueue;
import com.xshare.camera.TypeRunnable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class WorkThreadServer
implements ExecutorEnd {
    private ThreadPoolExecutor executor;
    private static final int CPU_COUNT = Runtime.getRuntime().availableProcessors();
    private static final int corePoolSize;
    private static final int maximumPoolSize;
    private static final int queueMaxSize;
    private static final int keepAliveTime = 30;
    private final Map<String, Packing> packingMap = new HashMap<String, Packing>();

    private WorkThreadServer() {
        this.executor = !Config.hasDepencidesScale() ? new ThreadPoolExecutor(corePoolSize, maximumPoolSize, 30L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(queueMaxSize, true), new ThreadPoolExecutor.DiscardOldestPolicy()) : new RespectScalePool(corePoolSize, maximumPoolSize, 30L, TimeUnit.SECONDS, RespectScaleQueue.create(queueMaxSize, queueMaxSize), new RespectScalePool.RespectScalePolicy(this), this);
    }

    public static WorkThreadServer createInstance() {
        return new WorkThreadServer();
    }

    public void post(TypeRunnable typeRunnable) {
        if (this.executor != null) {
            this.executor.execute(typeRunnable);
        }
    }

    public void regPostListBack(String tagId, int size, Runnable runnable) {
        this.packingMap.put(tagId, new Packing(tagId, size, runnable));
    }

    public void quit() {
        if (this.executor != null) {
            this.executor.shutdownNow();
            this.executor.getQueue().clear();
            this.executor = null;
        }
    }

    public void clear() {
        if (this.executor != null) {
            this.executor.getQueue().clear();
        }
    }

    @Override
    public void executorEnd(TypeRunnable typeRunnable) {
        if (typeRunnable.type == 1) {
            return;
        }
        if (this.packingMap.size() == 0) {
            return;
        }
        Packing packing = this.packingMap.get(typeRunnable.tagId);
        if (packing == null) {
            return;
        }
        if (packing.completeNum.decrementAndGet() == 0) {
            packing.postListBack.run();
            packing.postListBack = null;
        }
    }

    static {
        maximumPoolSize = corePoolSize = Math.max(2, CPU_COUNT / 2);
        queueMaxSize = Math.max(4, maximumPoolSize);
    }

    private static class Packing {
        private AtomicInteger completeNum;
        private Runnable postListBack;
        private String tagId;

        public Packing(String tagId, int size, Runnable runnable) {
            this.tagId = tagId;
            this.completeNum = new AtomicInteger(size);
            this.postListBack = runnable;
        }
    }
}

